/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.Arrays;
import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.JEP;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.List;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.PostfixMathCommandI;
import pcgen.core.Globals;
import pcgen.util.Logging;

public final class RollingMethods {
    public static int roll(int n, int n2) {
        return RollingMethods.roll(n, n2, n, 0, 0);
    }

    public static int roll(int n) {
        return Globals.getRandomInt(n) + 1;
    }

    public static int roll(int n, int n2, int[] nArray) {
        int[] nArray2 = new int[n];
        while (--n >= 0) {
            nArray2[n] = Globals.getRandomInt(n2);
        }
        Arrays.sort(nArray2);
        int n3 = nArray.length;
        for (int i = 0; i < nArray.length; ++i) {
            n3 += nArray2[nArray[i]];
        }
        return n3;
    }

    public static int roll(int n, int[] nArray) {
        int n2 = 0;
        while (--n >= 0) {
            n2 += nArray[Globals.getRandomInt(nArray.length)];
        }
        return n2;
    }

    public static int roll(int n, int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[n];
        while (--n >= 0) {
            nArray3[n] = nArray[Globals.getRandomInt(nArray.length)];
        }
        Arrays.sort(nArray3);
        int n2 = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            n2 += nArray3[nArray2[i]];
        }
        return n2;
    }

    private static int getLeftIndex(StringBuilder stringBuilder, int n) {
        int n2 = 0;
        while (--n >= 0) {
            char c = stringBuilder.charAt(n);
            if (c == ')') {
                ++n2;
            } else if (c == '(') {
                --n2;
            }
            if (n2 > 0 || c == 'd' || c == '*' || c == '/' || c == ' ' || Character.isDigit(c)) continue;
        }
        return n + 1;
    }

    private static int getRightIndex(StringBuilder stringBuilder, int n) {
        int n2 = 0;
        while (++n < stringBuilder.length()) {
            char c = stringBuilder.charAt(n);
            if (c == '(') {
                ++n2;
            } else if (c == ')') {
                --n2;
            }
            if (n2 > 0 || c == '*' || c == '/' || c == ' ' || Character.isDigit(c)) continue;
        }
        return n;
    }

    public static int roll(String string) {
        int n = 0;
        if (string.length() <= 0) {
            return n;
        }
        StringBuilder stringBuilder = new StringBuilder(string.replaceAll("d%", "1d100"));
        int n2 = stringBuilder.lastIndexOf("d");
        while (n2 != -1) {
            stringBuilder.insert(RollingMethods.getRightIndex(stringBuilder, n2), ')');
            stringBuilder.setCharAt(n2, ',');
            stringBuilder.insert(RollingMethods.getLeftIndex(stringBuilder, n2), "roll(");
            n2 = stringBuilder.lastIndexOf("d", n2 + 4);
        }
        String string2 = stringBuilder.toString();
        string2 = string2.replaceAll("\\[", "list(").replaceAll("\\]", ")");
        JEP jEP = new JEP();
        jEP.addStandardFunctions();
        jEP.addFunction("roll", (PostfixMathCommandI)new Roll());
        jEP.addFunction("top", (PostfixMathCommandI)new Top());
        jEP.addFunction("reroll", (PostfixMathCommandI)new Reroll());
        jEP.addFunction("list", (PostfixMathCommandI)new List());
        jEP.parseExpression(string2);
        if (!jEP.hasError()) {
            n = (int)jEP.getValue();
        } else {
            Logging.errorPrint("Bad dice: " + stringBuilder + ":" + jEP.getErrorInfo());
        }
        return n;
    }

    private static int roll(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int[] nArray = new int[n];
        int n7 = 0;
        int n8 = n3 > n ? n : n3;
        for (n6 = 0; n6 < n; ++n6) {
            nArray[n6] = RollingMethods.roll(n2 - n4) + n4;
        }
        Arrays.sort(nArray);
        if (Logging.isDebugMode()) {
            StringBuffer stringBuffer = new StringBuffer(n << 2);
            stringBuffer.append(nArray[0]);
            if (n > 1) {
                for (int i = 1; i < n; ++i) {
                    stringBuffer.append(" + ").append(nArray[i]);
                }
            }
            Logging.debugPrint(stringBuffer.toString());
        }
        for (n6 = n - n8; n6 < n; ++n6) {
            n7 += nArray[n6];
        }
        return n7 + n5;
    }

    private static class Reroll
    extends PostfixMathCommand {
        public Reroll() {
            this.numberOfParameters = 1;
        }

        public void run(Stack stack) throws ParseException {
            int n;
            Object e = stack.pop();
            if (e instanceof Double) {
                double d = (Double)e;
                if (d > 2.147483647E9) {
                    throw new ParseException("Values greater than 2147483647 not allowed.");
                }
                n = (int)Math.round(d);
                if (n <= 0) {
                    throw new ParseException("Values less than 1 are not allowed");
                }
            } else {
                throw new ParseException("Invalid parameter type");
            }
            stack.push(new Rerolls(n));
        }

        public static class Rerolls {
            private Integer rolls;

            public Rerolls(Integer n) {
                this.rolls = n;
            }

            public Integer getRolls() {
                return this.rolls;
            }
        }
    }

    private static class Top
    extends PostfixMathCommand {
        public Top() {
            this.numberOfParameters = 1;
        }

        public void run(Stack stack) throws ParseException {
            int n;
            Object e = stack.pop();
            if (e instanceof Double) {
                double d = (Double)e;
                if (d > 2.147483647E9) {
                    throw new ParseException("Values greater than 2147483647 not allowed.");
                }
                n = (int)Math.round(d);
                if (n <= 0) {
                    throw new ParseException("Values less than 1 are not allowed");
                }
            } else {
                throw new ParseException("Invalid parameter type");
            }
            stack.push(new TopRolls(n));
        }

        public static class TopRolls {
            private Integer rolls;

            public TopRolls(Integer n) {
                this.rolls = n;
            }

            public Integer getRolls() {
                return this.rolls;
            }
        }
    }

    private static class Roll
    extends PostfixMathCommand {
        public Roll() {
            this.numberOfParameters = -1;
        }

        public void run(Stack stack) throws ParseException {
            int n;
            int n2;
            Object object;
            Object e;
            this.checkStack(stack);
            if (this.curNumberOfParameters < 2) {
                throw new ParseException("Too few parameters");
            }
            if (this.curNumberOfParameters > 4) {
                throw new ParseException("Too many parameters");
            }
            int n3 = 0;
            int[] nArray = null;
            int n4 = 0;
            while (this.curNumberOfParameters > 2) {
                e = stack.pop();
                if (e instanceof Top.TopRolls && n3 == 0) {
                    n3 = ((Top.TopRolls)e).getRolls();
                } else if (e instanceof Reroll.Rerolls && n4 == 0) {
                    n4 = ((Reroll.Rerolls)e).getRolls();
                } else if (e instanceof Vector && this.curNumberOfParameters == 3) {
                    if (n3 != 0) {
                        throw new ParseException("Redundant Arugments");
                    }
                    if (n4 != 0) {
                        throw new ParseException("Reroll not compatable with older syntax, use top(NUMBER) instead");
                    }
                    object = (Vector)e;
                    nArray = new int[((Vector)object).size()];
                    for (int i = 0; i < ((Vector)object).size(); ++i) {
                        nArray[i] = (int)Math.round((Double)((Vector)object).get(i)) - 1;
                    }
                } else {
                    throw new ParseException("Invalid parameter type");
                }
                --this.curNumberOfParameters;
            }
            e = stack.pop();
            object = stack.pop();
            if (e instanceof Vector) {
                Vector vector = (Vector)e;
                e = vector.get(Globals.getRandomInt(vector.size()));
            }
            if (e instanceof Double && object instanceof Double) {
                double d = (Double)object;
                double d2 = (Double)e;
                if (d > 2.147483647E9 || d2 > 2.147483647E9) {
                    throw new ParseException("Values greater than 2147483647 not allowed.");
                }
                n2 = (int)Math.round((Double)object);
                n = (int)Math.round((Double)e);
                if (n3 == 0) {
                    n3 = n2;
                }
            } else {
                throw new ParseException("Invalid parameter type");
            }
            double d = 0.0;
            d = nArray == null ? (double)RollingMethods.roll(n2, n, n3, n4, 0) : (double)RollingMethods.roll(n2, n, nArray);
            stack.push(new Double(d));
        }
    }
}

