/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Region;
import pcgen.cdom.enumeration.SubRace;
import pcgen.cdom.enumeration.SubRegion;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpecialAbility;
import pcgen.core.bonus.BonusObj;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PCTemplate
extends PObject {
    public float getCR(int n, int n2) {
        float f = this.getSafe(ObjectKey.CR_MODIFIER).floatValue();
        for (PCTemplate pCTemplate : this.getConditionalTemplates(n, n2)) {
            f += pCTemplate.getSafe(ObjectKey.CR_MODIFIER).floatValue();
        }
        return f;
    }

    public String getSubRace() {
        SubRace subRace = this.get(ObjectKey.SUBRACE);
        if (subRace == null) {
            if (this.getSafe(ObjectKey.USETEMPLATENAMEFORSUBRACE).booleanValue()) {
                return this.getDisplayName();
            }
            return "None";
        }
        return subRace.toString();
    }

    public String getRegion() {
        Region region = this.get(ObjectKey.REGION);
        if (region == null) {
            if (this.getSafe(ObjectKey.USETEMPLATENAMEFORREGION).booleanValue()) {
                return this.getDisplayName();
            }
            return "None";
        }
        return region.toString();
    }

    public String getSubRegion() {
        SubRegion subRegion = this.get(ObjectKey.SUBREGION);
        if (subRegion == null) {
            if (this.getSafe(ObjectKey.USETEMPLATENAMEFORSUBREGION).booleanValue()) {
                return this.getDisplayName();
            }
            return "None";
        }
        return subRegion.toString();
    }

    public boolean isRemovable() {
        boolean bl = false;
        if (this.getSafe(ObjectKey.VISIBILITY) == Visibility.DEFAULT || this.getSafe(ObjectKey.VISIBILITY) == Visibility.DISPLAY_ONLY) {
            bl = this.getSafe(ObjectKey.REMOVABLE);
        }
        return bl;
    }

    @Override
    public PCTemplate clone() throws CloneNotSupportedException {
        return (PCTemplate)super.clone();
    }

    @Override
    public List<SpecialAbility> addSpecialAbilitiesToList(List<SpecialAbility> list, PlayerCharacter playerCharacter) {
        super.addSpecialAbilitiesToList(list, playerCharacter);
        for (PCTemplate pCTemplate : this.getConditionalTemplates(playerCharacter.getTotalLevels(), playerCharacter.totalHitDice())) {
            pCTemplate.addSpecialAbilitiesToList(list, playerCharacter);
        }
        return list;
    }

    public Point2D.Double getFace() {
        BigDecimal bigDecimal = this.get(ObjectKey.FACE_WIDTH);
        BigDecimal bigDecimal2 = this.get(ObjectKey.FACE_HEIGHT);
        if (bigDecimal == null && bigDecimal2 == null) {
            return null;
        }
        return new Point2D.Double(bigDecimal.doubleValue(), bigDecimal2.doubleValue());
    }

    public List<PCTemplate> getConditionalTemplates(int n, int n2) {
        ArrayList<PCTemplate> arrayList = new ArrayList<PCTemplate>();
        for (PCTemplate pCTemplate : this.getSafeListFor(ListKey.REPEATLEVEL_TEMPLATES)) {
            for (PCTemplate pCTemplate2 : pCTemplate.getSafeListFor(ListKey.LEVEL_TEMPLATES)) {
                if (pCTemplate2.get(IntegerKey.LEVEL) > n) continue;
                arrayList.add(pCTemplate2);
            }
        }
        for (PCTemplate pCTemplate : this.getSafeListFor(ListKey.LEVEL_TEMPLATES)) {
            if (pCTemplate.get(IntegerKey.LEVEL) > n) continue;
            arrayList.add(pCTemplate);
        }
        for (PCTemplate pCTemplate : this.getSafeListFor(ListKey.HD_TEMPLATES)) {
            if (pCTemplate.get(IntegerKey.HD_MAX) > n2 || pCTemplate.get(IntegerKey.HD_MIN) < n2) continue;
            arrayList.add(pCTemplate);
        }
        return arrayList;
    }

    @Override
    public List<BonusObj> getRawBonusList(PlayerCharacter playerCharacter) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>(super.getRawBonusList(playerCharacter));
        for (PCTemplate pCTemplate : this.getSafeListFor(ListKey.REPEATLEVEL_TEMPLATES)) {
            for (PCTemplate pCTemplate2 : pCTemplate.getSafeListFor(ListKey.LEVEL_TEMPLATES)) {
                arrayList.addAll(pCTemplate2.getRawBonusList(playerCharacter));
            }
        }
        for (PCTemplate pCTemplate : this.getSafeListFor(ListKey.LEVEL_TEMPLATES)) {
            arrayList.addAll(pCTemplate.getRawBonusList(playerCharacter));
        }
        for (PCTemplate pCTemplate : this.getSafeListFor(ListKey.HD_TEMPLATES)) {
            arrayList.addAll(pCTemplate.getRawBonusList(playerCharacter));
        }
        return arrayList;
    }

    @Override
    public PObject getActiveEquivalent(PlayerCharacter playerCharacter) {
        return playerCharacter.getTemplateKeyed(this.getKeyName());
    }
}

