/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import pcgen.base.formula.Formula;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMListObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Constants;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.content.HitDie;
import pcgen.cdom.content.KnownSpellIdentifier;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.content.LevelExchange;
import pcgen.cdom.content.Modifier;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Region;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.enumeration.VariableKey;
import pcgen.cdom.helper.ArmorProfProvider;
import pcgen.cdom.helper.ShieldProfProvider;
import pcgen.cdom.helper.WeaponProfProvider;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.list.ClassSkillList;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.list.DomainList;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.CharacterDomain;
import pcgen.core.ClassType;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.SpellProgressionCache;
import pcgen.core.SpellProhibitor;
import pcgen.core.SubClass;
import pcgen.core.SubstitutionClass;
import pcgen.core.Vision;
import pcgen.core.analysis.DomainApplication;
import pcgen.core.analysis.SkillCostCalc;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.analysis.SpellLevel;
import pcgen.core.analysis.SubstitutionLevelSupport;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.CharacterSpell;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.pclevelinfo.PCLevelInfoStat;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.ReferenceContext;
import pcgen.util.InputFactory;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;
import pcgen.util.enumeration.AttackType;
import pcgen.util.enumeration.ProhibitedSpellType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCClass
extends PObject {
    public static final CDOMReference<ClassSkillList> MONSTER_SKILL_LIST;
    public static final CDOMReference<DomainList> ALLOWED_DOMAINS;
    private String specialty = null;
    private HashMap<Integer, Integer> castForLevelMap = null;
    private HashMap<Integer, Integer> hitPointMap = null;
    private int skillPool = 0;
    private String subClassKey = "None";
    private Map<Integer, String> substitutionClassKey = null;
    private String classKey = null;
    protected int level = 0;
    private SpellProgressionCache spellCache = null;
    private boolean spellCacheValid = false;
    SortedMap<Integer, PCClassLevel> levelMap = new TreeMap<Integer, PCClassLevel>();

    public final String getAbbrev() {
        String string = this.get(StringKey.ABB);
        if (string == null) {
            String string2 = this.getDisplayName();
            string = string2.substring(0, Math.min(3, string2.length()));
        }
        return string;
    }

    @Override
    public String getQualifiedKey() {
        if (this.classKey == null) {
            this.classKey = "CLASS:" + this.getKeyName();
        }
        return this.classKey;
    }

    public double getBonusTo(String string, String string2, int n, PlayerCharacter playerCharacter) {
        double d = 0.0;
        List<BonusObj> list = this.getRawBonusList(playerCharacter);
        if (n == 0 || list.isEmpty()) {
            return 0.0;
        }
        String string3 = string.toUpperCase();
        String string4 = string2.toUpperCase();
        for (BonusObj bonusObj : list) {
            StringTokenizer stringTokenizer = new StringTokenizer(bonusObj.toString().toUpperCase(), "|", false);
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            String string5 = stringTokenizer.nextToken();
            if (!string5.equals(string3)) continue;
            String string6 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string6, ",", false);
            while (stringTokenizer2.hasMoreTokens()) {
                String string7 = stringTokenizer2.nextToken();
                if (n2 > n || !string7.equals(string4)) continue;
                String string8 = stringTokenizer.nextToken();
                ArrayList<Prerequisite> arrayList = new ArrayList<Prerequisite>();
                if (bonusObj.hasPrerequisites()) {
                    arrayList.addAll(bonusObj.getPrerequisiteList());
                }
                while (stringTokenizer.hasMoreTokens()) {
                    String string9 = stringTokenizer.nextToken();
                    if (!PreParserFactory.isPreReqString(string9)) continue;
                    Logging.debugPrint("Why is this prerequisite '" + string9 + "' parsed in '" + this.getClass().getName() + ".getBonusTo(String,String,int)' rather than in the persistence layer?");
                    try {
                        PreParserFactory preParserFactory = PreParserFactory.getInstance();
                        arrayList.add(preParserFactory.parse(string9));
                    }
                    catch (PersistenceLayerException persistenceLayerException) {
                        Logging.errorPrint(persistenceLayerException.getMessage(), persistenceLayerException);
                    }
                }
                if (!PrereqHandler.passesAll(arrayList, playerCharacter, null)) continue;
                double d2 = playerCharacter.getVariableValue(string8, this.getQualifiedKey()).doubleValue();
                d += d2;
            }
        }
        return d;
    }

    public int getCastForLevel(int n, String string, PlayerCharacter playerCharacter) {
        return this.getCastForLevel(n, string, true, true, playerCharacter);
    }

    public int getCastForLevel(int n, String string, boolean bl, boolean bl2, PlayerCharacter playerCharacter) {
        int n2;
        Object object;
        int n3;
        PCStat pCStat;
        int n4 = this.getLevel();
        int n5 = 0;
        int n6 = 0;
        String string2 = "CLASS." + this.getKeyName();
        String string3 = ";LEVEL." + n;
        n4 += (int)playerCharacter.getTotalBonusTo("PCLEVEL", this.getKeyName());
        if (this.getNumFromCastList(n4 += (int)playerCharacter.getTotalBonusTo("PCLEVEL", "TYPE." + this.getSpellType()), n, playerCharacter) < 0) {
            return (int)playerCharacter.getTotalBonusTo("SPELLCAST", string2 + string3);
        }
        n5 += (int)playerCharacter.getTotalBonusTo("SPELLCAST", string2 + string3);
        n5 += (int)playerCharacter.getTotalBonusTo("SPELLCAST", "TYPE." + this.getSpellType() + string3);
        n5 += (int)playerCharacter.getTotalBonusTo("SPELLCAST", "CLASS.Any" + string3);
        n5 += (int)playerCharacter.getTotalBonusTo("SPELLCAST", string2 + ";LEVEL.All");
        n5 += (int)playerCharacter.getTotalBonusTo("SPELLCAST", "TYPE." + this.getSpellType() + ";LEVEL.All");
        n5 += (int)playerCharacter.getTotalBonusTo("SPELLCAST", "CLASS.Any;LEVEL.All");
        int n7 = this.bonusSpellIndex();
        if (n7 != -2 && n7 >= 0 && n7 < playerCharacter.getStatList().size()) {
            PCStat pCStat2 = playerCharacter.getStatList().getStatAt(n7);
            n6 = playerCharacter.getStatList().getTotalStatFor(pCStat2.getAbb());
        }
        String string4 = "None";
        if (n7 >= 0) {
            string4 = SettingsHandler.getGame().s_ATTRIBSHORT[n7];
        }
        int n8 = (int)playerCharacter.getTotalBonusTo("STAT", "CAST." + string4) + (int)playerCharacter.getTotalBonusTo("STAT", "BASESPELLSTAT") + (int)playerCharacter.getTotalBonusTo("STAT", "BASESPELLSTAT;CLASS." + this.getKeyName());
        if (n7 > -2 && bl2 && (pCStat = this.get(ObjectKey.SPELL_STAT)) != null && (n3 = playerCharacter.getVariableValue("MAXLEVELSTAT=" + pCStat.getAbb(), "").intValue()) + n8 < n) {
            return n5;
        }
        n6 += n8;
        int n9 = 0;
        if (bl && !string.equals(Globals.getDefaultSpellBook()) && (this.hasSpecialty() || playerCharacter.hasCharacterDomainList())) {
            for (n3 = 0; n3 <= n; ++n3) {
                List<CharacterSpell> list = playerCharacter.getCharacterSpells(this, null, "", n3);
                object = new ArrayList();
                if (!list.isEmpty()) {
                    if (n3 > 0 && "DIVINE".equalsIgnoreCase(this.getSpellType())) {
                        for (CharacterDomain n11 : playerCharacter.getCharacterDomainList()) {
                            if (!n11.isFromPCClass(this.getKeyName()) || n11.getDomain() == null) continue;
                            object = Globals.getSpellsIn(n3, Collections.singletonList(n11.getDomain().get(ObjectKey.DOMAIN_SPELLLIST)), playerCharacter);
                        }
                    }
                    for (CharacterSpell characterSpell : list) {
                        n2 = -1;
                        if (!object.isEmpty()) {
                            if (object.contains(characterSpell.getSpell())) {
                                n2 = 0;
                            }
                        } else {
                            n2 = characterSpell.getInfoIndexFor("", n3, 1);
                        }
                        if (n2 <= -1) continue;
                        PCClass pCClass = this;
                        if (this.subClassKey.length() > 0 && !this.subClassKey.equals("None")) {
                            pCClass = this.getSubClassKeyed(this.subClassKey);
                        }
                        n9 = pCClass.getSpecialtyKnownForLevel(n, playerCharacter);
                        break;
                    }
                }
                if (n9 > 0) break;
            }
        }
        n3 = (int)playerCharacter.getTotalBonusTo("SPELLCASTMULT", string2 + string3);
        if ((n3 += (int)playerCharacter.getTotalBonusTo("SPELLCASTMULT", "TYPE." + this.getSpellType() + string3)) < 1) {
            n3 = 1;
        }
        int n10 = this.getNumFromCastList(n4, n, playerCharacter);
        n5 += n10 * n3 + n9;
        object = Globals.getBonusSpellMap().get(String.valueOf(n));
        if (object != null && !((String)object).equals("0|0")) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, "|");
            int n11 = Integer.parseInt(stringTokenizer.nextToken());
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            if (n6 >= n11) {
                n5 += Math.max(0, (n6 - n11 + n2) / n2);
            }
        }
        return n5;
    }

    public final List<CDOMListObject<Spell>> getClassSpellList(PlayerCharacter playerCharacter) {
        return playerCharacter.getAssocList(this, AssociationListKey.CLASSSPELLLIST);
    }

    public final int getLevel() {
        return this.level;
    }

    public final void setLevelWithoutConsequence(int n) {
        this.level = n;
    }

    public final boolean hasMaxLevel() {
        Integer n = this.get(IntegerKey.LEVEL_LIMIT);
        return n != null && n != -1;
    }

    public final int getSkillPool(PlayerCharacter playerCharacter) {
        int n = 0;
        for (PCLevelInfo pCLevelInfo : playerCharacter.getLevelInfo()) {
            if (!pCLevelInfo.getClassKeyName().equals(this.getKeyName())) continue;
            n += pCLevelInfo.getSkillPointsRemaining();
        }
        return n;
    }

    public final String getSpecialty() {
        return this.specialty;
    }

    public final boolean hasSpecialty() {
        return this.specialty != null;
    }

    public final void addSpecialty(String string) {
        this.specialty = string;
    }

    public String getDisplayClassName() {
        SubClass subClass;
        if (this.subClassKey.length() > 0 && !this.subClassKey.equals("None") && (subClass = this.getSubClassKeyed(this.subClassKey)) != null) {
            return subClass.getDisplayName();
        }
        return this.getDisplayName();
    }

    public String getDisplayClassName(int n) {
        String string = this.getSubstitutionClassKey(n);
        if (string == null) {
            return this.getDisplayClassName();
        }
        String string2 = this.getSubstitutionClassKeyed(string).getDisplayName();
        if (string2 == null) {
            return this.getDisplayClassName();
        }
        return string2;
    }

    public String getFullDisplayClassName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDisplayClassName());
        return stringBuffer.append(" ").append(this.level).toString();
    }

    public HitDie getLevelHitDie(PlayerCharacter playerCharacter, int n) {
        Modifier<HitDie> modifier;
        HitDie hitDie = this.getSafe(ObjectKey.LEVEL_HITDIE);
        Modifier<HitDie> modifier2 = playerCharacter.getRace().get(ObjectKey.HITDIE);
        if (modifier2 != null) {
            hitDie = modifier2.applyModifier(hitDie, this);
        }
        for (PCTemplate object2 : playerCharacter.getTemplateList()) {
            Modifier<HitDie> modifier3;
            if (object2 == null || (modifier3 = object2.get(ObjectKey.HITDIE)) == null) continue;
            hitDie = modifier3.applyModifier(hitDie, this);
        }
        PCClassLevel pCClassLevel = (PCClassLevel)this.levelMap.get(n);
        if (pCClassLevel != null && (modifier = pCClassLevel.get(ObjectKey.HITDIE)) != null) {
            hitDie = modifier.applyModifier(hitDie, this);
        }
        return hitDie;
    }

    public final String getSpellBaseStat() {
        Boolean bl = this.get(ObjectKey.USE_SPELL_SPELL_STAT);
        if (bl == null) {
            return "None";
        }
        if (bl.booleanValue()) {
            return "SPELL";
        }
        Boolean bl2 = this.get(ObjectKey.CASTER_WITHOUT_SPELL_STAT);
        if (bl2.booleanValue()) {
            return "OTHER";
        }
        return this.get(ObjectKey.SPELL_STAT).getAbb();
    }

    public final String getSpellType() {
        String string = this.getSafe(StringKey.SPELLTYPE);
        return string == null ? "None" : string;
    }

    public List<Formula> getCastListForLevel(int n) {
        if (!this.updateSpellCache(false)) {
            return null;
        }
        return this.spellCache.getCastForLevel(n);
    }

    public boolean hasCastList() {
        return this.updateSpellCache(false) && this.spellCache.hasCastProgression();
    }

    public Map<Integer, List<Formula>> getCastProgression() {
        if (!this.updateSpellCache(false)) {
            return null;
        }
        return this.spellCache.getCastProgression();
    }

    public int getHighestLevelSpell() {
        if (!this.updateSpellCache(false)) {
            return -1;
        }
        return Math.max(this.spellCache.getHighestCastSpellLevel(), this.spellCache.getHighestKnownSpellLevel());
    }

    public int getHighestLevelSpell(PlayerCharacter playerCharacter) {
        int n;
        String string = "CLASS." + this.getKeyName();
        int n2 = n = this.getHighestLevelSpell();
        for (int i = n; i < n + 30; ++i) {
            String string2 = ";LEVEL." + i;
            StringBuilder stringBuilder = new StringBuilder();
            if (playerCharacter.getTotalBonusTo("SPELLCAST", stringBuilder.append(string).append(string2).toString()) > 0.0) {
                n2 = i;
                continue;
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            if (!(playerCharacter.getTotalBonusTo("SPELLKNOWN", stringBuilder2.append(string).append(string2).toString()) > 0.0)) continue;
            n2 = i;
        }
        return n2;
    }

    public int getKnownForLevel(int n, PlayerCharacter playerCharacter) {
        return this.getKnownForLevel(n, "null", playerCharacter);
    }

    public Map<Integer, List<Formula>> getKnownMap() {
        if (!this.updateSpellCache(false)) {
            return null;
        }
        return this.spellCache.getKnownProgression();
    }

    public boolean hasKnownList() {
        return this.updateSpellCache(false) && this.spellCache.hasKnownProgression();
    }

    public final Map<Integer, List<Formula>> getSpecialtyKnownList() {
        if (!this.updateSpellCache(false)) {
            return null;
        }
        return this.spellCache.getSpecialtyKnownMap();
    }

    public int getNumFromCastList(int n, int n2, PlayerCharacter playerCharacter) {
        if (n == 0) {
            return -1;
        }
        List<Formula> list = this.getCastListForLevel(n);
        if (list == null || n2 >= list.size()) {
            return -1;
        }
        return list.get(n2).resolve(playerCharacter, "").intValue();
    }

    public String getBonusCastForLevelString(int n, String string, PlayerCharacter playerCharacter) {
        if (this.getCastForLevel(n, string, true, true, playerCharacter) > 0) {
            if (this.hasSpecialty()) {
                PCClass pCClass = this;
                if (this.subClassKey.length() > 0 && !this.subClassKey.equals("None")) {
                    pCClass = this.getSubClassKeyed(this.subClassKey);
                }
                return "+" + pCClass.getSpecialtyKnownForLevel(n, playerCharacter);
            }
            if (!playerCharacter.hasCharacterDomainList()) {
                return "";
            }
            if (n > 0 && "DIVINE".equalsIgnoreCase(this.get(StringKey.SPELLTYPE))) {
                for (CharacterDomain characterDomain : playerCharacter.getCharacterDomainList()) {
                    if (!characterDomain.isFromPCClass(this.getKeyName())) continue;
                    return "+1";
                }
            }
        }
        return "";
    }

    public int getCastForLevel(int n, PlayerCharacter playerCharacter) {
        return this.getCastForLevel(n, Globals.getDefaultSpellBook(), true, true, playerCharacter);
    }

    public int getSpecialtyKnownForLevel(int n, PlayerCharacter playerCharacter) {
        Object object;
        int n2 = (int)playerCharacter.getTotalBonusTo("SPECIALTYSPELLKNOWN", "CLASS." + this.getKeyName() + ";LEVEL." + n);
        n2 += (int)playerCharacter.getTotalBonusTo("SPECIALTYSPELLKNOWN", "TYPE." + this.getSpellType() + ";LEVEL." + n);
        int n3 = this.getLevel();
        n3 += (int)playerCharacter.getTotalBonusTo("PCLEVEL", this.getKeyName());
        n3 += (int)playerCharacter.getTotalBonusTo("PCLEVEL", "TYPE." + this.getSpellType());
        int n4 = this.baseSpellIndex();
        if (n4 != -2 && n4 >= 0 && n4 < playerCharacter.getStatList().size()) {
            object = playerCharacter.getStatList().getStatAt(n4);
            int n5 = playerCharacter.getVariableValue("MAXLEVELSTAT=" + ((PCStat)object).getAbb(), "").intValue();
            if (n > n5) {
                return n2;
            }
        }
        if (this.updateSpellCache(false) && (object = this.spellCache.getSpecialtyKnownForLevel(n3)) != null && object.size() > n) {
            n2 += ((Formula)object.get(n)).resolve(playerCharacter, "").intValue();
        }
        n2 += this.getSafe(IntegerKey.KNOWN_SPELLS_FROM_SPECIALTY);
        object = playerCharacter.getAssoc(this, AssociationKey.DOMAIN_SPELL_COUNT);
        if (object != null) {
            n2 += ((Integer)object).intValue();
        }
        return n2;
    }

    public void setSubstitutionClassKey(String string, Integer n) {
        if (this.substitutionClassKey == null) {
            this.substitutionClassKey = new HashMap<Integer, String>();
        }
        this.substitutionClassKey.put(n, string);
    }

    public String getSubstitutionClassKey(Integer n) {
        if (this.substitutionClassKey == null) {
            return null;
        }
        return this.substitutionClassKey.get(n);
    }

    public void setSubClassKey(PlayerCharacter playerCharacter, String string) {
        SubClass subClass;
        this.subClassKey = string;
        if (!string.equals(this.getKeyName()) && (subClass = this.getSubClassKeyed(string)) != null) {
            this.inheritAttributesFrom(subClass);
        }
        playerCharacter.removeAllAssocs(this, AssociationListKey.SPELL_LIST_CACHE);
        this.getSpellLists(playerCharacter);
    }

    public String getSubClassKey() {
        if (this.subClassKey == null) {
            this.subClassKey = "";
        }
        return this.subClassKey;
    }

    public final SubClass getSubClassKeyed(String string) {
        List<SubClass> list = this.getListFor(ListKey.SUB_CLASS);
        if (list == null) {
            return null;
        }
        for (SubClass subClass : list) {
            if (!subClass.getKeyName().equals(string)) continue;
            return subClass;
        }
        return null;
    }

    public final SubstitutionClass getSubstitutionClassKeyed(String string) {
        List<SubstitutionClass> list = this.getListFor(ListKey.SUBSTITUTION_CLASS);
        if (list == null) {
            return null;
        }
        for (SubstitutionClass substitutionClass : list) {
            if (!substitutionClass.getKeyName().equals(string)) continue;
            return substitutionClass;
        }
        return null;
    }

    public void setHitPoint(int n, Integer n2) {
        if (this.hitPointMap == null) {
            this.hitPointMap = new HashMap();
        }
        this.hitPointMap.put(n, n2);
    }

    public Map<Integer, Integer> getHitPointMap() {
        return new HashMap<Integer, Integer>(this.hitPointMap);
    }

    public int getHitPoint(int n) {
        if (this.hitPointMap == null) {
            return 0;
        }
        Integer n2 = this.hitPointMap.get(n);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public final void setHitPointMap(Map<Integer, Integer> map) {
        this.hitPointMap = null;
        if (map != null) {
            this.hitPointMap = new HashMap<Integer, Integer>(map);
        }
    }

    public boolean isAutoKnownSpell(String string, int n, PlayerCharacter playerCharacter) {
        return this.isAutoKnownSpell(string, n, false, playerCharacter);
    }

    public void setLevel(int n, PlayerCharacter playerCharacter) {
        int n2 = this.level;
        if (n >= 0) {
            this.level = n;
        }
        if (this.level == 1) {
            if (this.level > n2 || playerCharacter.isImporting()) {
                this.addFeatPoolBonus(playerCharacter);
            }
            this.chooseClassSkillList(playerCharacter);
        }
        if (!playerCharacter.isImporting()) {
            playerCharacter.calcActiveBonuses();
        }
        if (this.level == 1 && !playerCharacter.isImporting() && n2 == 0) {
            this.checkForSubClass(playerCharacter);
            this.getSpellLists(playerCharacter);
        }
        if (!playerCharacter.isImporting() && n2 < this.level) {
            this.checkForSubstitutionClass(this.level, playerCharacter);
        }
        for (PCClass pCClass : playerCharacter.getClassList()) {
            pCClass.calculateKnownSpellsForClassLevel(playerCharacter);
        }
        if (n2 > n) {
            playerCharacter.resetEpicCache();
        }
    }

    void addFeatPoolBonus(PlayerCharacter playerCharacter) {
        Integer n = this.get(IntegerKey.LEVELS_PER_FEAT);
        if (n == null) {
            String string = Globals.getBonusFeatString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = n3;
            if (n4 > 0) {
                StringBuffer stringBuffer = new StringBuffer("0|FEAT|PCPOOL|").append("max(CL");
                if (this == playerCharacter.getClassKeyed(playerCharacter.getLevelInfoClassKeyName(0))) {
                    stringBuffer.append("-").append(n2);
                    stringBuffer.append("+").append(n3);
                }
                stringBuffer.append(",0)/").append(n4);
                BonusObj bonusObj = Bonus.newBonus(stringBuffer.toString());
                bonusObj.setCreatorObject(this);
                bonusObj.setSaveToPCG(false);
                playerCharacter.addAssoc(this, AssociationListKey.BONUS, bonusObj);
            }
        }
    }

    protected void removeKnownSpellsForClassLevel(PlayerCharacter playerCharacter) {
        if (!this.containsListFor(ListKey.KNOWN_SPELLS) || playerCharacter.isImporting() || !playerCharacter.getAutoSpells()) {
            return;
        }
        if (!playerCharacter.hasAssocs((Object)this, AssociationListKey.CHARACTER_SPELLS)) {
            return;
        }
        List<? extends CDOMList<Spell>> list = this.getSpellLists(playerCharacter);
        Iterator<CharacterSpell> iterator = playerCharacter.getSafeAssocList(this, AssociationListKey.CHARACTER_SPELLS).iterator();
        while (iterator.hasNext()) {
            CharacterSpell characterSpell = iterator.next();
            Spell spell = characterSpell.getSpell();
            Integer[] integerArray = SpellLevel.levelForKey(spell, list, playerCharacter);
            Integer n = 0;
            while (n < integerArray.length) {
                boolean bl;
                int n2 = integerArray[n];
                if (n2 != -1 && !(bl = this.isAutoKnownSpell(spell.getKeyName(), n2, true, playerCharacter))) {
                    iterator.remove();
                }
                Integer n3 = n;
                Integer n4 = n = Integer.valueOf(n + 1);
            }
        }
    }

    protected void calculateKnownSpellsForClassLevel(PlayerCharacter playerCharacter) {
        if (this.containsListFor(ListKey.KNOWN_SPELLS) && !playerCharacter.isImporting() && playerCharacter.getAutoSpells()) {
            List<Spell> list = Globals.getSpellsIn(-1, this.getSpellLists(playerCharacter), playerCharacter);
            if (list.isEmpty()) {
                return;
            }
            this.calcCastPerDayMapForLevel(playerCharacter);
            int n = this.getMaxCastLevel();
            List<? extends CDOMList<Spell>> list2 = this.getSpellLists(playerCharacter);
            for (Spell object : list) {
                Integer[] integerArray = SpellLevel.levelForKey(object, list2, playerCharacter);
                Integer n2 = 0;
                while (n2 < integerArray.length) {
                    int n3 = integerArray[n2];
                    if (n3 != -1 && n3 <= n && this.isAutoKnownSpell(object.getKeyName(), n3, true, playerCharacter)) {
                        CharacterSpell characterSpell = playerCharacter.getCharacterSpellForSpell(this, object);
                        if (characterSpell == null) {
                            characterSpell = new CharacterSpell(this, object);
                            characterSpell.addInfo(n3, 1, Globals.getDefaultSpellBook());
                            playerCharacter.addAssoc(this, AssociationListKey.CHARACTER_SPELLS, characterSpell);
                        } else if (characterSpell.getSpellInfoFor(Globals.getDefaultSpellBook(), n3, -1) == null) {
                            characterSpell.addInfo(n3, 1, Globals.getDefaultSpellBook());
                        }
                    }
                    n2 = n2 + 1;
                }
            }
            for (CharacterDomain characterDomain : playerCharacter.getCharacterDomainList()) {
                if (characterDomain.getDomain() == null || !characterDomain.isFromPCClass(this.getKeyName())) continue;
                DomainApplication.addSpellsToClassForLevels(playerCharacter, characterDomain.getDomain(), this, 0, n);
            }
        }
    }

    public int getMaxCastLevel() {
        int n = -1;
        if (this.castForLevelMap != null) {
            for (int n2 : this.castForLevelMap.keySet()) {
                Integer n3 = this.castForLevelMap.get(n2);
                if (n3 == null || n3 <= 0 || n2 <= n) continue;
                n = n2;
            }
        }
        return n;
    }

    public int getMaxCastLevel(PlayerCharacter playerCharacter) {
        if (this.castForLevelMap == null) {
            this.calcCastPerDayMapForLevel(playerCharacter);
        }
        return this.getMaxCastLevel();
    }

    public boolean isMonster() {
        Boolean bl = this.get(ObjectKey.IS_MONSTER);
        if (bl != null) {
            return bl;
        }
        for (Type type : this.getTrueTypeList(false)) {
            ClassType classType = SettingsHandler.getGame().getClassTypeByName(type.toString());
            if (classType == null || !classType.isMonster()) continue;
            return true;
        }
        return false;
    }

    public boolean isQualified(PlayerCharacter playerCharacter) {
        return playerCharacter != null && PrereqHandler.passesAll(this.getPrerequisiteList(), playerCharacter, this);
    }

    @Override
    public String getPCCText() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("CLASS:").append(this.getDisplayName());
        stringBuffer.append(super.getPCCText(false));
        stringBuffer.append("\t");
        stringBuffer.append((CharSequence)StringUtil.joinToStringBuffer(Globals.getContext().unparse(this), "\t"));
        String string = System.getProperty("line.separator");
        for (Map.Entry<Integer, PCClassLevel> entry : this.levelMap.entrySet()) {
            stringBuffer.append(string).append(entry.getKey()).append('\t');
            stringBuffer.append((CharSequence)StringUtil.joinToStringBuffer(Globals.getContext().unparse(entry.getValue()), "\t"));
        }
        return stringBuffer.toString();
    }

    @Override
    public void activateBonuses(PlayerCharacter playerCharacter) {
        for (BonusObj bonusObj : this.getRawBonusList(playerCharacter)) {
            if (bonusObj.getPCLevel() > this.level) continue;
            if (bonusObj.hasPrerequisites()) {
                if (bonusObj.qualifies(playerCharacter)) {
                    bonusObj.setApplied(true);
                    continue;
                }
                bonusObj.setApplied(false);
                continue;
            }
            bonusObj.setApplied(true);
        }
    }

    public void addClassSpellList(CDOMListObject<Spell> cDOMListObject, PlayerCharacter playerCharacter) {
        playerCharacter.addAssoc(this, AssociationListKey.CLASSSPELLLIST, cDOMListObject);
        playerCharacter.removeAllAssocs(this, AssociationListKey.SPELL_LIST_CACHE);
    }

    public void clearClassSpellList(PlayerCharacter playerCharacter) {
        playerCharacter.removeAllAssocs(this, AssociationListKey.CLASSSPELLLIST);
    }

    public final void addSubClass(SubClass subClass) {
        subClass.setHitPointMap(this.hitPointMap);
        subClass.put(ObjectKey.LEVEL_HITDIE, this.get(ObjectKey.LEVEL_HITDIE));
        this.addToListFor(ListKey.SUB_CLASS, subClass);
    }

    public final void addSubstitutionClass(SubstitutionClass substitutionClass) {
        substitutionClass.setHitPointMap(this.hitPointMap);
        substitutionClass.put(ObjectKey.LEVEL_HITDIE, this.get(ObjectKey.LEVEL_HITDIE));
        this.addToListFor(ListKey.SUBSTITUTION_CLASS, substitutionClass);
    }

    public void addLevel(PCLevelInfo pCLevelInfo, boolean bl, PlayerCharacter playerCharacter) {
        this.addLevel(pCLevelInfo, bl, false, playerCharacter, true);
    }

    public int attackCycle(AttackType attackType) {
        for (Map.Entry<AttackType, Integer> entry : this.getMapFor(MapKey.ATTACK_CYCLE).entrySet()) {
            if (!attackType.equals((Object)entry.getKey())) continue;
            return entry.getValue();
        }
        return SettingsHandler.getGame().getBabAttCyc();
    }

    public int baseAttackBonus(PlayerCharacter playerCharacter) {
        if (this.level == 0) {
            return 0;
        }
        int n = (int)this.getBonusTo("COMBAT", "BAB", this.level, playerCharacter);
        return n;
    }

    public int baseSpellIndex() {
        if (this.getSafe(ObjectKey.USE_SPELL_SPELL_STAT).booleanValue()) {
            return -2;
        }
        if (this.getSafe(ObjectKey.CASTER_WITHOUT_SPELL_STAT).booleanValue()) {
            return -1;
        }
        PCStat pCStat = this.get(ObjectKey.SPELL_STAT);
        if (pCStat != null) {
            return SettingsHandler.getGame().getStatFromAbbrev(pCStat.getAbb());
        }
        Logging.debugPrint("Found Class: " + this.getDisplayName() + " that did not have any SPELLSTAT defined");
        return -1;
    }

    public int bonusSpellIndex() {
        Boolean bl = this.get(ObjectKey.HAS_BONUS_SPELL_STAT);
        if (bl == null) {
            return this.baseSpellIndex();
        }
        if (bl.booleanValue()) {
            PCStat pCStat = this.get(ObjectKey.BONUS_SPELL_STAT);
            return SettingsHandler.getGame().getStatFromAbbrev(pCStat.getAbb());
        }
        return -1;
    }

    public float calcCR(PlayerCharacter playerCharacter) {
        Formula formula = this.get(FormulaKey.CR);
        if (formula == null) {
            for (Type type : this.getTrueTypeList(false)) {
                String string;
                ClassType classType = SettingsHandler.getGame().getClassTypeByName(type.toString());
                if (classType == null || "0".equals(string = classType.getCRFormula())) continue;
                formula = FormulaFactory.getFormulaFor(string);
            }
        }
        return formula == null ? 0.0f : formula.resolve(playerCharacter, this.getQualifiedKey()).floatValue();
    }

    @Override
    public PCClass clone() {
        PCClass pCClass = null;
        try {
            Object object;
            pCClass = (PCClass)super.clone();
            this.spellCache = null;
            this.spellCacheValid = false;
            List<KnownSpellIdentifier> list = this.getListFor(ListKey.KNOWN_SPELLS);
            if (list != null) {
                pCClass.removeListFor(ListKey.KNOWN_SPELLS);
                object = list.iterator();
                while (object.hasNext()) {
                    Iterator<Map.Entry<Integer, PCClassLevel>> iterator = (KnownSpellIdentifier)object.next();
                    pCClass.addToListFor(ListKey.KNOWN_SPELLS, iterator);
                }
            }
            if ((object = this.getMapFor(MapKey.ATTACK_CYCLE)) != null && !object.isEmpty()) {
                pCClass.removeMapFor(MapKey.ATTACK_CYCLE);
                for (Map.Entry<Integer, PCClassLevel> entry : object.entrySet()) {
                    pCClass.addToMapFor(MapKey.ATTACK_CYCLE, entry.getKey(), entry.getValue());
                }
            }
            if (this.hitPointMap != null) {
                pCClass.hitPointMap = new HashMap<Integer, Integer>(this.hitPointMap);
            }
            this.levelMap = new TreeMap<Integer, PCClassLevel>();
            for (Map.Entry<Integer, PCClassLevel> entry : pCClass.levelMap.entrySet()) {
                this.levelMap.put(entry.getKey(), entry.getValue().clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return pCClass;
    }

    @Override
    public final String toString() {
        return this.getDisplayName();
    }

    public boolean isSpecialtySpell(Spell spell) {
        if (this.hasSpecialty()) {
            return spell.containsInList(ListKey.SPELL_SCHOOL, this.specialty) || spell.containsInList(ListKey.SPELL_SUBSCHOOL, this.specialty) || spell.containsInList(ListKey.SPELL_DESCRIPTOR, this.specialty);
        }
        return false;
    }

    public boolean hasClassSkill(PlayerCharacter playerCharacter, String string) {
        List<ClassSkillList> list = playerCharacter.getAssocList(this, AssociationListKey.CLASSSKILLLIST);
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (ClassSkillList classSkillList : list) {
            PCClass pCClass = Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCClass.class, classSkillList.getLSTformat());
            if (pCClass == null || !SkillCostCalc.hasCSkill(playerCharacter, pCClass, string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasKnownSpells(PlayerCharacter playerCharacter) {
        for (int i = 0; i <= this.getHighestLevelSpell(); ++i) {
            if (this.getKnownForLevel(i, playerCharacter) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasSkill(PlayerCharacter playerCharacter, String string) {
        return this.hasSkill(playerCharacter, string, this);
    }

    private boolean hasSkill(PlayerCharacter playerCharacter, String string, CDOMObject cDOMObject) {
        List<Skill> list = playerCharacter.getAssocList(cDOMObject, AssociationListKey.CSKILL);
        if (list != null) {
            for (Skill skill : list) {
                if (!skill.getKeyName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasXPPenalty() {
        for (Type type : this.getTrueTypeList(false)) {
            ClassType classType = SettingsHandler.getGame().getClassTypeByName(type.toString());
            if (classType == null || classType.getXPPenalty()) continue;
            return false;
        }
        return true;
    }

    public int hitPoints(int n) {
        int n2 = 0;
        for (int i = 0; i <= this.getLevel(); ++i) {
            if (this.getHitPoint(i) <= 0) continue;
            int n3 = this.getHitPoint(i) + n;
            if (n3 < 1) {
                n3 = 1;
            }
            n2 += n3;
        }
        return n2;
    }

    public int recalcSkillPointMod(PlayerCharacter playerCharacter, int n) {
        int n2 = this.getSafe(FormulaKey.START_SKILL_POINTS).resolve(playerCharacter, this.getQualifiedKey()).intValue();
        n2 += (int)playerCharacter.getTotalBonusTo("SKILLPOINTS", "NUMBER");
        if (this.isMonster()) {
            int n3;
            int n4 = (int)playerCharacter.getTotalBonusTo("MONSKILLPTS", "LOCKNUMBER");
            if (n4 > 0) {
                n2 = n4;
            } else if (n == 1 && (n3 = (int)playerCharacter.getTotalBonusTo("MONSKILLPTS", "NUMBER")) != 0) {
                n2 = n3;
            }
            if (n != 1 && n <= (n3 = (int)playerCharacter.getTotalBonusTo("MONNONSKILLHD", "NUMBER"))) {
                n2 = 0;
            }
        }
        n2 = this.updateBaseSkillMod(playerCharacter, n2);
        if (n == 1) {
            if (!SettingsHandler.getGame().isPurchaseStatMode()) {
                playerCharacter.setPoolAmount(0);
            }
            n2 *= playerCharacter.getRace().getSafe(IntegerKey.INITIAL_SKILL_MULT);
            if (playerCharacter.getAge() <= 0) {
                Globals.getBioSet().randomize("AGE", playerCharacter);
            }
        } else {
            n2 *= Globals.getSkillMultiplierForLevel(n);
        }
        return n2;
    }

    public final int skillPool() {
        return this.skillPool;
    }

    public void setSkillPool(int n) {
        this.skillPool = n;
    }

    public boolean zeroCastSpells() {
        if (!this.updateSpellCache(false) || !this.spellCache.hasCastProgression()) {
            return true;
        }
        for (List<Formula> list : this.spellCache.getCastProgression().values()) {
            for (Formula formula : list) {
                try {
                    if (Integer.parseInt(formula.toString()) <= 0) continue;
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        return true;
    }

    public final List<ClassSkillList> getClassSkillList(PlayerCharacter playerCharacter) {
        List<ClassSkillList> list = playerCharacter.getAssocList(this, AssociationListKey.CLASSSKILLLIST);
        if (list == null) {
            ArrayList<ClassSkillList> arrayList = new ArrayList<ClassSkillList>(2);
            ReferenceContext referenceContext = Globals.getContext().ref;
            Class<ClassSkillList> clazz = ClassSkillList.class;
            ClassSkillList classSkillList = referenceContext.silentlyGetConstructedCDOMObject(clazz, this.getKeyName());
            if (classSkillList != null) {
                arrayList.add(classSkillList);
            }
            if (this.subClassKey != null && (classSkillList = referenceContext.silentlyGetConstructedCDOMObject(clazz, this.subClassKey)) != null) {
                arrayList.add(classSkillList);
            }
            return arrayList;
        }
        return list;
    }

    int getKnownForLevel(int n, String string, PlayerCharacter playerCharacter) {
        Object object;
        int n2;
        Object object2;
        int n3 = 0;
        int n4 = 0;
        String string2 = "CLASS." + this.getKeyName();
        String string3 = ";LEVEL." + n;
        int n5 = this.getLevel();
        n5 += (int)playerCharacter.getTotalBonusTo("PCLEVEL", this.getKeyName());
        if (this.updateSpellCache(false) && this.spellCache.hasCastProgression() && this.getNumFromCastList(n5 += (int)playerCharacter.getTotalBonusTo("PCLEVEL", "TYPE." + this.getSpellType()), n, playerCharacter) < 0) {
            return (int)playerCharacter.getTotalBonusTo("SPELLKNOWN", string2 + string3);
        }
        n3 += (int)playerCharacter.getTotalBonusTo("SPELLKNOWN", string2 + string3);
        n3 += (int)playerCharacter.getTotalBonusTo("SPELLKNOWN", "TYPE." + this.getSpellType() + string3);
        n3 += (int)playerCharacter.getTotalBonusTo("SPELLKNOWN", "CLASS.Any" + string3);
        n3 += (int)playerCharacter.getTotalBonusTo("SPELLKNOWN", string2 + ";LEVEL.All");
        n3 += (int)playerCharacter.getTotalBonusTo("SPELLKNOWN", "TYPE." + this.getSpellType() + ";LEVEL.All");
        n3 += (int)playerCharacter.getTotalBonusTo("SPELLKNOWN", "CLASS.Any;LEVEL.All");
        int n6 = this.baseSpellIndex();
        if (n6 != -2 && n6 >= 0 && n6 < playerCharacter.getStatList().size()) {
            object2 = playerCharacter.getStatList().getStatAt(n6);
            n4 = playerCharacter.getStatList().getTotalStatFor(((PCStat)object2).getAbb());
        }
        object2 = "None";
        if (n6 >= 0) {
            object2 = SettingsHandler.getGame().s_ATTRIBSHORT[n6];
        }
        int n7 = (int)playerCharacter.getTotalBonusTo("STAT", "KNOWN." + (String)object2) + (int)playerCharacter.getTotalBonusTo("STAT", "BASESPELLKNOWNSTAT") + (int)playerCharacter.getTotalBonusTo("STAT", "BASESPELLKNOWNSTAT;CLASS." + this.getKeyName());
        if (n6 > -2 && (n2 = playerCharacter.getVariableValue("MAXLEVELSTAT=" + (String)object2, "").intValue()) + n7 < n) {
            return n3;
        }
        n4 += n7;
        n2 = (int)playerCharacter.getTotalBonusTo("SPELLKNOWNMULT", string2 + string3);
        if ((n2 += (int)playerCharacter.getTotalBonusTo("SPELLKNOWNMULT", "TYPE." + this.getSpellType() + string3)) < 1) {
            n2 = 1;
        }
        if (!this.updateSpellCache(false)) {
            return n3;
        }
        if (this.spellCache.hasKnownProgression()) {
            object = this.spellCache.getKnownForLevel(n5);
            if (n >= 0 && n < object.size()) {
                n3 += n2 * object.get(n).resolve(playerCharacter, "").intValue();
                String string4 = Globals.getBonusSpellMap().get(String.valueOf(n));
                if (Globals.checkRule("BONUSSPELLKNOWN") && string4 != null && !string4.equals("0|0")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, "|");
                    int n8 = Integer.parseInt(stringTokenizer.nextToken());
                    int n9 = Integer.parseInt(stringTokenizer.nextToken());
                    if (n4 >= n8) {
                        n3 += Math.max(0, (n4 - n8 + n9) / n9);
                    }
                }
            }
        }
        if (n3 > 0 && n > 0) {
            n3 += this.getSafe(IntegerKey.KNOWN_SPELLS_FROM_SPECIALTY);
            object = playerCharacter.getAssoc(this, AssociationKey.DOMAIN_SPELL_COUNT);
            if (object != null) {
                n3 += ((Integer)object).intValue();
            }
        }
        return n3 += SpellLevel.getNumBonusKnowSpellsForLevel(playerCharacter, this, n);
    }

    public boolean isProhibited(Spell spell, PlayerCharacter playerCharacter) {
        if (!PrereqHandler.passesAll(spell.getPrerequisiteList(), playerCharacter, spell)) {
            return true;
        }
        for (SpellProhibitor object : this.getSafeListFor(ListKey.SPELL_PROHIBITOR)) {
            if (!object.isProhibited(spell, playerCharacter)) continue;
            return true;
        }
        for (SpellProhibitor spellProhibitor : this.getSafeListFor(ListKey.PROHIBITED_SPELLS)) {
            if (!spellProhibitor.isProhibited(spell, playerCharacter)) continue;
            return true;
        }
        List<SpellProhibitor> list = playerCharacter.getAssocList(this, AssociationListKey.PROHIBITED_SCHOOLS);
        if (list != null) {
            for (SpellProhibitor spellProhibitor : list) {
                if (!spellProhibitor.isProhibited(spell, playerCharacter)) continue;
                return true;
            }
        }
        return false;
    }

    String getUdamForLevel(int n, PlayerCharacter playerCharacter, boolean bl) {
        return this.getUDamForEffLevel(n += (int)playerCharacter.getTotalBonusTo("UDAM", "CLASS." + this.getKeyName()), playerCharacter, bl);
    }

    String getUDamForEffLevel(int n, PlayerCharacter playerCharacter, boolean bl) {
        int n2 = Globals.sizeInt(playerCharacter.getSize());
        ReferenceContext referenceContext = Globals.getContext().ref;
        Equipment equipment = referenceContext.silentlyGetConstructedCDOMObject(Equipment.class, "KEY_Unarmed Strike");
        String string = equipment != null ? equipment.getDamage(playerCharacter) : "1d3";
        if (bl) {
            string = Globals.adjustDamage(string, SettingsHandler.getGame().getDefaultSizeAdjustment().getAbbreviation(), SettingsHandler.getGame().getSizeAdjustmentAtIndex(n2).getAbbreviation());
        }
        ArrayList<CDOMObject> arrayList = new ArrayList<CDOMObject>();
        for (int i = n; i >= 1; --i) {
            arrayList.add(this.getClassLevel(i));
        }
        arrayList.add(this);
        for (CDOMObject cDOMObject : arrayList) {
            List<String> list = cDOMObject.getListFor(ListKey.UNARMED_DAMAGE);
            if (list == null) continue;
            if (list.size() == 1) {
                string = list.get(0);
                break;
            }
            string = list.get(n2);
            break;
        }
        return string;
    }

    boolean addLevel(PCLevelInfo pCLevelInfo, boolean bl, boolean bl2, PlayerCharacter playerCharacter, boolean bl3) {
        Cloneable cloneable;
        int n;
        int n2;
        int n3 = this.level + 1;
        boolean bl4 = bl;
        ++this.level;
        if (!bl3) {
            n2 = 0;
            if (!PrereqHandler.passesAll(this.getPrerequisiteList(), playerCharacter, this)) {
                n2 = 1;
                if (!bl2) {
                    ShowMessageDelegate.showMessageDialog("This character does not qualify for level " + this.level, "PCGen", MessageType.ERROR);
                }
            }
            --this.level;
            if (n2 != 0) {
                return false;
            }
        }
        if (this.isMonster()) {
            bl4 = false;
        }
        if (this.hasMaxLevel() && n3 > this.getSafe(IntegerKey.LEVEL_LIMIT) && bl4) {
            if (!bl2) {
                ShowMessageDelegate.showMessageDialog("This class cannot be raised above level " + Integer.toString(this.getSafe(IntegerKey.LEVEL_LIMIT)), "PCGen", MessageType.ERROR);
            }
            return false;
        }
        n2 = playerCharacter.getTotalLevels();
        this.setLevel(n3, playerCharacter);
        playerCharacter.selectTemplates(this, playerCharacter.isImporting());
        PCClassLevel pCClassLevel = this.getClassLevel(n3);
        playerCharacter.selectTemplates(pCClassLevel, playerCharacter.isImporting());
        int n4 = playerCharacter.getMaxCharacterDomains(this, playerCharacter) - playerCharacter.getCharacterDomainUsed();
        if (!playerCharacter.hasDomainSource("PCClass", this.getKeyName(), n3) && n4 > 0) {
            playerCharacter.addDomainSource("PCClass", this.getKeyName(), n3, n4);
        }
        playerCharacter.setAutomaticAbilitiesStable(null, false);
        this.doPlusLevelMods(n3, playerCharacter, pCLevelInfo);
        if (Globals.getUseGUI()) {
            this.rollHP(playerCharacter, this.level, (SettingsHandler.isHPMaxAtFirstClassLevel() ? playerCharacter.totalNonMonsterLevels() : playerCharacter.getTotalLevels()) == 1);
        }
        if (!playerCharacter.isImporting()) {
            this.modDomainsForLevel(n3, true, playerCharacter);
        }
        int n5 = 0;
        if (playerCharacter.getTotalLevels() > n2) {
            int n6;
            n = 1;
            n2 = playerCharacter.getTotalLevels();
            if (this.isMonster()) {
                cloneable = playerCharacter.getRace().get(ObjectKey.MONSTER_CLASS);
                int n7 = 0;
                if (cloneable != null) {
                    n7 = ((LevelCommandFactory)cloneable).getLevelCount().resolve(playerCharacter, "").intValue();
                }
                if (n2 <= n7) {
                    n = 0;
                }
            }
            if (!playerCharacter.isImporting() && n != 0 && (n6 = Globals.getBonusStatsForLevel(n2, playerCharacter)) > 0) {
                playerCharacter.setPoolAmount(playerCharacter.getPoolAmount() + n6);
                if (!bl2 && SettingsHandler.getShowStatDialogAtLevelUp()) {
                    n5 = this.askForStatIncrease(playerCharacter, n6, true);
                }
            }
        }
        n = this.recalcSkillPointMod(playerCharacter, n2);
        if (playerCharacter.getLevelInfoSize() > 0 && (cloneable = playerCharacter.getLevelInfo().get(playerCharacter.getLevelInfoSize() - 1)) != null) {
            ((PCLevelInfo)cloneable).setLevel(this.level);
            ((PCLevelInfo)cloneable).setSkillPointsGained(n);
            ((PCLevelInfo)cloneable).setSkillPointsRemaining(((PCLevelInfo)cloneable).getSkillPointsGained());
        }
        this.skillPool = this.skillPool() + n;
        playerCharacter.setSkillPoints(n + playerCharacter.getSkillPoints());
        if (!playerCharacter.isImporting()) {
            if (n5 > 0) {
                this.askForStatIncrease(playerCharacter, n5, false);
            }
            if (n3 == 1) {
                for (TransitionChoice<Kit> transitionChoice : this.getSafeListFor(ListKey.KIT_CHOICE)) {
                    transitionChoice.act(transitionChoice.driveChoice(playerCharacter), this, playerCharacter);
                }
                TransitionChoice<Region> transitionChoice = this.get(ObjectKey.REGION_CHOICE);
                if (transitionChoice != null) {
                    transitionChoice.act(transitionChoice.driveChoice(playerCharacter), this, playerCharacter);
                }
                this.addAdds(playerCharacter);
                playerCharacter.addNaturalWeapons(this.getListFor(ListKey.NATURAL_WEAPON));
            }
            for (TransitionChoice<Kit> transitionChoice : pCClassLevel.getSafeListFor(ListKey.KIT_CHOICE)) {
                transitionChoice.act(transitionChoice.driveChoice(playerCharacter), pCClassLevel, playerCharacter);
            }
            TransitionChoice<Region> transitionChoice = pCClassLevel.get(ObjectKey.REGION_CHOICE);
            if (transitionChoice != null) {
                transitionChoice.act(transitionChoice.driveChoice(playerCharacter), pCClassLevel, playerCharacter);
            }
            playerCharacter.addNaturalWeapons(pCClassLevel.getListFor(ListKey.NATURAL_WEAPON));
        }
        if (this.isMonster()) {
            return true;
        }
        if (!playerCharacter.isImporting()) {
            this.checkRemovals(playerCharacter);
            int n8 = playerCharacter.minXPForECL();
            if (playerCharacter.getXP() < n8) {
                playerCharacter.setXP(n8);
            } else if (playerCharacter.getXP() >= playerCharacter.minXPForNextECL() && !bl2) {
                ShowMessageDelegate.showMessageDialog(SettingsHandler.getGame().getLevelUpMessage(), "PCGen", MessageType.INFORMATION);
            }
        }
        if (this.containsKey(ObjectKey.EXCHANGE_LEVEL) && this.getLevel() == 1 && !playerCharacter.isImporting()) {
            this.exchangeLevels(playerCharacter);
        }
        return true;
    }

    private void exchangeLevels(PlayerCharacter playerCharacter) {
        LevelExchange levelExchange = this.get(ObjectKey.EXCHANGE_LEVEL);
        try {
            int n;
            PCClass pCClass = levelExchange.getExchangeClass().resolvesTo();
            int n2 = levelExchange.getMinDonatingLevel();
            int n3 = levelExchange.getMaxDonatedLevels();
            int n4 = levelExchange.getDonatingLowerLevelBound();
            PCClass pCClass2 = playerCharacter.getClassKeyed(pCClass.getKeyName());
            if (pCClass2 != null && (n = pCClass2.getLevel()) >= n2) {
                n3 = Math.min(n3, n - n4);
                if (this.hasMaxLevel()) {
                    n3 = Math.min(n3, this.getSafe(IntegerKey.LEVEL_LIMIT) - 1);
                }
                if (n3 > 0) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i = 0; i <= n3; ++i) {
                        arrayList.add(Integer.toString(i));
                    }
                    ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
                    chooserInterface.setTitle("Select number of levels to convert from " + pCClass2.getDisplayName() + " to " + this.getDisplayName());
                    chooserInterface.setTotalChoicesAvail(1);
                    chooserInterface.setPoolFlag(false);
                    chooserInterface.setAvailableList(arrayList);
                    chooserInterface.setVisible(true);
                    List list = chooserInterface.getSelectedList();
                    int n5 = 0;
                    if (!list.isEmpty()) {
                        n5 = Integer.parseInt((String)list.get(0));
                    }
                    if (n5 > 0) {
                        playerCharacter.giveClassesAway(this, pCClass2, n5);
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            ShowMessageDelegate.showMessageDialog("levelExchange:" + Constants.s_LINE_SEP + numberFormatException.getMessage(), "PCGen", MessageType.ERROR);
        }
    }

    void doMinusLevelMods(PlayerCharacter playerCharacter, int n) {
        this.getClassLevel(n).removeAdds(playerCharacter);
        playerCharacter.removeVariable("CLASS:" + this.getKeyName() + "|" + Integer.toString(n));
    }

    void doPlusLevelMods(int n, PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        if (n == 1) {
            this.addVariablesForLevel(0, playerCharacter);
        }
        this.addVariablesForLevel(n, playerCharacter);
        playerCharacter.calcActiveBonuses();
        if (!playerCharacter.isImporting() && playerCharacter.doLevelAbilities()) {
            this.getClassLevel(n).addAdds(playerCharacter);
            this.getClassLevel(n).checkRemovals(playerCharacter);
        }
    }

    @Override
    void fireNameChanged(String string, String string2) {
        if (string.equals(string2)) {
            return;
        }
        for (SpecialAbility specialAbility : this.getSafeListFor(ListKey.SAB)) {
            this.removeFromListFor(ListKey.SAB, specialAbility);
            SpecialAbility object = new SpecialAbility(specialAbility.getKeyName(), specialAbility.getSASource(), specialAbility.getSADesc());
            object.setQualificationClass(string, string2);
            this.addToListFor(ListKey.SAB, object);
        }
        for (PCClassLevel pCClassLevel : this.getClassLevelCollection()) {
            for (SpecialAbility specialAbility : pCClassLevel.getSafeListFor(ListKey.SAB)) {
                if (specialAbility.getSASource().length() == 0) continue;
                pCClassLevel.removeFromListFor(ListKey.SAB, specialAbility);
                SpecialAbility specialAbility2 = new SpecialAbility(specialAbility.getKeyName(), specialAbility.getSASource(), specialAbility.getSADesc());
                specialAbility2.setQualificationClass(string, string2);
                pCClassLevel.addToListFor(ListKey.SAB, specialAbility2);
            }
        }
        for (VariableKey variableKey : this.getVariableKeys()) {
            this.put(variableKey, FormulaFactory.getFormulaFor(this.get(variableKey).toString().replaceAll("=" + string, "=" + string2)));
        }
        PCClass.renameBonusTarget(this, string, string2);
        for (PCClassLevel pCClassLevel : this.getClassLevelCollection()) {
            for (VariableKey variableKey : pCClassLevel.getVariableKeys()) {
                pCClassLevel.put(variableKey, FormulaFactory.getFormulaFor(pCClassLevel.get(variableKey).toString().replaceAll("=" + string, "=" + string2)));
            }
            PCClass.renameBonusTarget(pCClassLevel, string, string2);
        }
    }

    private static void renameBonusTarget(CDOMObject cDOMObject, String string, String string2) {
        List<BonusObj> list = cDOMObject.getListFor(ListKey.BONUS);
        if (list != null) {
            for (BonusObj bonusObj : list) {
                String string3 = bonusObj.toString();
                int n = -1;
                while ((n = string3.indexOf('=' + string, n + 1)) >= 0) {
                    BonusObj bonusObj2 = Bonus.newBonus(string3.substring(0, n + 1) + string2 + string3.substring(n + string.length() + 1));
                    if (bonusObj2 != null) {
                        bonusObj2.setCreatorObject(cDOMObject);
                        cDOMObject.addToListFor(ListKey.BONUS, bonusObj2);
                    }
                    cDOMObject.removeFromListFor(ListKey.BONUS, bonusObj);
                }
            }
        }
    }

    int memorizedSpecialtiesForLevelBook(int n, String string, PlayerCharacter playerCharacter) {
        int n2 = 0;
        List<CharacterSpell> list = playerCharacter.getCharacterSpells(this, null, string, n);
        if (list.isEmpty()) {
            return n2;
        }
        for (CharacterSpell characterSpell : list) {
            if (!characterSpell.isSpecialtySpell()) continue;
            n2 += characterSpell.getSpellInfoFor(string, n, -1).getTimes();
        }
        return n2;
    }

    int memorizedSpellForLevelBook(PlayerCharacter playerCharacter, int n, String string) {
        int n2 = 0;
        List<CharacterSpell> list = playerCharacter.getCharacterSpells(this, null, string, n);
        if (list.isEmpty()) {
            return n2;
        }
        for (CharacterSpell characterSpell : list) {
            n2 += characterSpell.getSpellInfoFor(string, n, -1).getTimes();
        }
        return n2;
    }

    void subLevel(boolean bl, PlayerCharacter playerCharacter) {
        if (playerCharacter != null) {
            Object object;
            int n = playerCharacter.getTotalLevels();
            int n2 = 0;
            PCLevelInfo pCLevelInfo = playerCharacter.getLevelInfoFor(this.getKeyName(), this.level);
            if (pCLevelInfo != null) {
                n2 = pCLevelInfo.getSkillPointsGained();
            } else {
                Logging.errorPrint("ERROR: could not find class/level info for " + this.getDisplayName() + "/" + this.level);
            }
            Integer n3 = 0;
            int n4 = this.level - 1;
            if (this.level > 0) {
                this.setHitPoint(this.level - 1, n3);
            }
            this.setLevel(n4, playerCharacter);
            this.removeKnownSpellsForClassLevel(playerCharacter);
            this.doMinusLevelMods(playerCharacter, n4 + 1);
            this.modDomainsForLevel(n4, false, playerCharacter);
            if (n4 == 0) {
                this.setSubClassKey(playerCharacter, "None");
                for (Skill iterator : playerCharacter.getSkillList()) {
                    SkillRankControl.setZeroRanks(this, playerCharacter, iterator);
                }
                n2 = this.skillPool();
            }
            if (!this.isMonster() && n > playerCharacter.getTotalLevels()) {
                n = playerCharacter.getTotalLevels();
                object = new ArrayList();
                if (pCLevelInfo.getModifiedStats(true) != null) {
                    object.addAll(pCLevelInfo.getModifiedStats(true));
                }
                if (pCLevelInfo.getModifiedStats(false) != null) {
                    object.addAll(pCLevelInfo.getModifiedStats(false));
                }
                if (!object.isEmpty()) {
                    Iterator n5 = object.iterator();
                    block1: while (n5.hasNext()) {
                        PCLevelInfoStat pCLevelInfoStat = (PCLevelInfoStat)n5.next();
                        for (PCStat pCStat : playerCharacter.getStatList()) {
                            if (!pCStat.getAbb().equalsIgnoreCase(pCLevelInfoStat.getStatAbb())) continue;
                            pCStat.setBaseScore(pCStat.getBaseScore() - pCLevelInfoStat.getStatMod());
                            continue block1;
                        }
                    }
                }
            }
            if (!this.isMonster() && n == 0) {
                playerCharacter.setSkillPoints(0);
                playerCharacter.getSkillList().clear();
                playerCharacter.clearRealAbilities(null);
                playerCharacter.setDirty(true);
            } else {
                playerCharacter.setSkillPoints(playerCharacter.getSkillPoints() - n2);
                this.skillPool = this.skillPool() - n2;
            }
            if (this.getLevel() == 0) {
                playerCharacter.getClassList().remove(this);
            }
            playerCharacter.validateCharacterDomains();
            object = this.getClassLevel(n4 + 1);
            for (Equipment equipment : ((CDOMObject)object).getSafeListFor(ListKey.NATURAL_WEAPON)) {
                playerCharacter.removeEquipment(equipment);
                playerCharacter.delEquipSetItem(equipment);
                playerCharacter.setDirty(true);
            }
            if (!playerCharacter.isImporting()) {
                int n5 = playerCharacter.minXPForNextECL();
                if (playerCharacter.getXP() >= n5) {
                    playerCharacter.setXP(n5 - 1);
                }
            }
        } else {
            Logging.errorPrint("No current pc in subLevel()? How did this happen?");
            return;
        }
    }

    private boolean isAutoKnownSpell(String string, int n, boolean bl, PlayerCharacter playerCharacter) {
        Object object;
        List<KnownSpellIdentifier> list = this.getListFor(ListKey.KNOWN_SPELLS);
        if (list == null) {
            return false;
        }
        Spell spell = Globals.getSpellKeyed(string);
        if (bl ? (object = this.castForLevelMap.get(n)) == null || (Integer)object == 0 || spell == null : this.getCastForLevel(n, playerCharacter) == 0 || spell == null) {
            return false;
        }
        if (this.isProhibited(spell, playerCharacter) && !this.isSpecialtySpell(spell)) {
            return false;
        }
        for (KnownSpellIdentifier knownSpellIdentifier : list) {
            if (!knownSpellIdentifier.matchesFilter(spell, n)) continue;
            return true;
        }
        return false;
    }

    private void calcCastPerDayMapForLevel(PlayerCharacter playerCharacter) {
        if (this.castForLevelMap == null) {
            this.castForLevelMap = new HashMap(100);
        }
        for (int i = 0; i < 100; ++i) {
            int n = this.getCastForLevel(i, playerCharacter);
            this.castForLevelMap.put(i, n);
        }
    }

    private void addVariablesForLevel(int n, PlayerCharacter playerCharacter) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getQualifiedKey()).append('|').append(n);
        CDOMObject cDOMObject = n == 0 ? this : this.getClassLevel(n);
        for (VariableKey variableKey : cDOMObject.getVariableKeys()) {
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append((CharSequence)stringBuilder).append('|').append(variableKey.toString()).append('|').append(cDOMObject.get(variableKey));
            playerCharacter.addVariable(stringBuilder2.toString());
        }
    }

    private final int askForStatIncrease(PlayerCharacter playerCharacter, int n, boolean bl) {
        if (bl && !Globals.checkRule("INTBEFORE")) {
            return n;
        }
        String string = "";
        if (bl) {
            string = "\nRaising a stat here may award more skill points.";
        }
        int n2 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl2 = SettingsHandler.getGame().isBonusStatAllowsStack();
        block0: for (int i = 0; i < n; ++i) {
            Object object2;
            StringBuffer stringBuffer = new StringBuffer();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object2 : playerCharacter.getStatList()) {
                int n3 = playerCharacter.getStatList().getTotalStatFor(((PCStat)object2).getAbb());
                int n4 = playerCharacter.getStatList().getBaseStatFor(((PCStat)object2).getAbb());
                stringBuffer.append(((PCStat)object2).getAbb()).append(": ").append(n4);
                if (n4 != n3) {
                    stringBuffer.append(" adjusted: ").append(n3);
                }
                stringBuffer.append(" (").append(playerCharacter.getStatList().getStatModFor(((PCStat)object2).getAbb())).append(")");
                if (bl2 || !hashSet.contains(((PCStat)object2).getAbb())) {
                    stringBuffer.append("\n");
                    arrayList.add(((PObject)object2).getDisplayName());
                    continue;
                }
                stringBuffer.append(" * Already incremented.\n");
            }
            Object[] objectArray = arrayList.toArray(new String[0]);
            object2 = InputFactory.getInputInstance();
            Object object3 = object2.showInputDialog(null, "Choose stat to increment or select Cancel to increment stat on the Summary tab." + string + "\n\n" + "Current Stats:\n" + stringBuffer + "\n", "PCGen", MessageType.INFORMATION, objectArray, objectArray[0]);
            if (object3 == null) continue;
            for (PCStat pCStat : playerCharacter.getStatList()) {
                if (!pCStat.getDisplayName().equalsIgnoreCase(object3.toString())) continue;
                playerCharacter.saveStatIncrease(pCStat.getAbb(), 1, bl);
                pCStat.setBaseScore(pCStat.getBaseScore() + 1);
                playerCharacter.setPoolAmount(playerCharacter.getPoolAmount() - 1);
                hashSet.add(pCStat.getAbb());
                ++n2;
                continue block0;
            }
        }
        return n - n2;
    }

    private void buildSubstitutionClassChoiceList(List<PCClass> list, int n, PlayerCharacter playerCharacter) {
        for (SubstitutionClass substitutionClass : this.getListFor(ListKey.SUBSTITUTION_CLASS)) {
            if (!PrereqHandler.passesAll(substitutionClass.getPrerequisiteList(), playerCharacter, this) || !substitutionClass.hasClassLevel(n) || !SubstitutionLevelSupport.qualifiesForSubstitutionLevel(substitutionClass, playerCharacter, n)) continue;
            list.add(substitutionClass);
        }
        Collections.sort(list);
        list.add(0, this);
    }

    /*
     * WARNING - void declaration
     */
    private void checkForSubClass(PlayerCharacter playerCharacter) {
        void var7_10;
        ArrayList<Object> arrayList;
        List list;
        List<SubClass> list2 = this.getListFor(ListKey.SUB_CLASS);
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(3);
        arrayList2.add("Name");
        arrayList2.add("Cost");
        arrayList2.add("Other");
        ArrayList arrayList3 = new ArrayList();
        boolean bl = !this.getSubClassKey().equals("None") && !this.getSubClassKey().equals("");
        for (SubClass object2 : list2) {
            if (!PrereqHandler.passesAll(object2.getPrerequisiteList(), playerCharacter, this)) continue;
            list = new ArrayList<Object>(3);
            list.add(object2);
            list.add(Integer.toString(object2.getSafe(IntegerKey.COST)));
            list.add(object2.getSupplementalDisplayInfo());
            if (bl && !this.getSubClassKey().equals(object2.getKeyName())) continue;
            arrayList3.add(list);
        }
        Collections.sort(arrayList3, new Comparator<List>(){

            @Override
            public int compare(List list, List list2) {
                try {
                    PCClass pCClass = (PCClass)list.get(0);
                    PCClass pCClass2 = (PCClass)list2.get(0);
                    return pCClass.compareTo(pCClass2);
                }
                catch (RuntimeException runtimeException) {
                    return 0;
                }
            }
        });
        if (this.getSafe(ObjectKey.ALLOWBASECLASS).booleanValue() && (!bl || this.getKeyName().equals(this.getSubClassKey()))) {
            arrayList = new ArrayList<Object>(3);
            arrayList.add(this);
            arrayList.add("0");
            arrayList.add("");
            arrayList3.add(0, arrayList);
        }
        arrayList = ChooserFactory.getChooserInstance();
        arrayList.setTitle("School Choice (Specialisation)");
        arrayList.setMessageText("Make a selection.  The cost column indicates the cost of that selection. If this cost is non-zero, you will be asked to also select items from this list to give up to cover that cost.");
        arrayList.setTotalChoicesAvail(1);
        arrayList.setPoolFlag(false);
        arrayList.setAvailableColumnNames(arrayList2);
        arrayList.setAvailableList(arrayList3);
        if (arrayList3.size() == 1) {
            arrayList.setSelectedList(arrayList3);
        } else if (arrayList3.size() != 0) {
            arrayList.setVisible(true);
        }
        if (!this.getSafe(ObjectKey.ALLOWBASECLASS).booleanValue()) {
            while (arrayList.getSelectedList().size() == 0) {
                arrayList.setVisible(true);
            }
            List list3 = arrayList.getSelectedList();
        } else {
            List list4 = arrayList.getSelectedList();
        }
        if (var7_10.size() == 0) {
            return;
        }
        list = (List)var7_10.get(0);
        if (list.size() == 0) {
            return;
        }
        PCClass pCClass = (PCClass)list.get(0);
        if (!var7_10.isEmpty() && pCClass instanceof SubClass) {
            playerCharacter.removeAllAssocs(this, AssociationListKey.PROHIBITED_SCHOOLS);
            this.specialty = null;
            SubClass subClass = (SubClass)pCClass;
            arrayList3 = new ArrayList();
            for (SubClass subClass2 : list2) {
                if (subClass2.equals(subClass) || !PrereqHandler.passesAll(subClass2.getPrerequisiteList(), playerCharacter, this)) continue;
                List list5 = new ArrayList<Object>(3);
                int n = subClass2.getProhibitCost();
                if (n == 0) continue;
                list5.add(subClass2);
                list5.add(Integer.toString(n));
                list5.add(subClass2.getSupplementalDisplayInfo());
                list5.add(subClass2.getChoice());
                arrayList3.add(list5);
            }
            this.setSubClassKey(playerCharacter, subClass.getKeyName());
            if (subClass.get(ObjectKey.CHOICE) != null) {
                this.addSpecialty(subClass.getChoice());
            }
            arrayList2.add("Specialty");
            if (subClass.getSafe(IntegerKey.COST) != 0) {
                ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
                chooserInterface.setTitle("School Choice (Prohibited)");
                chooserInterface.setAvailableColumnNames(arrayList2);
                chooserInterface.setAvailableList(arrayList3);
                chooserInterface.setMessageText("Make a selection.  You must make as many selections necessary to cover the cost of your previous selections.");
                chooserInterface.setTotalChoicesAvail(subClass.getSafe(IntegerKey.COST));
                chooserInterface.setPoolFlag(true);
                chooserInterface.setCostColumnNumber(1);
                chooserInterface.setNegativeAllowed(true);
                chooserInterface.setVisible(true);
                List list6 = chooserInterface.getSelectedList();
                for (List list5 : list6) {
                    subClass = (SubClass)list5.get(0);
                    SpellProhibitor spellProhibitor = new SpellProhibitor();
                    spellProhibitor.setType(ProhibitedSpellType.SCHOOL);
                    spellProhibitor.addValue(subClass.getChoice());
                    SpellProhibitor spellProhibitor2 = new SpellProhibitor();
                    spellProhibitor2.setType(ProhibitedSpellType.SUBSCHOOL);
                    spellProhibitor2.addValue(subClass.getChoice());
                    playerCharacter.addAssoc(this, AssociationListKey.PROHIBITED_SCHOOLS, spellProhibitor);
                    playerCharacter.addAssoc(this, AssociationListKey.PROHIBITED_SCHOOLS, spellProhibitor2);
                }
            }
        }
    }

    private void checkForSubstitutionClass(int n, PlayerCharacter playerCharacter) {
        List<SubstitutionClass> list = this.getListFor(ListKey.SUBSTITUTION_CLASS);
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("Name");
        ArrayList<PCClass> arrayList2 = new ArrayList<PCClass>();
        this.buildSubstitutionClassChoiceList(arrayList2, this.level, playerCharacter);
        if (arrayList2.size() <= 1) {
            return;
        }
        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
        chooserInterface.setTitle("Substitution Levels");
        chooserInterface.setMessageText("Choose one of the listed substitution levels or the base class(top entry).  Pressing Close will take the standard class level.");
        chooserInterface.setTotalChoicesAvail(1);
        chooserInterface.setPoolFlag(false);
        chooserInterface.setAvailableColumnNames(arrayList);
        chooserInterface.setAvailableList(arrayList2);
        chooserInterface.setVisible(true);
        List list2 = chooserInterface.getSelectedList();
        PCClass pCClass = null;
        if (!list2.isEmpty()) {
            pCClass = (PCClass)list2.get(0);
        }
        if (!list2.isEmpty() && pCClass instanceof SubstitutionClass) {
            SubstitutionClass substitutionClass = (SubstitutionClass)pCClass;
            this.setSubstitutionClassKey(substitutionClass.getKeyName(), n);
            SubstitutionLevelSupport.applyLevelArrayModsToLevel(substitutionClass, this, n, playerCharacter);
            return;
        }
        this.setSubstitutionClassKey(null, n);
    }

    private void chooseClassSkillList(PlayerCharacter playerCharacter) {
        TransitionChoice<ClassSkillList> transitionChoice = this.get(ObjectKey.SKILLLIST_CHOICE);
        if (transitionChoice == null || this.level < 1) {
            return;
        }
        playerCharacter.removeAllAssocs(this, AssociationListKey.CLASSSKILLLIST);
        for (ClassSkillList classSkillList : transitionChoice.driveChoice(playerCharacter)) {
            playerCharacter.addAssoc(playerCharacter, AssociationListKey.CLASSSKILLLIST, classSkillList);
        }
    }

    private void chooseClassSpellList(PlayerCharacter playerCharacter) {
        TransitionChoice<CDOMListObject<Spell>> transitionChoice = this.get(ObjectKey.SPELLLIST_CHOICE);
        if (transitionChoice == null || this.level < 1) {
            return;
        }
        this.clearClassSpellList(playerCharacter);
        for (CDOMListObject<Spell> cDOMListObject : transitionChoice.driveChoice(playerCharacter)) {
            this.addClassSpellList(cDOMListObject, playerCharacter);
        }
    }

    private void inheritAttributesFrom(PCClass pCClass) {
        List<BonusObj> list;
        List<ShieldProfProvider> list2;
        List<ArmorProfProvider> list3;
        QualifiedObject<Boolean> qualifiedObject;
        QualifiedObject<Boolean> qualifiedObject2;
        List<WeaponProfProvider> list4;
        List<QualifiedObject<CDOMReference<Equipment>>> list5;
        TransitionChoice<CDOMListObject<Spell>> transitionChoice;
        PCStat pCStat;
        Boolean bl;
        Comparable<Boolean> comparable;
        Boolean bl2 = pCClass.get(ObjectKey.HAS_BONUS_SPELL_STAT);
        if (bl2 != null) {
            this.put(ObjectKey.HAS_BONUS_SPELL_STAT, bl2);
            comparable = pCClass.get(ObjectKey.BONUS_SPELL_STAT);
            if (comparable != null) {
                this.put(ObjectKey.BONUS_SPELL_STAT, comparable);
            }
        }
        if ((comparable = pCClass.get(ObjectKey.USE_SPELL_SPELL_STAT)) != null) {
            this.put(ObjectKey.USE_SPELL_SPELL_STAT, comparable);
        }
        if ((bl = pCClass.get(ObjectKey.CASTER_WITHOUT_SPELL_STAT)) != null) {
            this.put(ObjectKey.CASTER_WITHOUT_SPELL_STAT, bl);
        }
        if ((pCStat = pCClass.get(ObjectKey.SPELL_STAT)) != null) {
            this.put(ObjectKey.SPELL_STAT, pCStat);
        }
        if ((transitionChoice = pCClass.get(ObjectKey.SPELLLIST_CHOICE)) != null) {
            this.put(ObjectKey.SPELLLIST_CHOICE, transitionChoice);
        }
        if ((list5 = pCClass.getListFor(ListKey.EQUIPMENT)) != null) {
            this.addAllToListFor(ListKey.EQUIPMENT, list5);
        }
        if ((list4 = pCClass.getListFor(ListKey.WEAPONPROF)) != null) {
            this.addAllToListFor(ListKey.WEAPONPROF, list4);
        }
        if ((qualifiedObject2 = pCClass.get(ObjectKey.HAS_DEITY_WEAPONPROF)) != null) {
            this.put(ObjectKey.HAS_DEITY_WEAPONPROF, qualifiedObject2);
        }
        if ((qualifiedObject = pCClass.get(ObjectKey.HAS_ALL_WEAPONPROF)) != null) {
            this.put(ObjectKey.HAS_ALL_WEAPONPROF, qualifiedObject2);
        }
        if ((list3 = pCClass.getListFor(ListKey.AUTO_ARMORPROF)) != null) {
            this.addAllToListFor(ListKey.AUTO_ARMORPROF, list3);
        }
        if ((list2 = pCClass.getListFor(ListKey.AUTO_SHIELDPROF)) != null) {
            this.addAllToListFor(ListKey.AUTO_SHIELDPROF, list2);
        }
        if ((list = pCClass.getListFor(ListKey.BONUS)) != null) {
            this.addAllToListFor(ListKey.BONUS, list);
        }
        try {
            this.ownBonuses();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        for (VariableKey object : pCClass.getVariableKeys()) {
            this.put(object, pCClass.get(object));
        }
        if (pCClass.containsListFor(ListKey.CSKILL)) {
            this.removeListFor(ListKey.CSKILL);
            this.addAllToListFor(ListKey.CSKILL, pCClass.getListFor(ListKey.CSKILL));
        }
        if (pCClass.containsListFor(ListKey.CCSKILL)) {
            this.removeListFor(ListKey.CCSKILL);
            this.addAllToListFor(ListKey.CCSKILL, pCClass.getListFor(ListKey.CCSKILL));
        }
        this.removeListFor(ListKey.KIT_CHOICE);
        this.addAllToListFor(ListKey.KIT_CHOICE, pCClass.getSafeListFor(ListKey.KIT_CHOICE));
        this.remove(ObjectKey.REGION_CHOICE);
        if (pCClass.containsKey(ObjectKey.REGION_CHOICE)) {
            this.put(ObjectKey.REGION_CHOICE, pCClass.get(ObjectKey.REGION_CHOICE));
        }
        this.removeListFor(ListKey.SAB);
        this.addAllToListFor(ListKey.SAB, pCClass.getSafeListFor(ListKey.SAB));
        this.addAllToListFor(ListKey.DAMAGE_REDUCTION, pCClass.getListFor(ListKey.DAMAGE_REDUCTION));
        for (CDOMReference cDOMReference : pCClass.getSafeListMods(Vision.VISIONLIST)) {
            for (AssociatedPrereqObject associatedPrereqObject : pCClass.getListAssociations(Vision.VISIONLIST, cDOMReference)) {
                this.putToList(Vision.VISIONLIST, cDOMReference, associatedPrereqObject);
            }
        }
        if (pCClass instanceof SubClass) {
            this.levelMap.clear();
            this.copyLevelsFrom(pCClass);
        }
        this.addAllToListFor(ListKey.NATURAL_WEAPON, pCClass.getListFor(ListKey.NATURAL_WEAPON));
        this.put(ObjectKey.LEVEL_HITDIE, pCClass.get(ObjectKey.LEVEL_HITDIE));
    }

    private void modDomainsForLevel(int n, boolean bl, PlayerCharacter playerCharacter) {
        CDOMSingleRef<Domain> cDOMSingleRef;
        QualifiedObject<CDOMSingleRef<Domain>> qualifiedObject2;
        if (playerCharacter.isImporting()) {
            return;
        }
        for (QualifiedObject<CDOMSingleRef<Domain>> qualifiedObject2 : this.getSafeListFor(ListKey.DOMAIN)) {
            cDOMSingleRef = qualifiedObject2.getObject(playerCharacter);
            if (cDOMSingleRef == null) continue;
            this.addDomain(playerCharacter, cDOMSingleRef.resolvesTo(), bl);
        }
        Iterator<Object> iterator = this.levelMap.entrySet().iterator();
        while (iterator.hasNext() && (Integer)(qualifiedObject2 = (Map.Entry)iterator.next()).getKey() <= n) {
            cDOMSingleRef = (PCClassLevel)qualifiedObject2.getValue();
            for (QualifiedObject<CDOMSingleRef<Domain>> qualifiedObject3 : ((CDOMObject)((Object)cDOMSingleRef)).getSafeListFor(ListKey.DOMAIN)) {
                CDOMSingleRef<Domain> cDOMSingleRef2 = qualifiedObject3.getObject(playerCharacter);
                if (cDOMSingleRef2 == null) continue;
                this.addDomain(playerCharacter, cDOMSingleRef2.resolvesTo(), bl);
            }
        }
    }

    private void addDomain(PlayerCharacter playerCharacter, Domain domain, boolean bl) {
        if (domain.qualifies(playerCharacter)) {
            String string = domain.getKeyName();
            if (bl) {
                if (!playerCharacter.containsCharacterDomain(this.getKeyName(), string)) {
                    Domain domain2 = domain.clone();
                    CharacterDomain characterDomain = playerCharacter.getNewCharacterDomain(this.getKeyName());
                    Domain domain3 = characterDomain.setDomain(domain2, playerCharacter);
                    playerCharacter.addCharacterDomain(characterDomain);
                    DomainApplication.applyDomain(playerCharacter, domain3);
                }
            } else if (playerCharacter.containsCharacterDomain(string)) {
                playerCharacter.removeCharacterDomain(string);
            }
        }
    }

    public void rollHP(PlayerCharacter playerCharacter, int n, boolean bl) {
        int n2 = 0;
        int n3 = 1 + (int)playerCharacter.getTotalBonusTo("HD", "MIN") + (int)playerCharacter.getTotalBonusTo("HD", "MIN;CLASS." + this.getKeyName());
        int n4 = this.getLevelHitDie(playerCharacter, n).getDie() + (int)playerCharacter.getTotalBonusTo("HD", "MAX") + (int)playerCharacter.getTotalBonusTo("HD", "MAX;CLASS." + this.getKeyName());
        if (Globals.getGameModeHPFormula().length() == 0) {
            if (bl && n == 1 && SettingsHandler.isHPMaxAtFirstLevel()) {
                n2 = n4;
            } else if (!playerCharacter.isImporting()) {
                n2 = Globals.rollHP(n3, n4, this.getDisplayName(), n);
            }
        }
        this.setHitPoint(n - 1, n2 += (int)playerCharacter.getTotalBonusTo("HP", "CURRENTMAXPERLEVEL"));
        playerCharacter.setCurrentHP(playerCharacter.hitPoints());
    }

    private int updateBaseSkillMod(PlayerCharacter playerCharacter, int n) {
        int n2;
        int n3 = n2 = n > 0 ? 1 : 0;
        if (this.getSafe(ObjectKey.MOD_TO_SKILLS).booleanValue() && (n += (int)playerCharacter.getStatBonusTo("MODSKILLPOINTS", "NUMBER")) < 1) {
            n = 1;
        }
        n += playerCharacter.getRace().getSafe(IntegerKey.SKILL_POINTS_PER_LEVEL);
        n = Math.max(n2, n);
        if (!playerCharacter.getTemplateList().isEmpty()) {
            for (PCTemplate pCTemplate : playerCharacter.getTemplateList()) {
                n += pCTemplate.getSafe(IntegerKey.BONUS_CLASS_SKILL_POINTS);
            }
        }
        return n;
    }

    public int getMinLevelForSpellLevel(int n, boolean bl) {
        if (!this.updateSpellCache(false)) {
            return -1;
        }
        return this.spellCache.getMinLevelForSpellLevel(n, bl);
    }

    public int getMaxSpellLevelForClassLevel(int n) {
        if (!this.updateSpellCache(false)) {
            return -1;
        }
        return this.spellCache.getMaxSpellLevelForClassLevel(n);
    }

    public PCClassLevel getClassLevel(int n) {
        if (!this.levelMap.containsKey(n)) {
            PCClassLevel pCClassLevel = new PCClassLevel();
            pCClassLevel.put(IntegerKey.LEVEL, n);
            pCClassLevel.setName(this.getDisplayName() + "(" + n + ")");
            pCClassLevel.put(ObjectKey.PARENT, this);
            pCClassLevel.put(ObjectKey.TOKEN_PARENT, this);
            this.levelMap.put(n, pCClassLevel);
        }
        return (PCClassLevel)this.levelMap.get(n);
    }

    public boolean hasClassLevel(int n) {
        return this.levelMap.containsKey(n);
    }

    public int getClassLevelCount() {
        return this.levelMap.size();
    }

    public Collection<PCClassLevel> getClassLevelCollection() {
        return Collections.unmodifiableCollection(this.levelMap.values());
    }

    public void copyLevelsFrom(PCClass pCClass) {
        for (Map.Entry<Integer, PCClassLevel> entry : pCClass.levelMap.entrySet()) {
            try {
                PCClassLevel pCClassLevel = entry.getValue().clone();
                pCClassLevel.put(ObjectKey.TOKEN_PARENT, this);
                this.levelMap.put(entry.getKey(), pCClassLevel);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
    }

    public int getPCClassLevel(PCClassLevel pCClassLevel) {
        if (this.equals(pCClassLevel.get(ObjectKey.PARENT))) {
            for (Map.Entry<Integer, PCClassLevel> entry : this.levelMap.entrySet()) {
                if (!entry.getValue().equals(pCClassLevel)) continue;
                return entry.getKey();
            }
        }
        return -1;
    }

    public void clearClassLevels() {
        this.levelMap.clear();
    }

    public boolean updateSpellCache(boolean bl) {
        if (bl || !this.spellCacheValid) {
            SpellProgressionCache spellProgressionCache = new SpellProgressionCache();
            for (Map.Entry<Integer, PCClassLevel> entry : this.levelMap.entrySet()) {
                List<Formula> list;
                List<Formula> list2;
                Integer n = entry.getKey();
                PCClassLevel pCClassLevel = entry.getValue();
                List<Formula> list3 = pCClassLevel.getListFor(ListKey.CAST);
                if (list3 != null) {
                    spellProgressionCache.setCast(n, list3);
                }
                if ((list2 = pCClassLevel.getListFor(ListKey.KNOWN)) != null) {
                    spellProgressionCache.setKnown(n, list2);
                }
                if ((list = pCClassLevel.getListFor(ListKey.SPECIALTYKNOWN)) == null) continue;
                spellProgressionCache.setSpecialtyKnown(n, list);
            }
            if (!spellProgressionCache.isEmpty()) {
                this.spellCache = spellProgressionCache;
            }
            this.spellCacheValid = true;
        }
        return this.spellCache != null;
    }

    public String getFullKey() {
        return this.getKeyName();
    }

    @Override
    public String bonusStringPrefix() {
        return "0|";
    }

    public void stealClassLevel(PCClass pCClass, int n) {
        try {
            PCClassLevel pCClassLevel = pCClass.getClassLevel(n).clone();
            pCClassLevel.put(ObjectKey.PARENT, this);
            pCClassLevel.ownBonuses();
            this.levelMap.put(n, pCClassLevel);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    @Override
    public PCClass getActiveEquivalent(PlayerCharacter playerCharacter) {
        return playerCharacter.getClassKeyed(this.getKeyName());
    }

    @Override
    public List<BonusObj> getRawBonusList(PlayerCharacter playerCharacter) {
        List<BonusObj> list = super.getRawBonusList(playerCharacter);
        for (int i = 1; i <= this.level; ++i) {
            List<BonusObj> list2;
            PCClassLevel pCClassLevel = (PCClassLevel)this.levelMap.get(i);
            if (pCClassLevel == null) continue;
            List<BonusObj> list3 = pCClassLevel.getListFor(ListKey.BONUS);
            if (list3 != null) {
                list.addAll(list3);
            }
            if (playerCharacter == null || (list2 = playerCharacter.getAssocList(pCClassLevel, AssociationListKey.BONUS)) == null) continue;
            list.addAll(list2);
        }
        return list;
    }

    @Override
    public void ownBonuses() throws CloneNotSupportedException {
        super.ownBonuses();
        for (PCClassLevel pCClassLevel : this.getClassLevelCollection()) {
            pCClassLevel.ownBonuses();
        }
    }

    @Override
    public List<? extends CDOMList<Spell>> getSpellLists(PlayerCharacter playerCharacter) {
        List<CDOMList<Spell>> list = playerCharacter.getAssocList(this, AssociationListKey.SPELL_LIST_CACHE);
        if (list != null) {
            return list;
        }
        List<CDOMListObject<Spell>> list2 = playerCharacter.getAssocList(this, AssociationListKey.CLASSSPELLLIST);
        if (list2 == null) {
            this.chooseClassSpellList(playerCharacter);
            list2 = playerCharacter.getAssocList(this, AssociationListKey.CLASSSPELLLIST);
            if (list2 == null) {
                ClassSpellList classSpellList = this.get(ObjectKey.CLASS_SPELLLIST);
                playerCharacter.addAssoc(this, AssociationListKey.SPELL_LIST_CACHE, classSpellList);
                return Collections.singletonList(classSpellList);
            }
        }
        for (CDOMListObject<Spell> cDOMListObject : list2) {
            playerCharacter.addAssoc(this, AssociationListKey.SPELL_LIST_CACHE, cDOMListObject);
        }
        return list2;
    }

    @Override
    public String getVariableSource() {
        return "CLASS|" + this.getKeyName();
    }

    static {
        ClassSkillList classSkillList = new ClassSkillList();
        classSkillList.setName("*MonsterSkill");
        MONSTER_SKILL_LIST = CDOMDirectSingleRef.getRef(classSkillList);
        DomainList domainList = new DomainList();
        domainList.setName("*Allowed");
        ALLOWED_DOMAINS = CDOMDirectSingleRef.getRef(domainList);
    }
}

