/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.base.formula.Formula;
import pcgen.cdom.enumeration.KitApply;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.kit.BaseKit;
import pcgen.core.kit.KitStat;
import pcgen.core.kit.KitTable;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;
import pcgen.util.Logging;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Kit
extends PObject
implements Comparable<Object> {
    private List<KitStat> statList = new ArrayList<KitStat>();
    private Map<String, KitTable> tableMap = new HashMap<String, KitTable>();
    private String region = "None";
    private int selectValue = -1;
    private boolean doLevelAbilitiesFlag = true;

    public List<KitStat> getStats() {
        return this.statList;
    }

    public String getRegion() {
        return this.region;
    }

    public void setSellRate(String string) {
    }

    public void setSelectValue(int n) {
        this.selectValue = n;
    }

    public boolean doLevelAbilities() {
        return this.doLevelAbilitiesFlag;
    }

    public void setDoLevelAbilities(boolean bl) {
        this.doLevelAbilitiesFlag = bl;
    }

    public void addStat(KitStat kitStat) {
        if (kitStat != null) {
            if (this.statList == null) {
                this.statList = new ArrayList<KitStat>();
            }
            this.statList.add(kitStat);
        }
    }

    @Override
    public int compareTo(Object object) {
        Kit kit = (Kit)object;
        return this.getKeyName().compareToIgnoreCase(kit.getKeyName());
    }

    public void processKit(PlayerCharacter playerCharacter, List<BaseKit> list) {
        this.processKit(playerCharacter, list, -1);
    }

    public void processKit(PlayerCharacter playerCharacter, List<BaseKit> list, int n) {
        for (KitStat baseKit : this.statList) {
            baseKit.apply(playerCharacter);
        }
        for (BaseKit baseKit : list) {
            baseKit.apply(playerCharacter);
        }
        CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
        if (characterInfo != null) {
            characterInfo.setPaneForUpdate(characterInfo.infoInventory());
            characterInfo.refresh();
        }
        if (this.getSafe(ObjectKey.APPLY_MODE) == KitApply.PERMANENT) {
            playerCharacter.addKit(this);
        }
    }

    public int getBuyRate(PlayerCharacter playerCharacter) {
        QualifiedObject<Formula> qualifiedObject = this.get(ObjectKey.EQUIP_BUY);
        Formula formula = qualifiedObject.getObject(playerCharacter);
        int n = formula == null ? SettingsHandler.getGearTab_BuyRate() : formula.resolve(playerCharacter, "").intValue();
        return n;
    }

    public final boolean isVisible(PlayerCharacter playerCharacter) {
        Visibility visibility = this.getSafe(ObjectKey.VISIBILITY);
        if (visibility == Visibility.QUALIFY) {
            List<Prerequisite> list = this.getPrerequisiteList();
            return PrereqHandler.passesAll(list, playerCharacter, this);
        }
        return visibility == Visibility.DEFAULT;
    }

    public void testApplyKit(PlayerCharacter playerCharacter, List<BaseKit> list, List<String> list2) {
        PlayerCharacter playerCharacter2 = (PlayerCharacter)playerCharacter.clone();
        for (KitStat baseKit : this.statList) {
            baseKit.testApply(this, playerCharacter2, list2);
        }
        for (BaseKit baseKit : this.getSafeListFor(ListKey.KIT_TASKS)) {
            if (!PrereqHandler.passesAll(baseKit.getPrerequisiteList(), playerCharacter2, this) || this.selectValue != -1 && !baseKit.isOption(playerCharacter2, this.selectValue) || !baseKit.testApply(this, playerCharacter2, list2)) continue;
            list.add(baseKit);
        }
    }

    public String getInfo(PlayerCharacter playerCharacter) {
        StringBuffer stringBuffer = new StringBuffer(255);
        stringBuffer.append("<html>");
        stringBuffer.append("<b><font size=+1>");
        stringBuffer.append(OutputNameFormatting.piString(this, false));
        stringBuffer.append("</font></b><br>\n");
        String string = this.getPreReqHTMLStrings(playerCharacter);
        if (string.length() != 0) {
            stringBuffer.append("  <b>Requirements</b>: ").append(string);
        }
        ArrayList<BaseKit> arrayList = new ArrayList<BaseKit>();
        arrayList.addAll(this.getSafeListFor(ListKey.KIT_TASKS));
        Collections.sort(arrayList, new ObjectTypeComparator());
        String string2 = "";
        for (BaseKit baseKit : arrayList) {
            String string3 = baseKit.getObjectName();
            if (!string3.equals(string2)) {
                if (!"".equals(string2)) {
                    stringBuffer.append("; ");
                }
                stringBuffer.append("  <b>" + string3 + "</b>: ");
                string2 = string3;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(baseKit.toString());
        }
        stringBuffer.append("  <b>Source</b>: ").append(this.getDefaultSourceString());
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    private String getPreReqHTMLStrings(PlayerCharacter playerCharacter) {
        return PrerequisiteUtilities.preReqHTMLStringsForList(playerCharacter, this, this.getPrerequisiteList(), false);
    }

    public static void applyKit(Kit kit, PlayerCharacter playerCharacter) {
        if (kit == null) {
            return;
        }
        if (kit.getSafe(ObjectKey.APPLY_MODE) == KitApply.PERMANENT && playerCharacter.getKitInfo().contains(kit)) {
            return;
        }
        ArrayList<BaseKit> arrayList = new ArrayList<BaseKit>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        kit.testApplyKit(playerCharacter, arrayList, arrayList2);
        if (arrayList2.size() != 0) {
            Logging.log(Logging.WARNING, "The following warnings were encountered when applying the kit " + kit.getKeyName());
            for (String string : arrayList2) {
                Logging.log(Logging.WARNING, "  " + string);
            }
        }
        kit.processKit(playerCharacter, arrayList, 0);
    }

    public KitTable getTable(String string) {
        return this.tableMap.get(string);
    }

    public KitTable addTable(KitTable kitTable) {
        return this.tableMap.put(kitTable.getTableName(), kitTable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectTypeComparator
    implements Comparator<BaseKit> {
        private ObjectTypeComparator() {
        }

        @Override
        public int compare(BaseKit baseKit, BaseKit baseKit2) {
            String string = baseKit.getObjectName();
            String string2 = baseKit2.getObjectName();
            return string.compareTo(string2);
        }
    }
}

