/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedMap;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Ability;
import pcgen.core.Campaign;
import pcgen.core.Categorisable;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PointBuyCost;
import pcgen.core.PointBuyMethod;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.persistence.PersistenceManager;
import pcgen.persistence.lst.CampaignOutput;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomData {
    private static final String AUTO_GEN_WARN_LINE_1 = "#This file auto-generated by PCGen. Manual editing not recommended.";
    private static final String AUTO_GEN_WARN_LINE_2 = "#Ensure PCGen is not running before editing. Make backups as errors may result in data loss.";

    private CustomData() {
    }

    public static BufferedReader getCustomEquipmentReader() {
        return CustomData.getReader(CustomData.customEquipmentFilePath());
    }

    public static String customBioSetFilePath(boolean bl) {
        return CustomData.getCustomPath("BioSet", bl);
    }

    public static String customClassFilePath(boolean bl) {
        return CustomData.getCustomPath("Classes", bl);
    }

    public static String customDeityFilePath(boolean bl) {
        return CustomData.getCustomPath("Deities", bl);
    }

    public static String customDomainFilePath(boolean bl) {
        return CustomData.getCustomPath("Domains", bl);
    }

    public static String customAbilityFilePath(boolean bl) {
        return CustomData.getCustomPath("Abilities", bl);
    }

    public static String customFeatFilePath(boolean bl) {
        return CustomData.getCustomPath("Feats", bl);
    }

    public static String customLanguageFilePath(boolean bl) {
        return CustomData.getCustomPath("Languages", bl);
    }

    public static String customPurchaseModeFilePath(boolean bl, String string) {
        return CustomData.getCustomPath("PointBuyMethods", bl, string);
    }

    public static String customRaceFilePath(boolean bl) {
        return CustomData.getCustomPath("Races", bl);
    }

    public static String customSkillFilePath(boolean bl) {
        return CustomData.getCustomPath("Skills", bl);
    }

    public static String customSpellFilePath(boolean bl) {
        return CustomData.getCustomPath("Spells", bl);
    }

    public static String customTemplateFilePath(boolean bl) {
        return CustomData.getCustomPath("Templates", bl);
    }

    public static void writeCustomFiles() {
        CustomData.ensureCustomDirExists();
        CustomData.writePurchaseModeConfiguration();
        if (!PersistenceManager.getInstance().isCustomItemsLoaded()) {
            return;
        }
        CustomData.writeCustomBioSet();
        CustomData.writeCustomClasses();
        CustomData.writeCustomDeities();
        CustomData.writeCustomDomains();
        CustomData.writeCustomAbilities();
        CustomData.writeCustomFeats();
        CustomData.writeCustomItems();
        CustomData.writeCustomLanguages();
        CustomData.writeCustomRaces();
        CustomData.writeCustomSkills();
        CustomData.writeCustomSpells();
        CustomData.writeCustomTemplates();
        CustomData.writeCustomSources();
    }

    private static void ensureCustomDirExists() {
        File file = new File(SettingsHandler.getPcgenCustomDir().getAbsolutePath() + File.separator + SettingsHandler.getGame().getName());
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (SecurityException securityException) {
                Logging.errorPrint("Unable to create custom data directory '" + file.getPath() + "' due the following error.", securityException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCustomItems() {
        if (!PersistenceManager.getInstance().isCustomItemsLoaded()) {
            return;
        }
        CustomData.ensureCustomDirExists();
        BufferedWriter bufferedWriter = CustomData.getCustomEquipmentWriter();
        if (bufferedWriter == null) {
            return;
        }
        try {
            bufferedWriter.write(AUTO_GEN_WARN_LINE_1);
            bufferedWriter.newLine();
            bufferedWriter.write(AUTO_GEN_WARN_LINE_2);
            bufferedWriter.newLine();
            for (Equipment equipment : Globals.getContext().ref.getConstructedCDOMObjects(Equipment.class)) {
                if (!equipment.isType("Custom") || equipment.isType("AUTO_GEN")) continue;
                equipment.save(bufferedWriter);
            }
        }
        catch (IOException iOException) {
            Logging.errorPrint("Error in writeCustomItems", iOException);
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                Logging.errorPrint("Error in writeCustomItems while closing", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePurchaseModeConfiguration() {
        CustomData.ensureCustomDirExists();
        BufferedWriter bufferedWriter = CustomData.getPurchaseModeWriter();
        SortedMap<Integer, PointBuyCost> sortedMap = SettingsHandler.getGame().getPointBuyStatCostMap();
        if (bufferedWriter == null || sortedMap == null) {
            return;
        }
        try {
            Object object;
            bufferedWriter.write("#");
            bufferedWriter.newLine();
            bufferedWriter.write(AUTO_GEN_WARN_LINE_1);
            bufferedWriter.newLine();
            bufferedWriter.write(AUTO_GEN_WARN_LINE_2);
            bufferedWriter.newLine();
            bufferedWriter.write("#");
            bufferedWriter.newLine();
            bufferedWriter.write("# Point-buy ability score costs");
            bufferedWriter.newLine();
            bufferedWriter.write("#");
            bufferedWriter.newLine();
            if (sortedMap.size() > 0) {
                for (Integer n : sortedMap.keySet()) {
                    object = (PointBuyCost)sortedMap.get(n);
                    bufferedWriter.write("STAT:" + n.toString() + "\t\tCOST:" + Integer.toString(((PointBuyCost)object).getStatCost()));
                    int n2 = ((PointBuyCost)object).getPreReqCount();
                    if (n2 != 0) {
                        StringWriter stringWriter = new StringWriter();
                        for (int i = 0; i < n2; ++i) {
                            Prerequisite prerequisite = ((PointBuyCost)object).getPreReq(i);
                            PrerequisiteWriter prerequisiteWriter = new PrerequisiteWriter();
                            try {
                                stringWriter.write("\t");
                                prerequisiteWriter.write(stringWriter, prerequisite);
                                continue;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        bufferedWriter.write(stringWriter.toString());
                    }
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.write("#");
            bufferedWriter.newLine();
            bufferedWriter.write("# Point-buy methods");
            bufferedWriter.newLine();
            bufferedWriter.write("#");
            bufferedWriter.newLine();
            int n = SettingsHandler.getGame().getPurchaseMethodCount();
            for (int i = 0; i < n; ++i) {
                object = SettingsHandler.getGame().getPurchaseMethod(i);
                bufferedWriter.write("METHOD:" + ((PointBuyMethod)object).getMethodName() + "\t\tPOINTS:" + ((PointBuyMethod)object).getPointFormula());
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            Logging.errorPrint("Error in writePurchaseModeConfiguration", iOException);
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                Logging.errorPrint("Error in writePurchaseModeConfiguration while closing", iOException);
            }
        }
    }

    private static BufferedWriter getCustomEquipmentWriter() {
        return CustomData.getWriter(CustomData.customEquipmentFilePath());
    }

    private static String getCustomPath(String string, boolean bl, String string2) {
        String string3 = "";
        if (bl) {
            string3 = SettingsHandler.getPcgenCustomDir().getAbsolutePath();
            string3 = string3 + File.separator + string2;
        }
        return string3 + File.separator + "custom" + string + ".lst";
    }

    private static String getCustomPath(String string, boolean bl) {
        return CustomData.getCustomPath(string, bl, SettingsHandler.getGame().getName());
    }

    private static BufferedWriter getPurchaseModeWriter() {
        return CustomData.getWriter(CustomData.customPurchaseModeFilePath(true, SettingsHandler.getGame().getName()));
    }

    private static BufferedReader getReader(String string) {
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
        }
        catch (IOException iOException) {
            Logging.debugPrint("Could not get a reader to read from " + string, iOException);
            return null;
        }
    }

    private static BufferedWriter getWriter(String string) {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
        }
        catch (IOException iOException) {
            Logging.errorPrint("Could not get a writer to write to " + string + " \nThis means that your custom files won't be written. Please check the path.", iOException);
            return null;
        }
    }

    private static String customEquipmentFilePath() {
        return CustomData.getCustomPath("Equipment", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCustomBioSet() {
        BufferedWriter bufferedWriter = CustomData.getWriter(CustomData.customBioSetFilePath(true));
        if (bufferedWriter == null) {
            return;
        }
        try {
            bufferedWriter.write("#");
            bufferedWriter.newLine();
            bufferedWriter.write(AUTO_GEN_WARN_LINE_1);
            bufferedWriter.newLine();
            bufferedWriter.write(AUTO_GEN_WARN_LINE_2);
            bufferedWriter.newLine();
            bufferedWriter.write("#");
            bufferedWriter.newLine();
            for (Race race : Globals.getContext().ref.getConstructedCDOMObjects(Race.class)) {
                if (!race.isType("Custom")) continue;
                String[] stringArray = Globals.getContext().unparseSubtoken(race, "REGION");
                String string = stringArray == null ? "None" : stringArray[0];
                String string2 = race.getKeyName();
                bufferedWriter.write(Globals.getBioSet().getRacePCCText(string, string2));
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            Logging.errorPrint("Error in writeCustomBioSet", iOException);
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                Logging.errorPrint("Error in writeCustomBioSet while closing", iOException);
            }
        }
    }

    private static void writeCustomClasses() {
        CustomData.writeCustomPObjects(CustomData.customClassFilePath(true), Globals.getContext().ref.getConstructedCDOMObjects(PCClass.class).iterator());
    }

    private static void writeCustomDeities() {
        CustomData.writeCustomPObjects(CustomData.customDeityFilePath(true), Globals.getContext().ref.getConstructedCDOMObjects(Deity.class).iterator());
    }

    private static void writeCustomDomains() {
        CustomData.writeCustomPObjects(CustomData.customDomainFilePath(true), Globals.getContext().ref.getConstructedCDOMObjects(Domain.class).iterator());
    }

    private static void writeCustomAbilities() {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        Iterator<Categorisable> iterator = Globals.getAbilityKeyIterator("ALL");
        while (iterator.hasNext()) {
            arrayList.add((Ability)iterator.next());
        }
        CustomData.writeCustomPObjects(CustomData.customAbilityFilePath(true), arrayList.iterator());
    }

    private static void writeCustomFeats() {
        File file = new File(CustomData.customFeatFilePath(true));
        file.delete();
    }

    private static void writeCustomHeader(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("#");
        bufferedWriter.newLine();
        bufferedWriter.write(AUTO_GEN_WARN_LINE_1);
        bufferedWriter.newLine();
        bufferedWriter.write(AUTO_GEN_WARN_LINE_2);
        bufferedWriter.newLine();
        bufferedWriter.write("#");
        bufferedWriter.newLine();
        bufferedWriter.write("SOURCELONG:Custom\tSOURCESHORT:Custom");
        bufferedWriter.newLine();
    }

    private static void writeCustomLanguages() {
        CustomData.writeCustomPObjects(CustomData.customLanguageFilePath(true), Globals.getContext().ref.getConstructedCDOMObjects(Language.class).iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCustomPObjects(String string, Iterator<? extends PObject> iterator) {
        BufferedWriter bufferedWriter = CustomData.getWriter(string);
        if (bufferedWriter == null) {
            return;
        }
        try {
            CustomData.writeCustomHeader(bufferedWriter);
            while (iterator.hasNext()) {
                PObject pObject = iterator.next();
                if (!pObject.isType("Custom")) continue;
                bufferedWriter.write(pObject.getPCCText());
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            Logging.errorPrint("Error in writeCustomPObjects", iOException);
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                Logging.errorPrint("Error in writeCustomPObjects while closing", iOException);
            }
        }
    }

    private static void writeCustomRaces() {
        CustomData.writeCustomPObjects(CustomData.customRaceFilePath(true), Globals.getContext().ref.getConstructedCDOMObjects(Race.class).iterator());
    }

    private static void writeCustomSkills() {
        CustomData.writeCustomPObjects(CustomData.customSkillFilePath(true), Globals.getContext().ref.getConstructedCDOMObjects(Skill.class).iterator());
    }

    private static void writeCustomSources() {
        for (Campaign campaign : Globals.getCampaignList()) {
            if (campaign.getSafe(StringKey.DESTINATION).length() <= 0) continue;
            CampaignOutput.output(Globals.getContext(), campaign);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCustomSpells() {
        BufferedWriter bufferedWriter = CustomData.getWriter(CustomData.customSpellFilePath(true));
        if (bufferedWriter == null) {
            return;
        }
        try {
            CustomData.writeCustomHeader(bufferedWriter);
            for (Object obj : Globals.getSpellMap().values()) {
                if (obj instanceof ArrayList) {
                    for (Spell spell : (ArrayList)obj) {
                        if (!spell.isType("Custom")) continue;
                        bufferedWriter.write(spell.getPCCText());
                        bufferedWriter.newLine();
                    }
                    continue;
                }
                if (!((Spell)obj).isType("Custom")) continue;
                bufferedWriter.write(((Spell)obj).getPCCText());
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            Logging.errorPrint("Error in writeCustomSpells", iOException);
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                Logging.errorPrint("Error in writeCustomSpells while closing", iOException);
            }
        }
    }

    private static void writeCustomTemplates() {
        CustomData.writeCustomPObjects(CustomData.customTemplateFilePath(true), Globals.getContext().ref.getConstructedCDOMObjects(PCTemplate.class).iterator());
    }
}

