/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityInfo;
import pcgen.core.Categorisable;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.WeaponProf;
import pcgen.core.analysis.BonusAddition;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.utils.CoreUtility;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilityUtilities {
    private AbilityUtilities() {
    }

    private static void addChoicesToAbility(PlayerCharacter playerCharacter, Ability ability, Iterable<String> iterable) {
        for (String string : iterable) {
            if (!AbilityUtilities.canAddAssociation(playerCharacter, ability, string)) continue;
            playerCharacter.addAssociation((CDOMObject)ability, string);
        }
    }

    public static Ability addCloneOfAbilityToListwithChoices(PlayerCharacter playerCharacter, Ability ability, List<String> list, List<Ability> list2) {
        Ability ability2 = null;
        if (ability != null && (ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue() || AbilityUtilities.getAbilityFromList(list2, ability) == null)) {
            ability2 = ability.clone();
            if (list != null) {
                AbilityUtilities.addChoicesToAbility(playerCharacter, ability2, list);
            }
            list2.add(ability2);
        }
        return ability2;
    }

    public static Ability addCloneOfGlobalAbilityToListWithChoices(PlayerCharacter playerCharacter, List<Ability> list, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        AbilityUtilities.getUndecoratedName(string2, arrayList);
        AbilityCategory abilityCategory = SettingsHandler.getGame().getAbilityCategory(string);
        Ability ability = AbilityUtilities.getAbilityFromList(list, abilityCategory.getAbilityCategory(), string2, Ability.Nature.ANY);
        if (ability == null && (ability = AbilityUtilities.cloneGlobalAbility(playerCharacter, abilityCategory.getAbilityCategory(), string2)) != null) {
            list.add(ability);
        }
        if (ability != null) {
            AbilityUtilities.addChoicesToAbility(playerCharacter, ability, arrayList);
        }
        return ability;
    }

    public static Ability addCloneOfGlobalAbilityToListWithChoices(PlayerCharacter playerCharacter, List<Ability> list, AbilityCategory abilityCategory, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        AbilityUtilities.getUndecoratedName(string, arrayList);
        Ability ability = AbilityUtilities.getAbilityFromList(list, abilityCategory.getAbilityCategory(), string, Ability.Nature.ANY);
        if (ability == null && (ability = AbilityUtilities.cloneGlobalAbility(playerCharacter, abilityCategory.getAbilityCategory(), string)) != null) {
            list.add(ability);
        }
        if (ability != null) {
            AbilityUtilities.addChoicesToAbility(playerCharacter, ability, arrayList);
        }
        return ability;
    }

    public static Ability addVirtualAbility(Ability ability, List<String> list, List<Ability> list2, PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        if (ability == null) {
            return null;
        }
        Ability ability2 = AbilityUtilities.addCloneOfAbilityToListwithChoices(playerCharacter, ability, list, list2);
        if (ability2 != null) {
            ability2.setAbilityNature(Ability.Nature.VIRTUAL);
            ability2.clearPrerequisiteList();
            if (pCLevelInfo != null) {
                pCLevelInfo.addObject(ability2);
            }
        }
        return ability2;
    }

    public static Ability addVirtualAbility(String string, String string2, List<Ability> list, PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = AbilityUtilities.getUndecoratedName(string2, arrayList);
        Ability ability = Globals.getAbilityKeyed(string, string3);
        return AbilityUtilities.addVirtualAbility(ability, arrayList, list, playerCharacter, pCLevelInfo);
    }

    public static boolean areSameAbility(Categorisable categorisable, Categorisable categorisable2) {
        if (categorisable == null || categorisable2 == null) {
            return false;
        }
        boolean bl = AbilityUtilities.getIsMultiples(categorisable);
        boolean bl2 = AbilityUtilities.getIsMultiples(categorisable2);
        boolean bl3 = false;
        if (bl && bl2) {
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string2 = AbilityUtilities.getUndecoratedName(categorisable.getKeyName(), arrayList);
            bl3 = string2.compareToIgnoreCase(string = AbilityUtilities.getUndecoratedName(categorisable2.getKeyName(), arrayList2)) == 0;
        } else {
            if (bl || bl2) {
                return false;
            }
            bl3 = categorisable.getKeyName().compareToIgnoreCase(categorisable2.getKeyName()) == 0;
        }
        return bl3 && categorisable.getCategory().compareToIgnoreCase(categorisable2.getCategory()) == 0;
    }

    public static boolean areSameAbility(Categorisable categorisable, String string) {
        if (categorisable == null || string == null) {
            return false;
        }
        AbilityInfo abilityInfo = new AbilityInfo(categorisable.getCategory(), string);
        return AbilityUtilities.areSameAbility(categorisable, abilityInfo);
    }

    private static Ability cloneGlobalAbility(PlayerCharacter playerCharacter, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = AbilityUtilities.getUndecoratedName(string2, arrayList);
        Ability ability = Globals.getAbilityKeyed(string, string2);
        if (ability == null && string3.length() != 0) {
            ability = Globals.getAbilityKeyed(string, string3);
        }
        if (ability == null) {
            Logging.errorPrint("Attempted to add unknown Ability (" + string + "): " + string2);
        } else {
            ability = ability.clone();
            if (arrayList.size() > 0) {
                AbilityUtilities.addChoicesToAbility(playerCharacter, ability, arrayList);
            }
        }
        return ability;
    }

    public static int finaliseAbility(Ability ability, String string, PlayerCharacter playerCharacter, boolean bl, boolean bl2, AbilityCategory abilityCategory) {
        boolean bl3;
        TransitionChoice<Ability> transitionChoice;
        double d = (double)playerCharacter.getSelectCorrectedAssociationCount(ability) * ability.getSafe(ObjectKey.SELECTION_COST).doubleValue();
        boolean bl4 = false;
        if (bl2 && (bl || ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue())) {
            if ("".equals(string) || string == null) {
                bl4 = ChooserUtilities.modChoices(ability, new ArrayList(), new ArrayList(), true, playerCharacter, bl, abilityCategory);
            } else if (bl) {
                if (AbilityUtilities.canAddAssociation(playerCharacter, ability, string)) {
                    playerCharacter.addAssociation((CDOMObject)ability, string);
                }
            } else {
                playerCharacter.removeAssociation((CDOMObject)ability, string);
            }
        }
        if ((transitionChoice = ability.get(ObjectKey.MODIFY_CHOICE)) != null) {
            transitionChoice.act(transitionChoice.driveChoice(playerCharacter), ability, playerCharacter);
        }
        if (bl) {
            for (TransitionChoice<Kit> transitionChoice2 : ability.getSafeListFor(ListKey.KIT_CHOICE)) {
                transitionChoice2.act(transitionChoice2.driveChoice(playerCharacter), ability, playerCharacter);
            }
        }
        boolean bl5 = false;
        boolean bl6 = bl3 = ability.getSafe(ObjectKey.MULTIPLE_ALLOWED) != false && bl2 ? playerCharacter.hasAssociations(ability) : bl;
        if (!bl3) {
            bl5 = playerCharacter.removeRealAbility(abilityCategory, ability);
            playerCharacter.removeNaturalWeapons(ability);
            playerCharacter.removeTemplatesFrom(ability);
            ability.removeAdds(playerCharacter);
        }
        if (bl2 && !bl4) {
            if (!bl && !ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue() && bl5) {
                if (abilityCategory == AbilityCategory.FEAT) {
                    d += ability.getSafe(ObjectKey.SELECTION_COST).doubleValue();
                }
            } else if (bl && !ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
                d -= ability.getSafe(ObjectKey.SELECTION_COST).doubleValue();
            } else if (abilityCategory == AbilityCategory.FEAT) {
                int n = playerCharacter.getSelectCorrectedAssociationCount(ability);
                for (Ability ability2 : playerCharacter.getRealAbilitiesList(AbilityCategory.FEAT)) {
                    if (!ability2.getKeyName().equalsIgnoreCase(ability.getKeyName())) continue;
                    n = playerCharacter.getSelectCorrectedAssociationCount(ability2);
                }
                d -= (double)n * ability.getSafe(ObjectKey.SELECTION_COST).doubleValue();
            }
            if (abilityCategory == AbilityCategory.FEAT) {
                playerCharacter.adjustAbilities(abilityCategory, BigDecimal.valueOf(d));
            }
        }
        playerCharacter.setAutomaticAbilitiesStable(null, false);
        playerCharacter.adjustMoveRates();
        if (bl && !playerCharacter.isImporting()) {
            ability.globalChecks(false, playerCharacter);
        }
        return bl3 ? 1 : 0;
    }

    public static Ability getAbilityFromList(List<Ability> list, Categorisable categorisable) {
        return AbilityUtilities.getAbilityFromList(list, categorisable, Ability.Nature.ANY);
    }

    public static Ability getAbilityFromList(List<Ability> list, Categorisable categorisable, Ability.Nature nature) {
        if (list != null) {
            for (Ability ability : list) {
                if (!AbilityUtilities.areSameAbility((Categorisable)ability, categorisable) || nature != Ability.Nature.ANY && ability.getAbilityNature() != nature) continue;
                return ability;
            }
        }
        return null;
    }

    public static Ability getAbilityFromList(List<Ability> list, String string, String string2, Ability.Nature nature) {
        AbilityInfo abilityInfo = new AbilityInfo(string, string2);
        return AbilityUtilities.getAbilityFromList(list, abilityInfo, nature);
    }

    private static boolean getIsMultiples(Categorisable categorisable) {
        if (categorisable instanceof Ability) {
            return ((Ability)categorisable).getSafe(ObjectKey.MULTIPLE_ALLOWED);
        }
        if (categorisable instanceof AbilityInfo) {
            Ability ability = ((AbilityInfo)categorisable).getAbility();
            if (ability == null) {
                return false;
            }
            return ability.getSafe(ObjectKey.MULTIPLE_ALLOWED);
        }
        return false;
    }

    public static int modAbility(PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo, Ability ability, String string, boolean bl, AbilityCategory abilityCategory) {
        if (ability == null) {
            Logging.errorPrint("Can't process null Ability");
            return bl ? 1 : 0;
        }
        if (playerCharacter.isNotImporting()) {
            playerCharacter.getSpellList();
        }
        List<Ability> list = playerCharacter.getRealAbilitiesList(abilityCategory);
        Ability ability2 = AbilityUtilities.getAbilityFromList(list, ability);
        if (bl && ability2 == null) {
            ability2 = ability.clone();
            playerCharacter.addAbility(abilityCategory, ability2, pCLevelInfo);
            playerCharacter.selectTemplates(ability2, playerCharacter.isImporting());
        }
        if (ability2 == null) {
            Logging.errorPrint("Can't process ability " + ability + " not present in character.");
            return bl ? 1 : 0;
        }
        return AbilityUtilities.finaliseAbility(ability2, string, playerCharacter, bl, true, abilityCategory);
    }

    public static int modFeat(PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo, String string, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = !bl2;
        if (!playerCharacter.isImporting()) {
            playerCharacter.getSpellList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = AbilityUtilities.getUndecoratedName(string, arrayList);
        String string3 = arrayList.size() > 0 ? (String)arrayList.iterator().next() : "";
        Ability ability = playerCharacter.getRealFeatKeyed(string);
        if (ability == null) {
            ability = playerCharacter.getRealFeatKeyed(string2);
            if (!bl3 && ability != null && string3.length() != 0) {
                bl3 = true;
            }
        }
        if (ability == null && bl) {
            ability = Globals.getAbilityKeyed("FEAT", string2);
            if (ability == null && (ability = Globals.getAbilityKeyed("FEAT", string)) != null) {
                string3 = "";
            }
            if (ability == null) {
                Logging.errorPrint("Feat not found: " + string);
                return 1;
            }
            ability = ability.clone();
            playerCharacter.addFeat(ability, pCLevelInfo);
            playerCharacter.selectTemplates(ability, playerCharacter.isImporting());
        }
        if (ability == null) {
            return bl ? 1 : 0;
        }
        return AbilityUtilities.finaliseAbility(ability, string3, playerCharacter, bl, bl3, AbilityCategory.FEAT);
    }

    static void modFeatsFromList(PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo, String string, boolean bl, boolean bl2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            Ability ability = playerCharacter.getFeatNamed(string2);
            StringTokenizer stringTokenizer2 = null;
            if (ability != null) continue;
            ability = Globals.getAbilityKeyed("FEAT", string2);
            if (ability == null) {
                stringTokenizer2 = new StringTokenizer(string2, "()", true);
                object = stringTokenizer2.nextToken();
                int n = ((String)object).length() + 1;
                int n2 = string2.lastIndexOf(41);
                stringTokenizer2 = n <= string2.length() ? (n2 >= n ? new StringTokenizer(string2.substring(n, n2), ",") : new StringTokenizer(string2.substring(n), ",")) : null;
                string2 = ((String)object).replace('(', ' ').replace(')', ' ').trim();
            } else {
                object = playerCharacter.getFeatKeyed(ability.getKeyName());
                if (object != null) {
                    ability = object;
                } else {
                    ability = ability.clone();
                    playerCharacter.addFeat(ability, pCLevelInfo);
                }
            }
            if (ability == null) {
                if (!bl) {
                    return;
                }
                ability = Globals.getAbilityKeyed("FEAT", string2);
                if (ability == null) {
                    Logging.errorPrint("Feat not found in PlayerCharacter.modFeatsFromList: " + string2);
                    return;
                }
                ability = ability.clone();
                playerCharacter.addFeat(ability, pCLevelInfo);
            }
            if (stringTokenizer2 != null && stringTokenizer2.hasMoreTokens()) {
                while (stringTokenizer2.hasMoreTokens()) {
                    string2 = stringTokenizer2.nextToken();
                    if ("DEITYWEAPON".equals(string2)) {
                        if (playerCharacter.getDeity() == null) continue;
                        object = playerCharacter.getDeity().getSafeListFor(ListKey.DEITYWEAPON);
                        Iterator<CDOMReference<WeaponProf>> iterator = object.iterator();
                        while (iterator.hasNext()) {
                            CDOMReference<WeaponProf> cDOMReference = iterator.next();
                            for (WeaponProf weaponProf : cDOMReference.getContainedObjects()) {
                                if (bl) {
                                    playerCharacter.addAssociation((CDOMObject)ability, weaponProf.getKeyName());
                                    continue;
                                }
                                playerCharacter.removeAssociation((CDOMObject)ability, weaponProf.getKeyName());
                            }
                        }
                        continue;
                    }
                    if (bl) {
                        playerCharacter.addAssociation((CDOMObject)ability, string2);
                        continue;
                    }
                    playerCharacter.removeAssociation((CDOMObject)ability, string2);
                }
                continue;
            }
            if (!bl2 && !ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
                if (bl) {
                    playerCharacter.adjustFeats(ability.getSafe(ObjectKey.SELECTION_COST).doubleValue());
                } else {
                    playerCharacter.adjustFeats(-ability.getSafe(ObjectKey.SELECTION_COST).doubleValue());
                }
            }
            AbilityUtilities.modFeat(playerCharacter, pCLevelInfo, string2, bl, bl2);
        }
        playerCharacter.setAutomaticAbilitiesStable(null, false);
    }

    public static Ability retrieveAbilityKeyed(String string, String string2) {
        AbilityCategory abilityCategory = AbilityUtilities.getAbilityCategory(string);
        Ability ability = Globals.getAbilityKeyed(abilityCategory, string2);
        if (ability != null) {
            return ability;
        }
        String string3 = AbilityUtilities.removeChoicesFromName(string2);
        ability = Globals.getAbilityKeyed(abilityCategory, string3);
        if (ability != null) {
            return ability;
        }
        return null;
    }

    public static AbilityCategory getAbilityCategory(String string) {
        return SettingsHandler.getGame().getAbilityCategory(string);
    }

    public static String removeChoicesFromName(String string) {
        int n = string.indexOf(40);
        return n >= 0 ? string.substring(0, n).trim() : string;
    }

    public static String getUndecoratedName(String string, Collection<String> collection) {
        String string2 = AbilityUtilities.removeChoicesFromName(string);
        collection.clear();
        int n = string.indexOf(40) + 1;
        int n2 = string.lastIndexOf(41);
        if (n >= 0 && n2 > n) {
            String string3 = string.substring(n, n2);
            collection.addAll(CoreUtility.split(string3, ','));
        }
        return string2;
    }

    public static List<Ability> getAggregateAbilitiesListForKey(String string, PlayerCharacter playerCharacter) {
        Collection<AbilityCategory> collection = SettingsHandler.getGame().getAllAbilityCatsForKey(string);
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        for (AbilityCategory abilityCategory : collection) {
            arrayList.addAll(playerCharacter.getAggregateAbilityList(abilityCategory));
        }
        return arrayList;
    }

    public static Ability addAbilityToListwithChoices(PlayerCharacter playerCharacter, Ability ability, List<String> list, List<Ability> list2) {
        Ability ability2 = AbilityUtilities.getAbilityFromList(list2, ability);
        if (ability2 == null) {
            ability2 = ability.clone();
            list2.add(ability2);
        }
        if (list != null) {
            AbilityUtilities.addChoicesToAbility(playerCharacter, ability2, list);
        }
        return ability2;
    }

    public static boolean canAddAssociation(PlayerCharacter playerCharacter, Ability ability, String string) {
        return ability.getSafe(ObjectKey.STACKS) != false || ability.getSafe(ObjectKey.MULTIPLE_ALLOWED) != false && !playerCharacter.containsAssociated((CDOMObject)ability, string);
    }

    public static void applyFeat(PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo, String string) {
        Object object;
        String string2 = string;
        ArrayList<String> arrayList = new ArrayList<String>();
        Ability ability = Globals.getAbilityKeyed("FEAT", string2);
        boolean bl = false;
        if (ability != null && ability.getSafe(StringKey.CHOICE_STRING).startsWith("SPELLLEVEL")) {
            bl = true;
            object = new StringTokenizer(ability.getSafe(StringKey.CHOICE_STRING), "[]", false);
            ((StringTokenizer)object).nextToken();
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
        }
        if (ability != null) {
            playerCharacter.adjustFeats(ability.getSafe(ObjectKey.SELECTION_COST).doubleValue());
        } else {
            playerCharacter.adjustFeats(1.0);
            Logging.debugPrint("There is no feat '" + string2 + "'. Adjusting feat count by 1");
        }
        AbilityUtilities.modFeat(playerCharacter, pCLevelInfo, string2, true, false);
        if (bl && ability != null) {
            if (string.indexOf(40) > 0) {
                object = new StringTokenizer(string, "()", false);
                ability = playerCharacter.getFeatNamed(((StringTokenizer)object).nextToken());
                string = ((StringTokenizer)object).nextToken();
            }
            if (ability != null) {
                for (String string3 : arrayList) {
                    BonusAddition.applyBonus(string3, string, playerCharacter, ability, false);
                }
            }
        }
    }

    public static void applyAbility(PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo, AbilityCategory abilityCategory, Ability ability, String string, boolean bl) {
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            List<Ability> list = playerCharacter.getDirectVirtualAbilities(abilityCategory);
            Ability ability2 = AbilityUtilities.addVirtualAbility(ability, arrayList, list, playerCharacter, pCLevelInfo);
            playerCharacter.setDirty(true);
            if (ability2 != null) {
                if (ability2.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
                    double d = playerCharacter.getRawFeats(false);
                    playerCharacter.setFeats(1.0);
                    ChooserUtilities.modChoices(ability2, new ArrayList(), new ArrayList(), true, playerCharacter, true, abilityCategory);
                    playerCharacter.setFeats(d);
                }
                ability2.setNeedsSaving(true);
            } else {
                Logging.errorPrint("Error:" + ability.getKeyName() + " not added, aPC.getFeatNamedInList() == NULL");
            }
        } else {
            playerCharacter.adjustAbilities(abilityCategory, ability.getSafe(ObjectKey.SELECTION_COST));
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl2 = false;
            if (ability.getSafe(StringKey.CHOICE_STRING).startsWith("SPELLLEVEL")) {
                bl2 = true;
                StringTokenizer stringTokenizer = new StringTokenizer(ability.getSafe(StringKey.CHOICE_STRING), "[]", false);
                stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
            AbilityUtilities.modAbility(playerCharacter, pCLevelInfo, ability, string, true, abilityCategory);
            if (bl2) {
                for (String string2 : arrayList) {
                    BonusAddition.applyBonus(string2, string, playerCharacter, ability, false);
                }
            }
        }
    }
}

