/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.CategorizedCDOMObject;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.list.AbilityList;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.core.AbilityCategory;
import pcgen.core.Categorisable;
import pcgen.core.Description;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Ability
extends PObject
implements Categorisable,
CategorizedCDOMObject<Ability> {
    public static final CDOMReference<AbilityList> FEATLIST;
    private boolean needsSaving = false;

    @Override
    public String getCategory() {
        return this.get(ObjectKey.ABILITY_CAT).getKeyName();
    }

    public void setAbilityNature(Nature nature) {
        if (nature == Nature.ANY) {
            return;
        }
        this.put(ObjectKey.ABILITY_NATURE, nature);
    }

    public Nature getAbilityNature() {
        return this.getSafe(ObjectKey.ABILITY_NATURE);
    }

    public void setNeedsSaving(boolean bl) {
        this.needsSaving = bl;
    }

    public boolean needsSaving() {
        return this.needsSaving;
    }

    @Override
    public Ability clone() {
        try {
            return (Ability)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
            return null;
        }
    }

    @Override
    public String getPCCText() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.getDisplayName());
        stringBuffer.append("\tCATEGORY:").append(this.getCategory());
        stringBuffer.append("\t");
        stringBuffer.append((CharSequence)StringUtil.joinToStringBuffer(Globals.getContext().unparse(this), "\t"));
        stringBuffer.append("\t");
        stringBuffer.append(super.getPCCText(false));
        return stringBuffer.toString();
    }

    @Override
    int numberInList(PlayerCharacter playerCharacter, String string) {
        String string2;
        String string3 = string;
        if (string3.lastIndexOf(61) > -1) {
            string3 = string3.substring(string3.lastIndexOf(61) + 1);
        }
        if (string3.lastIndexOf(43) > -1 && "0123456789".lastIndexOf((string2 = string3.substring(string3.lastIndexOf(43) + 1)).substring(0, 1)) > 0) {
            string3 = string3.substring(0, string3.lastIndexOf(43));
        }
        if (string3.lastIndexOf(45) > -1 && "0123456789".lastIndexOf((string2 = string3.substring(string3.lastIndexOf(45) + 1)).substring(0, 1)) > 0) {
            string3 = string3.substring(0, string3.lastIndexOf(45));
        }
        int n = 0;
        for (String string4 : playerCharacter.getAssociationList(this)) {
            if (!string4.equalsIgnoreCase(string3)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int compareTo(Object object) {
        if (object != null) {
            try {
                int n;
                Ability ability = (Ability)object;
                Category<Ability> category = this.getCDOMCategory();
                Category<Ability> category2 = ability.getCDOMCategory();
                if (category == null && category2 != null) {
                    return -1;
                }
                if (category != null && category2 == null) {
                    return 1;
                }
                if (category != null && (n = category.getKeyName().compareTo(category2.getKeyName())) != 0) {
                    return n;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return this.getKeyName().compareToIgnoreCase(((PObject)object).getKeyName());
        }
        return 1;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Ability && this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.getKeyName().hashCode();
    }

    @Override
    public Category<Ability> getCDOMCategory() {
        return this.get(ObjectKey.ABILITY_CAT);
    }

    @Override
    public void setCDOMCategory(Category<Ability> category) {
        this.put(ObjectKey.ABILITY_CAT, category);
    }

    @Override
    public ListKey<Description> getDescriptionKey() {
        if (SettingsHandler.useFeatBenefits() && this.containsListFor(ListKey.BENEFIT)) {
            return ListKey.BENEFIT;
        }
        return ListKey.DESCRIPTION;
    }

    @Override
    public PObject getActiveEquivalent(PlayerCharacter playerCharacter) {
        AbilityCategory abilityCategory = SettingsHandler.getGame().silentlyGetAbilityCategory(this.getCategory());
        Ability ability = playerCharacter.getAbilityKeyed(abilityCategory, this.getAbilityNature(), this.getKeyName());
        return ability == null ? this : ability;
    }

    static {
        AbilityList abilityList = new AbilityList();
        abilityList.setName("*Feats");
        FEATLIST = CDOMDirectSingleRef.getRef(abilityList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Nature {
        NORMAL,
        AUTOMATIC,
        VIRTUAL,
        ANY;

    }
}

