/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.event.EventListenerList;
import pcgen.base.lang.CaseInsensitiveString;
import pcgen.base.lang.UnreachableError;
import pcgen.base.util.FixedStringList;
import pcgen.base.util.HashMapToInstanceList;
import pcgen.base.util.KeyMap;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.UnconstructedEvent;
import pcgen.cdom.reference.UnconstructedListener;
import pcgen.cdom.reference.UnconstructedValidator;
import pcgen.core.AbilityUtilities;
import pcgen.core.PCClass;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReferenceManufacturer<T extends CDOMObject, SRT extends CDOMSingleRef<T>, TRT extends CDOMGroupRef<T>, ART extends CDOMGroupRef<T>>
implements ReferenceManufacturer<T, SRT> {
    private final Class<T> refClass;
    private ART allRef;
    private final Map<FixedStringList, WeakReference<TRT>> typeReferences = new TreeMap<FixedStringList, WeakReference<TRT>>(FixedStringList.CASE_INSENSITIVE_ORDER);
    private final Map<String, WeakReference<SRT>> referenced = new TreeMap<String, WeakReference<SRT>>(String.CASE_INSENSITIVE_ORDER);
    private final KeyMap<T> active = new KeyMap();
    private final HashMapToInstanceList<CaseInsensitiveString, T> duplicates = new HashMapToInstanceList();
    private final List<String> deferred = new ArrayList<String>();
    private final List<WeakReference<T>> manufactured = new ArrayList<WeakReference<T>>();
    private final Set<String> unconstructed = new HashSet<String>();
    private final transient EventListenerList listenerList = new EventListenerList();

    public AbstractReferenceManufacturer(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Reference Class for " + this.getClass().getName() + " cannot be null");
        }
        try {
            clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Class for " + this.getClass().getName() + " must possess a zero-argument constructor", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Class for " + this.getClass().getName() + " must possess a public zero-argument constructor", illegalAccessException);
        }
        this.refClass = clazz;
    }

    @Override
    public CDOMGroupRef<T> getTypeReference(String ... stringArray) {
        CDOMGroupRef TRT;
        for (String string : stringArray) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("Attempt to acquire empty Type (the type String contains a null or empty element)");
            }
            if (string.indexOf(46) != -1) {
                throw new IllegalArgumentException("Cannot build Reference with type conaining a period: " + string);
            }
            if (string.indexOf(61) != -1) {
                throw new IllegalArgumentException("Cannot build Reference with type conaining an equals: " + string);
            }
            if (string.indexOf(44) != -1) {
                throw new IllegalArgumentException("Cannot build Reference with type conaining a comma: " + string);
            }
            if (string.indexOf(124) == -1) continue;
            throw new IllegalArgumentException("Cannot build Reference with type conaining a pipe: " + string);
        }
        Arrays.sort(stringArray);
        FixedStringList fixedStringList = new FixedStringList(stringArray);
        WeakReference<TRT> weakReference = this.typeReferences.get(fixedStringList);
        if (weakReference != null && (TRT = (CDOMGroupRef)weakReference.get()) != null) {
            return TRT;
        }
        TRT TRT2 = this.getLocalTypeReference(stringArray);
        this.typeReferences.put(fixedStringList, new WeakReference<TRT>(TRT2));
        return TRT2;
    }

    @Override
    public CDOMGroupRef<T> getAllReference() {
        if (this.allRef == null) {
            this.allRef = this.getLocalAllReference();
        }
        return this.allRef;
    }

    @Override
    public Class<T> getReferenceClass() {
        return this.refClass;
    }

    @Override
    public void resolveReferences() {
        this.resolvePrimitiveReferences();
        this.resolveAllReference();
        for (WeakReference<TRT> weakReference : this.typeReferences.values()) {
            CDOMGroupRef cDOMGroupRef = (CDOMGroupRef)weakReference.get();
            if (cDOMGroupRef == null || cDOMGroupRef.getObjectCount() != 0) continue;
            Logging.errorPrint("Error: No " + this.getReferenceDescription() + " objects of " + cDOMGroupRef.getLSTformat() + " were loaded but were referred to in the data");
            this.fireUnconstuctedEvent(cDOMGroupRef);
        }
    }

    private void resolvePrimitiveReferences() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, WeakReference<SRT>> entry : this.referenced.entrySet()) {
            CDOMSingleRef cDOMSingleRef = (CDOMSingleRef)entry.getValue().get();
            if (cDOMSingleRef == null) continue;
            CDOMObject cDOMObject = (CDOMObject)this.active.get(entry.getKey());
            if (cDOMObject == null) {
                String string = AbilityUtilities.getUndecoratedName(entry.getKey(), arrayList);
                cDOMObject = (CDOMObject)this.active.get(string);
                if (cDOMObject == null && (this.unconstructed.contains(entry.getKey()) || this.unconstructed.contains(string))) {
                    cDOMObject = this.buildObject(entry.getKey());
                }
                if (cDOMObject == null) {
                    Logging.errorPrint("Unable to Resolve: " + this.refClass + " " + entry.getKey());
                    continue;
                }
                cDOMSingleRef.addResolution(cDOMObject);
                continue;
            }
            cDOMSingleRef.addResolution(cDOMObject);
        }
    }

    private void resolveAllReference() {
        for (CDOMObject cDOMObject : this.getAllObjects()) {
            if (this.allRef != null) {
                ((CDOMReference)this.allRef).addResolution((CDOMObject)cDOMObject);
            }
            for (Map.Entry<FixedStringList, WeakReference<TRT>> entry : this.typeReferences.entrySet()) {
                boolean bl = true;
                Object object = entry.getKey().iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    if (cDOMObject.isType(string)) continue;
                    bl = false;
                    break;
                }
                if (!bl || (object = (CDOMGroupRef)entry.getValue().get()) == null) continue;
                ((CDOMReference)object).addResolution(cDOMObject);
            }
        }
        if (this.allRef != null && ((CDOMReference)this.allRef).getObjectCount() == 0) {
            Logging.errorPrint("Error: No " + this.getReferenceDescription() + " objects were loaded but were referred to in the data");
            this.fireUnconstuctedEvent((CDOMReference<?>)this.allRef);
        }
    }

    @Override
    public void addObject(T t, String string) {
        if (!this.refClass.isInstance(t)) {
            throw new IllegalArgumentException("Attempted to register a " + t.getClass().getName() + " in " + this.refClass.getName() + " ReferenceSupport");
        }
        CDOMObject cDOMObject = (CDOMObject)this.active.get(string);
        if (cDOMObject == null) {
            this.active.put(string, t);
        } else {
            this.duplicates.addToListFor(new CaseInsensitiveString(string), t);
        }
    }

    @Override
    public T getActiveObject(String string) {
        return (T)((CDOMObject)this.active.get(string));
    }

    @Override
    public T getObject(String string) {
        CDOMObject cDOMObject = (CDOMObject)this.active.get(string);
        if (cDOMObject != null) {
            if (this.duplicates.containsListFor(new CaseInsensitiveString(string))) {
                Logging.errorPrint("Reference to Constructed " + this.refClass.getSimpleName() + " " + string + " is ambiguous");
            }
            return (T)cDOMObject;
        }
        return null;
    }

    @Override
    public T constructObject(String string) {
        T t = this.buildObject(string);
        this.addObject(t, string);
        return t;
    }

    protected T buildObject(String string) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Cannot build empty name");
        }
        try {
            CDOMObject cDOMObject = (CDOMObject)this.refClass.newInstance();
            cDOMObject.setName(string);
            return (T)cDOMObject;
        }
        catch (InstantiationException instantiationException) {
            throw new UnreachableError("Class was tested at AbstractReferenceManufacturer construction to ensure it had a public, zero-argument constructor");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnreachableError("Class was tested at AbstractReferenceManufacturer construction to ensure it had a public, zero-argument constructor");
        }
    }

    @Override
    public void renameObject(String string, T t) {
        String string2 = ((CDOMObject)t).getKeyName();
        if (string2.equalsIgnoreCase(string)) {
            Logging.debugPrint("Worthless Key change encountered: " + ((CDOMObject)t).getDisplayName() + " " + string2);
        }
        this.forgetObject(t);
        this.addObject(t, string);
    }

    @Override
    public boolean forgetObject(T t) throws InternalError {
        if (!this.refClass.isInstance(t)) {
            throw new IllegalArgumentException("Object to be forgotten does not match Class of this AbstractReferenceManufacturer");
        }
        String string = this.active.getKeyFor(t);
        if (string == null) {
            CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(((CDOMObject)t).getKeyName());
            this.duplicates.removeFromListFor(caseInsensitiveString, t);
        } else {
            CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string);
            List list = this.duplicates.getListFor(caseInsensitiveString);
            if (list == null) {
                this.active.remove(string);
            } else {
                CDOMObject cDOMObject = (CDOMObject)this.duplicates.getElementInList(caseInsensitiveString, 0);
                this.duplicates.removeFromListFor(caseInsensitiveString, cDOMObject);
                this.active.put(string, cDOMObject);
            }
        }
        return true;
    }

    @Override
    public boolean containsObject(String string) {
        return this.active.containsKey(string);
    }

    @Override
    public SRT getReference(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot request a reference to null identifier");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Cannot request a reference to an empty identifier");
        }
        try {
            Integer.parseInt(string);
            throw new IllegalArgumentException(string);
        }
        catch (NumberFormatException numberFormatException) {
            CDOMSingleRef<Object> cDOMSingleRef;
            WeakReference<SRT> weakReference;
            if (string.startsWith("TYPE")) {
                throw new IllegalArgumentException(string);
            }
            if (string.equalsIgnoreCase("ANY")) {
                throw new IllegalArgumentException(string);
            }
            if (string.equalsIgnoreCase("ALL")) {
                throw new IllegalArgumentException(string);
            }
            if (string.startsWith("PRE")) {
                throw new IllegalArgumentException(string);
            }
            if (string.startsWith("CHOOSE")) {
                throw new IllegalArgumentException(string);
            }
            if (string.startsWith("TIMES=")) {
                throw new IllegalArgumentException(string);
            }
            if (string.startsWith("TIMEUNIT=")) {
                throw new IllegalArgumentException(string);
            }
            if (string.startsWith("CASTERLEVEL=")) {
                throw new IllegalArgumentException(string);
            }
            if (this.refClass.equals(PCClass.class)) {
                if (string.startsWith("CLASS")) {
                    throw new IllegalArgumentException(string);
                }
                if (string.startsWith("SUB")) {
                    throw new IllegalArgumentException(string);
                }
                try {
                    Integer.parseInt(string);
                    throw new IllegalArgumentException(string);
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            if ((weakReference = this.referenced.get(string)) != null && (cDOMSingleRef = (CDOMSingleRef)weakReference.get()) != null) {
                return (SRT)cDOMSingleRef;
            }
            cDOMSingleRef = this.getLocalReference(string);
            this.referenced.put(string, new WeakReference<CDOMSingleRef>(cDOMSingleRef));
            return (SRT)cDOMSingleRef;
        }
    }

    protected abstract SRT getLocalReference(String var1);

    protected abstract TRT getLocalTypeReference(String[] var1);

    protected abstract ART getLocalAllReference();

    @Override
    public boolean validate(UnconstructedValidator unconstructedValidator) {
        boolean bl = true;
        if (unconstructedValidator == null || !unconstructedValidator.allowDuplicates(this.getReferenceClass())) {
            bl = this.validateDuplicates();
        }
        bl &= this.validateActive();
        return bl &= this.validateUnconstructed(unconstructedValidator);
    }

    private boolean validateUnconstructed(UnconstructedValidator unconstructedValidator) {
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Map.Entry<String, WeakReference<SRT>>> iterator = this.referenced.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Map.Entry<String, WeakReference<SRT>> entry = iterator.next();
            CDOMSingleRef cDOMSingleRef = (CDOMSingleRef)entry.getValue().get();
            if (cDOMSingleRef == null) {
                iterator.remove();
                continue;
            }
            String string2 = entry.getKey();
            if (this.active.containsKey(string2) || this.deferred.contains(string2) || this.active.containsKey(string = AbilityUtilities.getUndecoratedName(string2, arrayList)) || this.deferred.contains(string)) continue;
            if (string2.charAt(0) != '*' && !this.validate(unconstructedValidator, string2)) {
                Logging.errorPrint("Unconstructed Reference: " + this.getReferenceDescription() + " " + string2);
                this.fireUnconstuctedEvent(cDOMSingleRef);
                bl = false;
            }
            this.unconstructed.add(string2);
        }
        return bl;
    }

    private boolean validateActive() {
        boolean bl = true;
        for (String string : this.active.keySet()) {
            CDOMObject cDOMObject = (CDOMObject)this.active.get(string);
            String string2 = cDOMObject.getKeyName();
            if (string2 == null) {
                Logging.errorPrint(cDOMObject.getClass() + " " + cDOMObject.get(StringKey.NAME) + " has a null KeyName");
                continue;
            }
            if (string2.equalsIgnoreCase(string.toString())) continue;
            Logging.errorPrint("Magical Key Change: " + string + " to " + string2);
            bl = false;
        }
        return bl;
    }

    private boolean validateDuplicates() throws InternalError {
        boolean bl = true;
        for (CaseInsensitiveString caseInsensitiveString : this.duplicates.getKeySet()) {
            List list = this.duplicates.getListFor(caseInsensitiveString);
            CDOMObject cDOMObject = (CDOMObject)this.active.get(caseInsensitiveString.toString());
            block1: for (int i = 0; i < list.size(); ++i) {
                CDOMObject cDOMObject2 = (CDOMObject)list.get(i);
                if (!cDOMObject2.isCDOMEqual(cDOMObject)) continue;
                Iterator<WeakReference<T>> iterator = this.manufactured.iterator();
                while (iterator.hasNext()) {
                    WeakReference<T> weakReference = iterator.next();
                    CDOMObject cDOMObject3 = (CDOMObject)weakReference.get();
                    if (cDOMObject3 == null) {
                        iterator.remove();
                        continue;
                    }
                    if (cDOMObject3 != cDOMObject) continue;
                    this.forgetObject((T)cDOMObject);
                    continue block1;
                }
            }
            if (!this.duplicates.containsListFor(caseInsensitiveString)) continue;
            Logging.errorPrint("More than one " + this.refClass.getSimpleName() + " with key/name " + caseInsensitiveString + " was built");
            bl = false;
        }
        return bl;
    }

    protected abstract boolean validate(UnconstructedValidator var1, String var2);

    protected abstract String getReferenceDescription();

    @Override
    public void constructIfNecessary(String string) {
        this.deferred.add(string);
    }

    @Override
    public Collection<T> getAllObjects() {
        return this.active.values();
    }

    @Override
    public void buildDeferredObjects() {
        for (String string : this.deferred) {
            if (this.active.containsKey(string)) continue;
            this.constructObject(string.toString());
        }
    }

    protected ART getAllRef() {
        return this.allRef;
    }

    protected Collection<TRT> getTypeReferences() {
        ArrayList<CDOMGroupRef> arrayList = new ArrayList<CDOMGroupRef>(this.typeReferences.size());
        Iterator<WeakReference<TRT>> iterator = this.typeReferences.values().iterator();
        while (iterator.hasNext()) {
            WeakReference<TRT> weakReference = iterator.next();
            CDOMGroupRef cDOMGroupRef = (CDOMGroupRef)weakReference.get();
            if (cDOMGroupRef == null) {
                iterator.remove();
                continue;
            }
            arrayList.add(cDOMGroupRef);
        }
        return arrayList;
    }

    protected Collection<SRT> getReferenced() {
        ArrayList<CDOMSingleRef> arrayList = new ArrayList<CDOMSingleRef>();
        for (WeakReference<SRT> weakReference : this.referenced.values()) {
            CDOMSingleRef cDOMSingleRef = (CDOMSingleRef)weakReference.get();
            if (cDOMSingleRef == null) continue;
            arrayList.add(cDOMSingleRef);
        }
        return arrayList;
    }

    protected void injectConstructed(ReferenceManufacturer<T, ?> referenceManufacturer) {
        for (String object : this.active.keySet()) {
            referenceManufacturer.addObject((PrereqObject)this.active.get(object), object);
        }
        for (CaseInsensitiveString caseInsensitiveString : this.duplicates.getKeySet()) {
            for (CDOMObject cDOMObject : this.duplicates.getListFor(caseInsensitiveString)) {
                referenceManufacturer.addObject(cDOMObject, caseInsensitiveString.toString());
            }
        }
        for (String string : this.deferred) {
            referenceManufacturer.constructIfNecessary(string);
        }
    }

    @Override
    public T constructNowIfNecessary(String string) {
        PrereqObject prereqObject = (CDOMObject)this.active.get(string);
        if (prereqObject == null) {
            prereqObject = this.constructObject(string);
            this.manufactured.add(new WeakReference<CDOMObject>((CDOMObject)prereqObject));
        }
        return (T)prereqObject;
    }

    @Override
    public void addUnconstructedListener(UnconstructedListener unconstructedListener) {
        this.listenerList.add(UnconstructedListener.class, unconstructedListener);
    }

    @Override
    public synchronized UnconstructedListener[] getUnconstructedListeners() {
        return (UnconstructedListener[])this.listenerList.getListeners(UnconstructedListener.class);
    }

    @Override
    public void removeUnconstructedListener(UnconstructedListener unconstructedListener) {
        this.listenerList.remove(UnconstructedListener.class, unconstructedListener);
    }

    private void fireUnconstuctedEvent(CDOMReference<?> cDOMReference) {
        Object[] objectArray = this.listenerList.getListenerList();
        UnconstructedEvent unconstructedEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != UnconstructedListener.class) continue;
            if (unconstructedEvent == null) {
                unconstructedEvent = new UnconstructedEvent(this, cDOMReference);
            }
            ((UnconstructedListener)objectArray[i + 1]).unconstructedReferenceFound(unconstructedEvent);
        }
    }
}

