/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.inst;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import pcgen.base.util.DoubleKeyMap;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.Vision;
import pcgen.core.analysis.SkillCostCalc;
import pcgen.core.prereq.PrereqHandler;
import pcgen.util.enumeration.VisionType;

public class ObjectCache
extends CDOMObject {
    private final DoubleKeyMap<String, PCClass, SkillCost> skillCostMap = new DoubleKeyMap();

    public boolean isType(String string) {
        return false;
    }

    public void initializeVisionCache(PlayerCharacter playerCharacter) {
        this.listChar.initializeListFor(ListKey.VISION_CACHE);
        HashMap<VisionType, Integer> hashMap = new HashMap<VisionType, Integer>();
        for (CDOMObject object : playerCharacter.getCDOMObjectList()) {
            Collection collection = object.getListMods(Vision.VISIONLIST);
            if (collection == null) continue;
            for (CDOMReference cDOMReference : collection) {
                Collection<AssociatedPrereqObject> collection2 = object.getListAssociations(Vision.VISIONLIST, cDOMReference);
                for (AssociatedPrereqObject associatedPrereqObject : collection2) {
                    if (!PrereqHandler.passesAll(associatedPrereqObject.getPrerequisiteList(), playerCharacter, null)) continue;
                    for (Vision vision : cDOMReference.getContainedObjects()) {
                        VisionType visionType = vision.getType();
                        int n = playerCharacter.getVariableValue(vision.getDistance(), "").intValue();
                        Integer n2 = (Integer)hashMap.get(visionType);
                        if (n2 != null && n2 >= n) continue;
                        hashMap.put(visionType, n);
                    }
                }
            }
        }
        for (VisionType visionType : VisionType.getAllVisionTypes()) {
            int n = (int)playerCharacter.getTotalBonusTo("VISION", visionType.toString());
            if (n <= 0) continue;
            Integer n3 = (Integer)hashMap.get(visionType);
            hashMap.put(visionType, n + (n3 == null ? 0 : n3));
        }
        TreeSet treeSet = new TreeSet();
        for (Map.Entry entry : hashMap.entrySet()) {
            treeSet.add(new Vision((VisionType)entry.getKey(), ((Integer)entry.getValue()).toString()));
        }
        this.addAllToListFor(ListKey.VISION_CACHE, treeSet);
    }

    public SkillCost getSkillCost(PlayerCharacter playerCharacter, Skill skill, PCClass pCClass) {
        String string = skill.getKeyName();
        SkillCost skillCost = this.skillCostMap.get(string, pCClass);
        if (skillCost == null) {
            skillCost = SkillCostCalc.skillCostForPCClass(skill, pCClass, playerCharacter);
            this.skillCostMap.put(string, pCClass, skillCost);
        }
        return skillCost;
    }
}

