/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.AspectName;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.util.Logging;

public class Aspect {
    private final AspectName key;
    private final List<String> theComponents = new ArrayList<String>();
    private List<String> theVariables = null;
    private static final String VAR_NAME = "%NAME";
    private static final String VAR_CHOICE = "%CHOICE";
    private static final String VAR_LIST = "%LIST";
    private static final String VAR_FEATS = "%FEAT=";
    private static final String VAR_MARKER = "$$VAR:";

    public Aspect(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Name for Aspect cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Value for Aspect cannot be null");
        }
        this.key = AspectName.getConstant(string);
        this.parseAspectString(string2);
    }

    public Aspect(AspectName aspectName, String string) {
        if (aspectName == null) {
            throw new IllegalArgumentException("Key for Aspect cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Value for Aspect cannot be null");
        }
        this.key = aspectName;
        this.parseAspectString(string);
    }

    private void parseAspectString(String string) {
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(37, n)) != -1) {
            String string2 = string.substring(n, n2);
            if (string2.length() > 0) {
                this.theComponents.add(string2);
            }
            if (n2 == string.length() - 1) {
                this.theComponents.add("%");
                return;
            }
            if (string.charAt(n2 + 1) == '{') {
                n = string.indexOf(125, n2 + 1) + 1;
                String string3 = string.substring(n2 + 1, n);
                try {
                    Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.errorPrintLocalised("Errors.Description.InvalidVariableReplacement", string3);
                }
                this.theComponents.add(VAR_MARKER + string3);
                continue;
            }
            if (string.charAt(n2 + 1) == '%') {
                n = n2 + 2;
                this.theComponents.add("%");
                continue;
            }
            for (n = n2 + 1; n < string.length(); ++n) {
                char c = string.charAt(n);
                try {
                    Integer.parseInt(String.valueOf(c));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
            }
            if (n > n2 + 1) {
                this.theComponents.add(VAR_MARKER + string.substring(n2 + 1, n));
                continue;
            }
            this.theComponents.add(string.substring(n2, n2 + 1));
        }
        this.theComponents.add(string.substring(n));
    }

    public void addVariable(String string) {
        if (this.theVariables == null) {
            this.theVariables = new ArrayList<String>();
        }
        this.theVariables.add(string);
    }

    public String getName() {
        return this.key.toString();
    }

    public AspectName getKey() {
        return this.key;
    }

    public String getAspectText(PlayerCharacter playerCharacter, Ability object) {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        if (object != null && (object2 = playerCharacter.getAbilityMatching((Ability)object)) != null) {
            object = object2;
        }
        for (String string : this.theComponents) {
            if (string.startsWith(VAR_MARKER)) {
                Object object3;
                Object object4;
                int n = Integer.parseInt(string.substring(VAR_MARKER.length()));
                if (this.theVariables == null || n > this.theVariables.size()) {
                    stringBuffer.append("");
                    continue;
                }
                String string2 = this.theVariables.get(n - 1);
                if (string2.equals(VAR_NAME)) {
                    if (object == null) continue;
                    stringBuffer.append(((PObject)object).getOutputName());
                    continue;
                }
                if (string2.equals(VAR_CHOICE)) {
                    if (object == null || !playerCharacter.hasAssociations((CDOMObject)object)) continue;
                    stringBuffer.append(playerCharacter.getFirstAssociation((CDOMObject)object));
                    continue;
                }
                if (string2.equals(VAR_LIST)) {
                    if (object == null) continue;
                    object4 = playerCharacter.getExpandedAssociations((CDOMObject)object);
                    object3 = object4.size() == 2 ? " and " : ", ";
                    stringBuffer.append((CharSequence)StringUtil.joinToStringBuffer(playerCharacter.getExpandedAssociations((CDOMObject)object), (String)object3));
                    continue;
                }
                if (string2.startsWith(VAR_FEATS)) {
                    object4 = string2.substring(VAR_FEATS.length());
                    if (((String)object4).startsWith("TYPE=") || ((String)object4).startsWith("TYPE.")) {
                        object3 = playerCharacter.getAggregateAbilityList(AbilityCategory.FEAT);
                        boolean bl = true;
                        Iterator iterator = object3.iterator();
                        while (iterator.hasNext()) {
                            Ability ability = (Ability)iterator.next();
                            if (!ability.isType(((String)object4).substring(5))) continue;
                            if (!bl) {
                                stringBuffer.append(",").append(' ');
                            }
                            stringBuffer.append(playerCharacter.getDescription(ability));
                            bl = false;
                        }
                        continue;
                    }
                    object3 = playerCharacter.getAbilityKeyed(AbilityCategory.FEAT, (String)object4);
                    stringBuffer.append(playerCharacter.getDescription((PObject)object3));
                    continue;
                }
                if (string2.startsWith("\"")) {
                    stringBuffer.append(string2.substring(1, string2.length() - 1));
                    continue;
                }
                stringBuffer.append(playerCharacter.getVariableValue(string2, "Aspect").intValue());
                continue;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getPCCText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.theComponents) {
            if (string.startsWith(VAR_MARKER)) {
                int n = Integer.parseInt(string.substring(VAR_MARKER.length()));
                stringBuffer.append('%').append(n);
                continue;
            }
            stringBuffer.append(string);
        }
        if (this.theVariables != null) {
            for (String string : this.theVariables) {
                stringBuffer.append("|");
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getPCCText();
    }

    public int hashCode() {
        return this.theComponents.size() + 7 * (this.theVariables == null ? 0 : this.theVariables.size());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Aspect)) {
            return false;
        }
        Aspect aspect = (Aspect)object;
        if (this.theVariables == null && aspect.theVariables != null) {
            return false;
        }
        return ((Object)this.theComponents).equals(aspect.theComponents) && (this.theVariables == null || ((Object)this.theVariables).equals(aspect.theVariables));
    }
}

