/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.helper;

import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.helper.ProfProvider;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Equipment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProfProvider<T extends CDOMObject>
extends ConcretePrereqObject
implements ProfProvider<T> {
    private final Set<CDOMReference<T>> direct = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
    private final Set<CDOMReference<Equipment>> byEquipType;

    public AbstractProfProvider(List<CDOMReference<T>> list, List<CDOMReference<Equipment>> list2) {
        this.direct.addAll(list);
        this.byEquipType = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
        this.byEquipType.addAll(list2);
    }

    @Override
    public abstract boolean providesProficiencyFor(Equipment var1);

    @Override
    public boolean providesProficiency(T t) {
        for (CDOMReference<T> cDOMReference : this.direct) {
            if (!cDOMReference.contains(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean providesEquipmentType(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String string2 : string.split("\\.")) {
            treeSet.add(string2);
        }
        block1: for (CDOMReference cDOMReference : this.byEquipType) {
            StringTokenizer stringTokenizer = new StringTokenizer(cDOMReference.getLSTformat().substring(5), ".");
            while (stringTokenizer.hasMoreTokens()) {
                if (treeSet.contains(stringTokenizer.nextToken())) continue;
                continue block1;
            }
            return true;
        }
        return false;
    }

    protected abstract String getSubType();

    @Override
    public String getLstFormat() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.byEquipType.isEmpty();
        if (!this.direct.isEmpty()) {
            stringBuilder.append(ReferenceUtilities.joinLstFormat(this.direct, "|"));
            if (!bl) {
                stringBuilder.append("|");
            }
        }
        if (!bl) {
            boolean bl2 = false;
            String string = this.getSubType();
            String string2 = ".";
            for (CDOMReference<Equipment> cDOMReference : this.byEquipType) {
                if (bl2) {
                    stringBuilder.append("|");
                }
                bl2 = true;
                String string3 = cDOMReference.getLSTformat();
                if (!string3.startsWith("TYPE=")) continue;
                stringBuilder.append(string).append("TYPE=");
                StringTokenizer stringTokenizer = new StringTokenizer(string3.substring(5), string2);
                boolean bl3 = false;
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (string4.equals(string)) continue;
                    if (bl3) {
                        stringBuilder.append(string2);
                    }
                    bl3 = true;
                    stringBuilder.append(string4);
                }
            }
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractProfProvider) {
            AbstractProfProvider abstractProfProvider = (AbstractProfProvider)object;
            if (!abstractProfProvider.getSubType().equals(this.getSubType())) {
                return false;
            }
            if (this.direct == null ? abstractProfProvider.direct != null : !((Object)this.direct).equals(abstractProfProvider.direct)) {
                return false;
            }
            if (this.byEquipType == null ? abstractProfProvider.byEquipType != null : !((Object)this.byEquipType).equals(abstractProfProvider.byEquipType)) {
                return false;
            }
            return this.equalsPrereqObject(abstractProfProvider);
        }
        return false;
    }

    public int hashCode() {
        return (this.direct == null ? 0 : ((Object)this.direct).hashCode() * 29) + (this.byEquipType == null ? 0 : ((Object)this.byEquipType).hashCode());
    }
}

