/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content;

import pcgen.base.formula.Formula;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelCommandFactory
extends ConcretePrereqObject
implements Comparable<LevelCommandFactory> {
    private final CDOMSingleRef<PCClass> pcClass;
    private final Formula levels;

    public LevelCommandFactory(CDOMSingleRef<PCClass> cDOMSingleRef, Formula formula) {
        if (cDOMSingleRef == null) {
            throw new IllegalArgumentException("Class Reference for LevelCommandFactory cannot be null");
        }
        if (formula == null) {
            throw new IllegalArgumentException("Level Formula for LevelCommandFactory cannot be null");
        }
        this.pcClass = cDOMSingleRef;
        this.levels = formula;
    }

    public Formula getLevelCount() {
        return this.levels;
    }

    public PCClass getPCClass() {
        return this.pcClass.resolvesTo();
    }

    public String getLSTformat() {
        return this.pcClass.getLSTformat();
    }

    public int hashCode() {
        return this.pcClass.hashCode() * 29 + this.levels.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LevelCommandFactory)) {
            return false;
        }
        LevelCommandFactory levelCommandFactory = (LevelCommandFactory)object;
        return this.levels.equals(levelCommandFactory.levels) && this.pcClass.equals(levelCommandFactory.pcClass);
    }

    @Override
    public int compareTo(LevelCommandFactory levelCommandFactory) {
        int n = ReferenceUtilities.REFERENCE_SORTER.compare(this.pcClass, levelCommandFactory.pcClass);
        if (n == 0) {
            if (this.levels.equals(levelCommandFactory.levels)) {
                return 0;
            }
            if (this.levels == levelCommandFactory.levels) {
                return 0;
            }
            return this.levels.toString().compareTo(levelCommandFactory.levels.toString());
        }
        return n;
    }

    public void add(PlayerCharacter playerCharacter) {
        this.apply(playerCharacter, this.levels.resolve(playerCharacter, "").intValue());
    }

    public void remove(PlayerCharacter playerCharacter) {
        this.apply(playerCharacter, -this.levels.resolve(playerCharacter, "").intValue());
    }

    private void apply(PlayerCharacter playerCharacter, int n) {
        boolean bl = SettingsHandler.getShowHPDialogAtLevelUp();
        SettingsHandler.setShowHPDialogAtLevelUp(false);
        boolean bl2 = SettingsHandler.getShowFeatDialogAtLevelUp();
        SettingsHandler.setShowFeatDialogAtLevelUp(false);
        int n2 = SettingsHandler.getSingleChoicePreference();
        SettingsHandler.setSingleChoicePreference(2);
        playerCharacter.incrementClassLevel(n, this.pcClass.resolvesTo(), true, true);
        SettingsHandler.setSingleChoicePreference(n2);
        SettingsHandler.setShowFeatDialogAtLevelUp(bl2);
        SettingsHandler.setShowHPDialogAtLevelUp(bl);
    }
}

