/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.list.ClassSpellList;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.SpellLevel;
import pcgen.core.spell.Spell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnownSpellIdentifier
extends ConcretePrereqObject {
    private final CDOMReference<Spell> ref;
    private final Integer spellLevel;

    public KnownSpellIdentifier(CDOMReference<Spell> cDOMReference, Integer n) {
        if (cDOMReference == null && n == null) {
            throw new IllegalArgumentException("Known Spell Identifier cannot have null spell reference and level limit");
        }
        this.ref = cDOMReference;
        this.spellLevel = n;
    }

    public boolean matchesFilter(Spell spell, int n) {
        return !(this.ref != null && !this.ref.contains(spell) || this.spellLevel != null && n != this.spellLevel);
    }

    public CDOMReference<Spell> getSpellReference() {
        return this.ref;
    }

    public Integer getSpellLevel() {
        return this.spellLevel;
    }

    public Collection<Spell> getContainedSpells(PlayerCharacter playerCharacter, List<ClassSpellList> list) {
        if (this.ref == null) {
            return Globals.getSpellsIn(this.spellLevel, list, playerCharacter);
        }
        ArrayList<Spell> arrayList = new ArrayList<Spell>();
        for (Spell spell : this.ref.getContainedObjects()) {
            HashMapToList<CDOMList<Spell>, Integer> hashMapToList = SpellLevel.getMasterLevelInfo(null, spell);
            for (CDOMList cDOMList : hashMapToList.getKeySet()) {
                if (!list.contains(cDOMList) || this.spellLevel != null && !hashMapToList.getListFor(cDOMList).contains(this.spellLevel)) continue;
                arrayList.add(spell);
            }
        }
        return arrayList;
    }

    public int hashCode() {
        return this.spellLevel == null ? this.ref.hashCode() : this.spellLevel * this.ref.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KnownSpellIdentifier)) {
            return false;
        }
        KnownSpellIdentifier knownSpellIdentifier = (KnownSpellIdentifier)object;
        if (this.spellLevel == null) {
            return knownSpellIdentifier.spellLevel == null && this.ref.equals(knownSpellIdentifier.ref);
        }
        if (this.ref == null) {
            return knownSpellIdentifier.ref == null && this.spellLevel.equals(knownSpellIdentifier.spellLevel);
        }
        return this.spellLevel.equals(knownSpellIdentifier.spellLevel) && this.ref.equals(knownSpellIdentifier.ref);
    }

    public String getLSTformat() {
        return this.ref.getLSTformat();
    }
}

