/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.choiceset;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.helper.AbilitySelection;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Ability;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.pclevelinfo.PCLevelInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilityFromClassChoiceSet
implements PrimitiveChoiceSet<AbilitySelection> {
    private final CDOMSingleRef<PCClass> cl;

    public AbilityFromClassChoiceSet(CDOMSingleRef<PCClass> cDOMSingleRef) {
        this.cl = cDOMSingleRef;
    }

    @Override
    public String getLSTformat(boolean bl) {
        return "CLASS." + this.cl.getLSTformat();
    }

    public boolean equals(Object object) {
        if (object instanceof AbilityFromClassChoiceSet) {
            AbilityFromClassChoiceSet abilityFromClassChoiceSet = (AbilityFromClassChoiceSet)object;
            return this.cl.equals(abilityFromClassChoiceSet.cl);
        }
        return false;
    }

    public int hashCode() {
        return this.cl.hashCode();
    }

    @Override
    public Class<? super AbilitySelection> getChoiceClass() {
        return AbilitySelection.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<AbilitySelection> getSet(PlayerCharacter playerCharacter) {
        PCClass pCClass = this.cl.resolvesTo().getActiveEquivalent(playerCharacter);
        HashSet<AbilitySelection> hashSet = new HashSet<AbilitySelection>();
        if (pCClass != null) {
            void var5_9;
            for (PCLevelInfo object : playerCharacter.getLevelInfo()) {
                if (!object.getClassKeyName().equalsIgnoreCase(pCClass.getKeyName())) continue;
                for (Ability ability : object.getObjects()) {
                    hashSet.add(new AbilitySelection(ability, ability.getAbilityNature()));
                }
            }
            List<Ability> list = playerCharacter.getAssocList(pCClass, AssociationListKey.ADDED_FEAT);
            if (list != null) {
                for (Ability ability : list) {
                    hashSet.add(new AbilitySelection(ability, ability.getAbilityNature()));
                }
            }
            boolean bl = false;
            while (var5_9 < pCClass.getLevel()) {
                PCClassLevel pCClassLevel = pCClass.getClassLevel((int)var5_9);
                list = playerCharacter.getAssocList(pCClassLevel, AssociationListKey.ADDED_FEAT);
                if (list != null) {
                    for (Ability ability : list) {
                        hashSet.add(new AbilitySelection(ability, ability.getAbilityNature()));
                    }
                }
                ++var5_9;
            }
        }
        return null;
    }
}

