/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import pcgen.base.util.ListSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyMap<V> {
    private final Map<String, V> forwardMap = new TreeMap<String, V>(String.CASE_INSENSITIVE_ORDER);
    private final Map<V, String> reverseMap = new IdentityHashMap<V, String>();

    public void clear() {
        this.forwardMap.clear();
        this.reverseMap.clear();
    }

    public boolean containsKey(Object object) {
        return this.forwardMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.reverseMap.containsKey(object);
    }

    public V get(Object object) {
        return this.forwardMap.get(object);
    }

    public String getKeyFor(Object object) {
        return this.reverseMap.get(object);
    }

    public boolean isEmpty() {
        return this.forwardMap.isEmpty();
    }

    public Set<String> keySet() {
        return new LinkedHashSet<String>(this.forwardMap.keySet());
    }

    public V put(String string, V v) {
        V v2 = this.forwardMap.put(string, v);
        this.reverseMap.remove(v2);
        this.reverseMap.put((String)v, string);
        return v2;
    }

    public void putAll(Map<? extends String, ? extends V> map) {
        for (Map.Entry<String, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public V remove(Object object) {
        if (object == null) {
            return null;
        }
        V v = this.forwardMap.remove(object);
        this.reverseMap.remove(v);
        return v;
    }

    public int size() {
        return this.forwardMap.size();
    }

    public Collection<V> values() {
        return new ListSet<V>(this.forwardMap.values());
    }

    public String toString() {
        return "KeyMap: " + this.forwardMap.toString();
    }
}

