/*
 * Decompiled with CFR 0.152.
 */
package gmgen.pluginmgr;

import gmgen.pluginmgr.ErrorListDialog;
import gmgen.pluginmgr.JARClassLoader;
import gmgen.pluginmgr.Plugin;
import gmgen.util.MiscUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.persistence.lst.prereq.PreMultParser;
import pcgen.rules.persistence.TokenLibrary;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginLoader {
    private static List<Plugin.JAR> jars = new ArrayList<Plugin.JAR>();
    private static List<Plugin> pluginCache = null;
    private static List<ErrorListDialog.ErrorEntry> pluginErrors;
    private static PluginLoader inst;
    private static Map<String, String> loadedMap;

    protected PluginLoader() {
        File file;
        if (SettingsHandler.getGmgenPluginDir().toString().equals("")) {
            SettingsHandler.setGmgenPluginDir(new File(Globals.getDefaultPath() + File.separator + "plugins"));
        }
        if (!(file = SettingsHandler.getGmgenPluginDir()).exists()) {
            file.mkdirs();
        }
        PluginLoader.loadPlugins(file);
    }

    public static PluginLoader inst() {
        if (inst == null) {
            inst = new PluginLoader();
        }
        return inst;
    }

    public void startSystemPlugins(String string) {
        if (loadedMap.get(string) == null) {
            for (Plugin.JAR jAR : jars) {
                jAR.getClassLoader().startAllPlugins(string);
            }
            loadedMap.put(string, string);
            if (string.equals("Tokens")) {
                TokenLibrary.addToTokenMap(new PreMultParser());
            }
        }
    }

    public static Plugin getPlugin(String string) {
        for (Plugin plugin : PluginLoader.getPlugins()) {
            if (!plugin.getClassName().equals(string)) continue;
            return plugin;
        }
        return null;
    }

    public static List<Plugin> getPlugins() {
        if (pluginCache == null) {
            pluginCache = new ArrayList<Plugin>(500);
            for (Plugin.JAR jAR : jars) {
                jAR.getPlugins(pluginCache);
            }
        }
        return pluginCache;
    }

    public static void addPluginJAR(Plugin.JAR jAR) {
        jars.add(jAR);
        pluginCache = null;
    }

    static void pluginError(String string, String string2, Object[] objectArray) {
        if (pluginErrors == null) {
            pluginErrors = new ArrayList<ErrorListDialog.ErrorEntry>();
        }
        pluginErrors.add(new ErrorListDialog.ErrorEntry(string, string2, objectArray));
    }

    private static void loadPlugins(File file) {
        Logging.debugPrint("Loading plugins from " + file);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = MiscUtilities.constructPath(file.toString(), string);
            File file2 = new File(string2);
            if (string.indexOf("plugin") > -1 && file2.isDirectory()) {
                PluginLoader.loadPlugins(file2);
            }
            if (!string.regionMatches(true, string.length() - 4, ".jar", 0, 4)) continue;
            try {
                Logging.debugPrint("Scanning JAR file: " + string2);
                new JARClassLoader(string2);
                continue;
            }
            catch (IOException iOException) {
                Logging.errorPrint("Cannot load plugin " + string + ": " + iOException.getMessage(), iOException);
                Object[] objectArray = new String[]{iOException.toString()};
                PluginLoader.pluginError(string2, "plugin-error.load-error", objectArray);
            }
        }
    }

    static {
        loadedMap = new HashMap<String, String>();
    }
}

