/*
 * Decompiled with CFR 0.152.
 */
package gmgen.gui;

import gmgen.gui.PreferencesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import pcgen.core.SettingsHandler;

public class PreferencesPluginsPanel
extends PreferencesPanel {
    public static final HashMap<String, PluginRef> pluginMap = new HashMap();
    private JPanel mainPanel;
    private JScrollPane jScrollPane1;

    public PreferencesPluginsPanel() {
        this.initComponents();
        this.initPreferences();
    }

    public void applyPreferences() {
        for (String string : pluginMap.keySet()) {
            pluginMap.get(string).applyPreferences();
        }
    }

    public void initPreferences() {
        for (String string : pluginMap.keySet()) {
            pluginMap.get(string).initPreferences();
        }
    }

    public String toString() {
        return "Plugin Launch";
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.mainPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        for (String string : pluginMap.keySet()) {
            this.mainPanel.add(pluginMap.get(string));
        }
        this.jScrollPane1.setViewportView(this.mainPanel);
        this.add((Component)this.jScrollPane1, "Center");
        this.add((Component)new JLabel("All changes will take effect the next time PCGen is restarted"), "South");
    }

    public static void addPanel(String string, String string2, String string3) {
        if (!pluginMap.containsKey(string)) {
            PluginRef pluginRef = new PluginRef(string, string2, string3);
            pluginMap.put(string, pluginRef);
        }
    }

    private static class PluginRef
    extends JPanel {
        private String pluginName;
        private String pluginTitle;
        private String defaultSystem;
        private JCheckBox checkBox;
        private JRadioButton pcgenButton;
        private JRadioButton gmgenButton;

        public PluginRef(String string, String string2, String string3) {
            this.pluginName = string;
            this.pluginTitle = string2;
            this.defaultSystem = string3;
            this.initComponents();
        }

        private void initComponents() {
            this.checkBox = new JCheckBox();
            this.pcgenButton = new JRadioButton();
            this.gmgenButton = new JRadioButton();
            ButtonGroup buttonGroup = new ButtonGroup();
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(new TitledBorder(null, this.pluginTitle, 0, 0, new Font("Dialog", 1, 11)));
            this.checkBox.setText("Run this plugin?");
            this.add(this.checkBox);
            this.pcgenButton.setText("PCGen Window");
            buttonGroup.add(this.pcgenButton);
            this.add(this.pcgenButton);
            this.gmgenButton.setText("GMGen Window");
            buttonGroup.add(this.gmgenButton);
            this.add(this.gmgenButton);
        }

        public void initPreferences() {
            this.checkBox.setSelected(SettingsHandler.getGMGenOption(this.pluginName + ".Load", true));
            String string = SettingsHandler.getGMGenOption(this.pluginName + ".System", this.defaultSystem);
            if (string.equals("PCGen")) {
                this.pcgenButton.setSelected(true);
            } else {
                this.gmgenButton.setSelected(true);
            }
        }

        public void applyPreferences() {
            SettingsHandler.setGMGenOption(this.pluginName + ".Load", this.checkBox.isSelected());
            if (this.pcgenButton.isSelected()) {
                SettingsHandler.setGMGenOption(this.pluginName + ".System", "PCGen");
            } else {
                SettingsHandler.setGMGenOption(this.pluginName + ".System", "GMGen");
            }
        }
    }
}

