/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.base.util.MapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.Domain;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatToken
extends AbstractToken
implements CDOMPrimaryToken<Domain> {
    public static final Class<Ability> ABILITY_CLASS = Ability.class;

    public String getTokenName() {
        return "FEAT";
    }

    public boolean parse(LoadContext loadContext, Domain domain, String string) {
        return this.parseFeat(loadContext, (CDOMObject)domain, string);
    }

    public boolean parseFeat(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (".CLEAR".equals(string2)) {
                if (!bl) {
                    Logging.log((Level)Logging.LST_ERROR, (String)("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item: " + string));
                    return false;
                }
                loadContext.getListContext().removeAllFromList(this.getTokenName(), cDOMObject, Ability.FEATLIST);
            } else {
                CDOMReference cDOMReference = TokenUtilities.getTypeOrPrimitive((LoadContext)loadContext, ABILITY_CLASS, (Category)AbilityCategory.FEAT, (String)string2);
                if (cDOMReference == null) {
                    return false;
                }
                AssociatedPrereqObject associatedPrereqObject = loadContext.getListContext().addToList(this.getTokenName(), cDOMObject, Ability.FEATLIST, cDOMReference);
                associatedPrereqObject.setAssociation(AssociationKey.NATURE, (Object)Ability.Nature.AUTOMATIC);
                if (string2.indexOf(40) != -1) {
                    ArrayList arrayList = new ArrayList();
                    AbilityUtilities.getUndecoratedName((String)string2, arrayList);
                    associatedPrereqObject.setAssociation(AssociationKey.ASSOC_CHOICES, arrayList);
                }
            }
            bl = false;
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, Domain domain) {
        AssociatedChanges associatedChanges = loadContext.getListContext().getChangesInList(this.getTokenName(), (CDOMObject)domain, Ability.FEATLIST);
        MapToList mapToList = associatedChanges.getAddedAssociations();
        if ((mapToList == null || mapToList.isEmpty()) && !associatedChanges.includesGlobalClear()) {
            return null;
        }
        MapToList mapToList2 = associatedChanges.getAddedAssociations();
        Collection collection = associatedChanges.getRemoved();
        StringBuilder stringBuilder = new StringBuilder();
        if (associatedChanges.includesGlobalClear()) {
            if (collection != null && !collection.isEmpty()) {
                loadContext.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            stringBuilder.append(".CLEAR");
        } else if (collection != null && !collection.isEmpty()) {
            loadContext.addWriteMessage(this.getTokenName() + " does not support " + ".CLEAR.");
            return null;
        }
        if (mapToList2 != null && !mapToList2.isEmpty()) {
            boolean bl = stringBuilder.length() != 0;
            for (CDOMReference cDOMReference : mapToList2.getKeySet()) {
                String string = cDOMReference.getLSTformat();
                for (int i = 0; i < mapToList2.sizeOfListFor((Object)cDOMReference); ++i) {
                    if (bl) {
                        stringBuilder.append("|");
                    }
                    bl = true;
                    stringBuilder.append(string);
                }
            }
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return new String[]{stringBuilder.toString()};
    }

    public Class<Domain> getTokenClass() {
        return Domain.class;
    }
}

