/*
 * Decompiled with CFR 0.152.
 */
package plugin.encounter;

import gmgen.GMGenSystem;
import gmgen.GMGenSystemView;
import gmgen.io.ReadXML;
import gmgen.io.VectorTable;
import gmgen.plugin.Dice;
import gmgen.plugin.InitHolder;
import gmgen.plugin.InitHolderList;
import gmgen.plugin.PcgCombatant;
import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBMessage;
import gmgen.pluginmgr.GMBPlugin;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.messages.InitHolderListSendMessage;
import gmgen.pluginmgr.messages.StateChangedMessage;
import gmgen.pluginmgr.messages.TabAddMessage;
import gmgen.pluginmgr.messages.ToolMenuItemAddMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.filechooser.FileFilter;
import pcgen.cdom.content.ChallengeRating;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.core.character.EquipSet;
import pcgen.core.character.EquipSlot;
import pcgen.gui.utils.TabbedPaneUtilities;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserRadio;
import plugin.encounter.EncounterModel;
import plugin.encounter.EnvironmentModel;
import plugin.encounter.RaceModel;
import plugin.encounter.gui.EncounterView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncounterPlugin
extends GMBPlugin
implements ActionListener,
ItemListener,
MouseListener {
    public static final String LOG_NAME = "Encounter";
    private EncounterModel theModel;
    private EncounterView theView;
    private EnvironmentModel theEnvironments;
    private InitHolderList theList;
    private JMenuItem encounterToolsItem = new JMenuItem();
    private RaceModel theRaces;
    private String name = "Encounter";
    private String version = "01.00.99.01.00";

    public FileFilter[] getFileTypes() {
        return null;
    }

    public void start() {
        this.theModel = new EncounterModel(this.getDataDir());
        this.theView = new EncounterView();
        this.theRaces = new RaceModel();
        this.theList = new InitHolderList();
        this.createView();
        GMBus.send((GMBMessage)new TabAddMessage((GMBComponent)this, this.name, (Component)this.getView(), this.getPluginSystem()));
        this.initMenus();
    }

    public String getPluginSystem() {
        return SettingsHandler.getGMGenOption((String)"Encounter.System", (String)"GMGen");
    }

    public int getPluginLoadOrder() {
        return SettingsHandler.getGMGenOption((String)"Encounter.LoadOrder", (int)30);
    }

    public void setModel(EncounterModel encounterModel) {
        this.theModel = encounterModel;
    }

    public EncounterModel getModel() {
        return this.theModel;
    }

    public String getName() {
        return this.name;
    }

    public RaceModel getRaces() {
        return this.theRaces;
    }

    public String getVersion() {
        return this.version;
    }

    public void setView(EncounterView encounterView) {
        this.theView = encounterView;
    }

    public JPanel getView() {
        return this.theView;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.theView.getAddCreature()) {
            this.handleAddCreature();
        } else if (actionEvent.getSource() == this.theView.getRemoveCreature()) {
            this.handleRemoveCreature();
        } else if (actionEvent.getSource() == this.theView.getTransferToTracker()) {
            this.handleTransferToTracker();
        } else if (actionEvent.getSource() == this.theView.getGenerateEncounter()) {
            this.handleGenerateEncounter(this.theModel);
        } else {
            Logging.errorPrint((String)("Unhandled ActionEvent: " + actionEvent.getSource().toString()));
        }
        this.updateUI();
    }

    public void handleGenerateEncounter(EncounterModel encounterModel) {
        File file = new File(this.getDataDir() + File.separator + "encounter_tables" + File.separator + "environments.xml");
        if (!file.exists()) {
            Logging.errorPrint((String)"handleGenerateEncounter:");
            Logging.errorPrint((String)file.toString());
            return;
        }
        ReadXML readXML = new ReadXML(file);
        VectorTable vectorTable = readXML.getTable();
        this.theModel.clear();
        if (this.theView.getEnvironment().getSelectedIndex() == 0) {
            this.generateXofYEL(this.theView.getNumberOfCreatures().getText(), this.theView.getTargetEL());
        } else {
            this.generateXfromY(vectorTable.crossReference((Object)this.theView.getEnvironment().getSelectedItem().toString(), (Object)"File").toString());
        }
        this.updateUI();
    }

    public void handleAddCreature() {
        if (!this.theView.getLibraryCreatures().isSelectionEmpty()) {
            Object[] objectArray = this.theView.getLibraryCreatures().getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.theModel.addElement(objectArray[i]);
            }
            this.updateUI();
        }
    }

    public void handleMessage(GMBMessage gMBMessage) {
        if (gMBMessage instanceof StateChangedMessage) {
            if (this.isActive()) {
                this.updateUI();
                this.encounterToolsItem.setEnabled(false);
            } else {
                this.encounterToolsItem.setEnabled(true);
            }
        }
    }

    public boolean isActive() {
        JTabbedPane jTabbedPane = TabbedPaneUtilities.getTabbedPaneFor((Component)this.theView);
        return jTabbedPane != null && JOptionPane.getFrameForComponent(jTabbedPane).isFocused() && jTabbedPane.getSelectedComponent().equals(this.theView);
    }

    public void handleRemoveCreature() {
        if (!this.theView.getEncounterCreatures().isSelectionEmpty()) {
            Object[] objectArray = this.theView.getEncounterCreatures().getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.theModel.removeElement(objectArray[i]);
            }
            this.updateUI();
        }
    }

    public void handleTransferToTracker() {
        JFrame jFrame = Globals.getRootFrame();
        Globals.setRootFrame((JFrame)GMGenSystem.inst);
        this.theModel.setPCs(this.theModel.size());
        try {
            for (int i = 0; i < this.theModel.size(); ++i) {
                PlayerCharacter playerCharacter = this.theModel.getPCs()[i];
                Globals.setCurrentPC((PlayerCharacter)playerCharacter);
                playerCharacter.setImporting(false);
                if (!this.handleRace(playerCharacter, i)) continue;
                LevelCommandFactory levelCommandFactory = (LevelCommandFactory)playerCharacter.getRace().get(ObjectKey.MONSTER_CLASS);
                if (levelCommandFactory != null) {
                    this.handleMonster(playerCharacter, levelCommandFactory);
                } else {
                    this.handleNonMonster(playerCharacter);
                }
                this.handleEquipment(playerCharacter);
                playerCharacter.setPlayersName("Enemy");
                this.theList.add((InitHolder)new PcgCombatant(playerCharacter, "Enemy"));
            }
            JOptionPane.showMessageDialog(null, "You will now be returned to PCGen so that you can finalise your selected combatants.\nOnce they are finalised, return to the GMGen Initiative tab to begin the combat!", "Combatant Setup Complete", 1);
            GMBus.send((GMBMessage)new InitHolderListSendMessage((GMBComponent)this, this.theList));
            this.removeAll();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        Globals.setRootFrame((JFrame)jFrame);
    }

    public void initMenus() {
        this.encounterToolsItem.setMnemonic('n');
        this.encounterToolsItem.setText("Encounter Generator");
        this.encounterToolsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncounterPlugin.this.toolMenuItem(actionEvent);
            }
        });
        GMBus.send((GMBMessage)new ToolMenuItemAddMessage((GMBComponent)this, this.encounterToolsItem));
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.theView.getEnvironment().getSelectedIndex() == 0) {
            this.theView.getNumberOfCreatures().setEnabled(true);
            this.theView.getTargetEncounterLevel().setEnabled(true);
            this.theView.getNumberLabel().setEnabled(true);
            this.theView.getTargetLabel().setEnabled(true);
        } else {
            this.theView.getNumberOfCreatures().setEnabled(false);
            this.theView.getTargetEncounterLevel().setEnabled(false);
            this.theView.getNumberLabel().setEnabled(false);
            this.theView.getTargetLabel().setEnabled(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.theView.getLibraryCreatures()) {
            if (mouseEvent.getClickCount() == 2) {
                int n = this.theView.getLibraryCreatures().locationToIndex(mouseEvent.getPoint());
                ListModel listModel = this.theView.getLibraryCreatures().getModel();
                Object e = listModel.getElementAt(n);
                this.theView.getLibraryCreatures().ensureIndexIsVisible(n);
                this.theModel.addElement(e);
                this.updateUI();
            }
        } else if (mouseEvent.getSource() == this.theView.getEncounterCreatures()) {
            try {
                if (mouseEvent.getClickCount() == 2) {
                    int n = this.theView.getEncounterCreatures().locationToIndex(mouseEvent.getPoint());
                    ListModel listModel = this.theView.getEncounterCreatures().getModel();
                    Object e = listModel.getElementAt(n);
                    this.theView.getEncounterCreatures().ensureIndexIsVisible(n);
                    this.theModel.removeElement(e);
                    this.updateUI();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void createView() {
        this.theEnvironments = new EnvironmentModel(this.getDataDir());
        this.theView.getLibraryCreatures().setModel(this.theRaces);
        this.theView.getEncounterCreatures().setModel(this.theModel);
        this.theView.getEnvironment().setModel(this.theEnvironments);
        this.theView.getLibraryCreatures().addMouseListener(this);
        this.theView.getEncounterCreatures().addMouseListener(this);
        this.theView.getAddCreature().addActionListener(this);
        this.theView.getRemoveCreature().addActionListener(this);
        this.theView.getTransferToTracker().addActionListener(this);
        this.theView.getGenerateEncounter().addActionListener(this);
        this.theView.getEnvironment().addItemListener(this);
    }

    public void toolMenuItem(ActionEvent actionEvent) {
        JTabbedPane jTabbedPane = GMGenSystemView.getTabPane();
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            if (!(jTabbedPane.getComponentAt(i) instanceof EncounterView)) continue;
            jTabbedPane.setSelectedIndex(i);
        }
    }

    public void updateUI() {
        int n = this.theView.getEnvironment().getSelectedIndex();
        if (n == -1) {
            n = 0;
        }
        ArrayList arrayList = new ArrayList();
        for (int n2 : this.theView.getLibraryCreatures().getSelectedIndices()) {
            arrayList.add(this.theRaces.elementAt(n2));
        }
        this.theRaces.update();
        this.theEnvironments.update();
        for (int n3 : (Object)this.theModel.toArray()) {
            if (this.theRaces.contains(n3)) continue;
            this.theModel.removeElement(n3);
        }
        this.theView.getEnvironment().setSelectedIndex(n);
        this.theView.setTotalEncounterLevel(Integer.toString(this.theModel.getCR()));
        if (this.theRaces.getSize() > 1) {
            this.theView.getGenerateEncounter().setEnabled(true);
        } else {
            this.theView.getGenerateEncounter().setEnabled(false);
        }
        if (this.theModel.getSize() < 1) {
            this.theView.getTransferToTracker().setEnabled(false);
        } else {
            this.theView.getTransferToTracker().setEnabled(true);
        }
        Object object = new ArrayList();
        for (Object e : arrayList) {
            if (!this.theRaces.contains(e)) continue;
            ((ArrayList)object).add(this.theRaces.indexOf(e));
        }
        if (((ArrayList)object).size() > 0) {
            Object object2 = new int[((ArrayList)object).size()];
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object2[i] = (Integer)((ArrayList)object).get(i);
            }
            this.theView.getLibraryCreatures().setSelectedIndices((int[])object2);
        }
    }

    private Vector<?> getMonsterFromTable(String string) throws FileNotFoundException {
        Integer n;
        String string2;
        Random random = new Random(System.currentTimeMillis());
        if (string.startsWith("[")) {
            string2 = this.getDataDir() + File.separator + "encounter_tables" + File.separator + string.substring(1, string.length() - 1);
            Logging.errorPrint((String)("subfile " + string2));
        } else {
            string2 = string;
        }
        string2 = string2.concat(".xml");
        File file = new File(string2);
        if (!file.exists()) {
            Logging.errorPrint((String)("could not open " + string2));
            return null;
        }
        ReadXML readXML = new ReadXML(file);
        String string3 = readXML.findPercentageEntry(random.nextInt(99) + 1);
        String string4 = readXML.getTable().crossReference((Object)string3, (Object)"Monster").toString();
        String string5 = readXML.getTable().crossReference((Object)string3, (Object)"Number").toString();
        if (string4.startsWith("[")) {
            return this.getMonsterFromTable(string4.substring(1, string4.length() - 1));
        }
        try {
            n = Integer.valueOf(string5);
        }
        catch (NumberFormatException numberFormatException) {
            String[] stringArray = string5.split("d");
            n = 0;
            for (int i = 0; i < Integer.parseInt(stringArray[0]); ++i) {
                n = n + random.nextInt(Integer.parseInt(stringArray[1])) + 1;
            }
        }
        Vector<Integer> vector = new Vector<Integer>();
        vector.addElement(n);
        vector.addElement((Integer)Globals.getContext().ref.silentlyGetConstructedCDOMObject(Race.class, string4));
        return vector;
    }

    private String getNewIdPath(PlayerCharacter playerCharacter, EquipSet equipSet) {
        String string = "0";
        int n = 0;
        if (equipSet != null) {
            string = equipSet.getIdPath();
        }
        for (EquipSet equipSet2 : playerCharacter.getEquipSet()) {
            if (!equipSet2.getParentIdPath().equals(string) || equipSet2.getId() <= n) continue;
            n = equipSet2.getId();
        }
        return string + '.' + ++n;
    }

    private static List<String> getWeaponLocationChoices(int n, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(n + 2);
        if (n > 0) {
            arrayList.add("Primary Hand");
            for (int i = 1; i < n; ++i) {
                if (i > 1) {
                    arrayList.add("Secondary Hand " + i);
                    continue;
                }
                arrayList.add("Secondary Hand");
            }
            if (string.length() > 0) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private void addAllToEquipSet(PlayerCharacter playerCharacter, EquipSet equipSet) {
        List list = playerCharacter.getEquipmentList();
        for (int i = 0; i < list.size(); ++i) {
            Equipment equipment = (Equipment)list.get(i);
            this.addEquipToTarget(playerCharacter, equipSet, "", equipment.clone(), new Float(1.0f));
        }
    }

    private EquipSet createDefaultEquipset(PlayerCharacter playerCharacter) {
        EquipSet equipSet;
        if (playerCharacter.getEquipSet().size() == 0) {
            String string = this.getNewIdPath(playerCharacter, null);
            String string2 = "Default Set";
            equipSet = new EquipSet(string, string2);
            playerCharacter.addEquipSet(equipSet);
            Logging.debugPrint((String)("Adding EquipSet: " + string2));
        } else {
            equipSet = (EquipSet)playerCharacter.getEquipSet().get(0);
        }
        return equipSet;
    }

    private void generateXfromY(String string) {
        Vector<?> vector;
        try {
            vector = this.getMonsterFromTable(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logging.errorPrint((String)fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
            return;
        }
        if (vector.size() < 1) {
            Logging.debugPrint((String)"EncounterPlugin - generateXfromY found no matches");
            return;
        }
        for (int i = 0; i < (Integer)vector.firstElement(); ++i) {
            this.theModel.addElement(vector.lastElement().toString());
        }
    }

    private void generateXofYEL(String string, String string2) {
        File file = new File(this.getDataDir() + File.separator + "encounter_tables" + File.separator + "4_1.xml");
        Random random = new Random(System.currentTimeMillis());
        ArrayList<Race> arrayList = new ArrayList<Race>();
        if (!file.exists()) {
            Logging.errorPrint((String)("ACK! No FILE! " + file.toString()));
            return;
        }
        ReadXML readXML = new ReadXML(file);
        VectorTable vectorTable = readXML.getTable();
        if (vectorTable == null) {
            Logging.errorPrint((String)("ACK! error getting table41! " + file.toString()));
            return;
        }
        readXML = null;
        file = null;
        String string3 = (String)vectorTable.crossReference((Object)string2, (Object)string);
        vectorTable = null;
        if (string3 == null) {
            Logging.errorPrint((String)("Tables do not match the given parameters (" + string2 + ", " + string + ")"));
            return;
        }
        ChallengeRating challengeRating = new ChallengeRating(string3);
        for (Race race : Globals.getContext().ref.getConstructedCDOMObjects(Race.class)) {
            if (!challengeRating.equals(race.get(ObjectKey.CHALLENGE_RATING))) continue;
            arrayList.add(race);
        }
        int n = random.nextInt(arrayList.size());
        for (int i = 0; i < Integer.parseInt(string); ++i) {
            this.theModel.addElement(((Race)arrayList.get(n)).toString());
        }
    }

    private void handleEquipment(PlayerCharacter playerCharacter) {
        EquipSet equipSet = this.createDefaultEquipset(playerCharacter);
        this.addAllToEquipSet(playerCharacter, equipSet);
        playerCharacter.setCalcEquipSetId(equipSet.getIdPath());
        playerCharacter.setCalcEquipmentList();
    }

    private void handleMonster(PlayerCharacter playerCharacter, LevelCommandFactory levelCommandFactory) {
        PCClass pCClass = levelCommandFactory.getPCClass();
        pCClass.put(ObjectKey.IS_MONSTER, (Object)true);
        int n = levelCommandFactory.getLevelCount().resolve(playerCharacter, "").intValue();
        Logging.debugPrint((String)("Monster Class: " + pCClass.getDisplayName() + " Level: " + n));
        PCClass pCClass2 = playerCharacter.getClassKeyed(pCClass.getKeyName());
        int n2 = 0;
        if (pCClass2 != null) {
            n2 = pCClass2.getLevel();
        }
        if (n2 < n) {
            playerCharacter.incrementClassLevel(n - n2, pCClass);
        }
    }

    private void handleNonMonster(PlayerCharacter playerCharacter) {
        PCClass pCClass = (PCClass)Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCClass.class, "Warrior");
        if (pCClass != null) {
            Logging.debugPrint((String)("Class: " + pCClass.getDisplayName() + " Level: 1"));
            playerCharacter.incrementClassLevel(1, pCClass);
            this.rollHP(playerCharacter);
        }
    }

    private boolean handleRace(PlayerCharacter playerCharacter, int n) {
        Race race = (Race)Globals.getContext().ref.silentlyGetConstructedCDOMObject(Race.class, (String)this.theModel.getElementAt(n));
        if (race == null) {
            return false;
        }
        playerCharacter.setRace(race);
        playerCharacter.setName(race.toString());
        return true;
    }

    private final List<String> locationChoices(PlayerCharacter playerCharacter, Equipment equipment) {
        int n = 0;
        if (playerCharacter != null) {
            n = playerCharacter.getHands();
        }
        List<Object> list = new ArrayList<String>();
        if (equipment.isWeapon()) {
            if (equipment.isUnarmed()) {
                list.add("Unarmed");
            } else if (equipment.isWeaponLightForPC(playerCharacter)) {
                list = EncounterPlugin.getWeaponLocationChoices(n, "");
                if (equipment.isRanged() && !equipment.isThrown()) {
                    list.add("Both Hands");
                }
                if (equipment.isMelee()) {
                    list.add("Two Weapons");
                }
            } else if (equipment.isWeaponOneHanded(playerCharacter)) {
                list = EncounterPlugin.getWeaponLocationChoices(n, "Both Hands");
                if (equipment.isMelee()) {
                    if (equipment.isDouble()) {
                        list.add("Double Weapon");
                    } else {
                        list.add("Two Weapons");
                    }
                }
            } else {
                list.add("Both Hands");
                if (equipment.isMelee() && equipment.isDouble()) {
                    list.add("Double Weapon");
                }
            }
        } else {
            String string = EncounterPlugin.getSingleLocation(playerCharacter, equipment);
            if (string.length() != 0) {
                list.add(string);
            } else {
                list.add("Equipped");
            }
        }
        if (!equipment.isUnarmed()) {
            list.add("Carried");
            list.add("Not Carried");
        }
        return list;
    }

    private static String getSingleLocation(PlayerCharacter playerCharacter, Equipment equipment) {
        if (equipment.isNatural() && equipment.getSlots(playerCharacter) == 0) {
            if (equipment.modifiedName().endsWith("Primary")) {
                return "Natural-Primary";
            }
            return "Natural-Secondary";
        }
        List list = SystemCollections.getUnmodifiableEquipSlotList();
        if (list == null || list.isEmpty()) {
            return "";
        }
        for (EquipSlot equipSlot : list) {
            if (!equipSlot.canContainType(equipment.getType())) continue;
            return equipSlot.getSlotName();
        }
        return "";
    }

    private String getEquipLocation(PlayerCharacter playerCharacter, EquipSet equipSet, String string, Equipment equipment) {
        String string2 = string;
        if ("".equals(string2) || string2.length() == 0) {
            ArrayList arrayList = this.locationChoices(playerCharacter, equipment);
            string2 = EncounterPlugin.getSingleLocation(playerCharacter, equipment);
            if (string2.length() == 0 || !EncounterPlugin.canAddEquip(playerCharacter, equipSet, string2, equipment)) {
                ChooserRadio chooserRadio = ChooserFactory.getRadioInstance();
                chooserRadio.setAvailableList(arrayList);
                chooserRadio.setVisible(false);
                chooserRadio.setTitle(equipment.getName());
                chooserRadio.setMessageText("Select a location for this item");
                chooserRadio.setVisible(true);
                arrayList = chooserRadio.getSelectedList();
                if (arrayList.size() > 0) {
                    string2 = (String)arrayList.get(0);
                }
            }
        }
        if ("".equals(string2) || string2.length() == 0) {
            return null;
        }
        if (!EncounterPlugin.canAddEquip(playerCharacter, equipSet, string2, equipment)) {
            JOptionPane.showMessageDialog(null, "Can not equip " + equipment.getName() + " to " + string2, "GMGen", 0);
            return null;
        }
        return string2;
    }

    private static boolean canAddEquip(PlayerCharacter playerCharacter, EquipSet equipSet, String string, Equipment equipment) {
        Object object;
        String string2 = equipSet.getIdPath();
        if (string.startsWith("Carried") || string.startsWith("Equipped") || string.startsWith("Not Carried")) {
            return true;
        }
        if (equipment.isUnarmed()) {
            return true;
        }
        if (string.equals("Natural-Secondary")) {
            return true;
        }
        if (equipment.isWeaponTooLargeForPC(playerCharacter)) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (EquipSet equipSet2 : playerCharacter.getEquipSet()) {
            if (!equipSet2.getParentIdPath().startsWith(string2) || !equipSet2.getName().equals(string)) continue;
            object = equipSet2.getItem();
            String string3 = (String)hashMap.get(string);
            int n = 0;
            if (string3 != null) {
                n = Integer.parseInt(string3);
            }
            if (object != null) {
                n += object.getSlots(playerCharacter);
            }
            hashMap.put(string, String.valueOf(n));
        }
        for (EquipSet equipSet2 : playerCharacter.getEquipSet()) {
            if (!equipSet2.getParentIdPath().startsWith(string2)) continue;
            if (equipment.isWeapon()) {
                if (equipSet2.getName().equals(string)) {
                    return false;
                }
                if ((string.equals("Both Hands") || string.equals("Double Weapon") || string.equals("Two Weapons")) && (equipSet2.getName().equals("Primary Hand") || equipSet2.getName().equals("Secondary Hand") || equipSet2.getName().equals("Both Hands") || equipSet2.getName().equals("Double Weapon") || equipSet2.getName().equals("Two Weapons"))) {
                    return false;
                }
                if ((string.equals("Primary Hand") || string.equals("Secondary Hand")) && (equipSet2.getName().equals("Both Hands") || equipSet2.getName().equals("Double Weapon") || equipSet2.getName().equals("Two Weapons"))) {
                    return false;
                }
            }
            if (!equipSet2.getName().equals(string)) continue;
            object = (String)hashMap.get(string);
            int n = 0;
            if (object != null) {
                n = Integer.parseInt((String)object);
            }
            n += equipment.getSlots(playerCharacter);
            EquipSlot equipSlot = Globals.getEquipSlotByName((String)string);
            if (equipSlot == null) {
                return true;
            }
            for (String string4 : equipSlot.getContainType()) {
                if (!equipment.isType(string4) || n <= equipSlot.getSlotCount() + (int)playerCharacter.getTotalBonusTo("SLOTS", string4)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private EquipSet addEquipToTarget(PlayerCharacter playerCharacter, EquipSet equipSet, String string, Equipment equipment, Float f) {
        String string2 = this.getEquipLocation(playerCharacter, equipSet, string, equipment);
        String string3 = this.getNewIdPath(playerCharacter, equipSet);
        Logging.debugPrint((String)("--addEB-- IdPath:" + string3 + "  Parent:" + equipSet.getIdPath() + " Location:" + string2 + " eqName:" + equipment.getName() + "  eSet:" + equipSet.getName()));
        EquipSet equipSet2 = new EquipSet(string3, string2, equipment.getName(), equipment);
        equipment.setQty(f);
        equipSet2.setQty(f);
        playerCharacter.addEquipSet(equipSet2);
        playerCharacter.setCurrentEquipSetName(equipSet.getName());
        playerCharacter.getEquipSet();
        return equipSet2;
    }

    private void removeAll() {
        this.theModel.removeAllElements();
        this.theList = new InitHolderList();
        this.updateUI();
    }

    private void rollHP(PlayerCharacter playerCharacter) {
        for (PCClass pCClass : playerCharacter.getClassList()) {
            for (int i = 0; i < pCClass.getLevel(); ++i) {
                int n = (int)playerCharacter.getTotalBonusTo("HD", "MIN") + (int)playerCharacter.getTotalBonusTo("HD", "MIN;CLASS." + pCClass.getKeyName());
                int n2 = pCClass.getLevelHitDie(playerCharacter, i + 1).getDie();
                pCClass.setHitPoint(i, Integer.valueOf(new Dice(1, n2, n).roll()));
            }
        }
        playerCharacter.setCurrentHP(playerCharacter.hitPoints());
    }
}

