/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.add;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.choiceset.ReferenceChoiceSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Globals;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateToken
extends AbstractToken
implements CDOMSecondaryToken<CDOMObject>,
PersistentChoiceActor<PCTemplate> {
    private static final Class<PCTemplate> PCTEMPLATE_CLASS = PCTemplate.class;

    public String getParentToken() {
        return "ADD";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    public String getTokenName() {
        return "TEMPLATE";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        Object object;
        String string2;
        Formula formula;
        if (string.length() == 0) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getFullName() + " may not have empty argument"));
            return false;
        }
        int n = string.indexOf("|");
        if (n == -1) {
            formula = FormulaFactory.ONE;
            string2 = string;
        } else {
            object = string.substring(0, n);
            formula = FormulaFactory.getFormulaFor((String)object);
            if (formula.isStatic() && formula.resolve(null, "").doubleValue() <= 0.0) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Count in " + this.getFullName() + " must be > 0"));
                return false;
            }
            string2 = string.substring(n + 1);
        }
        if (this.isEmpty(string2) || this.hasIllegalSeparator(',', string2)) {
            return false;
        }
        object = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            object.add(loadContext.ref.getCDOMReference(PCTEMPLATE_CLASS, stringTokenizer.nextToken()));
        }
        ReferenceChoiceSet referenceChoiceSet = new ReferenceChoiceSet((Collection)object);
        ChoiceSet choiceSet = new ChoiceSet("TEMPLATE", (PrimitiveChoiceSet)referenceChoiceSet);
        PersistentTransitionChoice persistentTransitionChoice = new PersistentTransitionChoice(choiceSet, formula);
        loadContext.getObjectContext().addToList(cDOMObject, ListKey.ADD, (Object)persistentTransitionChoice);
        persistentTransitionChoice.setChoiceActor((ChoiceActor)this);
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Changes changes = loadContext.getObjectContext().getListChanges(cDOMObject, ListKey.ADD);
        Collection collection = changes.getAdded();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PersistentTransitionChoice persistentTransitionChoice : collection) {
            ChoiceSet choiceSet = persistentTransitionChoice.getChoices();
            if (!PCTEMPLATE_CLASS.equals(choiceSet.getChoiceClass())) continue;
            Formula formula = persistentTransitionChoice.getCount();
            if (formula == null) {
                loadContext.addWriteMessage("Unable to find " + this.getFullName() + " Count");
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (!FormulaFactory.ONE.equals(formula)) {
                stringBuilder.append(formula).append("|");
            }
            stringBuilder.append(choiceSet.getLSTformat());
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void applyChoice(CDOMObject cDOMObject, PCTemplate pCTemplate, PlayerCharacter playerCharacter) {
        playerCharacter.addTemplate(pCTemplate);
    }

    public boolean allow(PCTemplate pCTemplate, PlayerCharacter playerCharacter, boolean bl) {
        return playerCharacter.getTemplateKeyed(pCTemplate.getKeyName()) == null;
    }

    public PCTemplate decodeChoice(String string) {
        return (PCTemplate)Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCTEMPLATE_CLASS, string);
    }

    public String encodeChoice(Object object) {
        return ((PCTemplate)object).getKeyName();
    }

    public void restoreChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, PCTemplate pCTemplate) {
    }

    public void removeChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, PCTemplate pCTemplate) {
        playerCharacter.removeTemplate(pCTemplate);
    }
}

