/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.table;

import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.FormulaFactory;
import pcgen.core.kit.KitGear;
import pcgen.core.kit.KitTable;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValuesToken
extends AbstractToken
implements CDOMSecondaryToken<KitTable> {
    public String getTokenName() {
        return "VALUES";
    }

    public Class<KitTable> getTokenClass() {
        return KitTable.class;
    }

    public String getParentToken() {
        return "*KITTOKEN";
    }

    public boolean parse(LoadContext loadContext, KitTable kitTable, String string) throws PersistenceLayerException {
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            KitGear kitGear = new KitGear();
            for (String string3 : string2.split("[\\[\\]]")) {
                if (string3.length() == 0) continue;
                int n = string3.indexOf(58);
                if (n == -1) {
                    Logging.errorPrint((String)("Expected colon in Value item: " + string3 + " within: " + string));
                    return false;
                }
                String string4 = string3.substring(0, n);
                String string5 = string3.substring(n + 1);
                if (loadContext.processSubToken((Object)kitGear, this.getParentToken(), string4, string5)) continue;
                return false;
            }
            if (!stringTokenizer.hasMoreTokens()) {
                Logging.errorPrint((String)("Odd token count in Value: " + string));
                return false;
            }
            String object = stringTokenizer.nextToken();
            if (this.processRange(kitTable, kitGear, object)) continue;
            Logging.errorPrint((String)("Invalid Range in Value: " + object + " within " + string));
            return false;
        }
        return true;
    }

    private boolean processRange(KitTable kitTable, KitGear kitGear, String string) {
        String string2;
        String string3;
        if (this.hasIllegalSeparator(',', string)) {
            return false;
        }
        int n = string.indexOf(44);
        if (n == -1) {
            string3 = string;
            string2 = string;
        } else {
            if (n != string.lastIndexOf(44)) {
                return false;
            }
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        Formula formula = FormulaFactory.getFormulaFor((String)string3);
        Formula formula2 = FormulaFactory.getFormulaFor((String)string2);
        kitTable.addGear(kitGear, formula, formula2);
        return true;
    }

    public String[] unparse(LoadContext loadContext, KitTable kitTable) {
        StringBuilder stringBuilder = new StringBuilder();
        List list = kitTable.getList();
        if (list.isEmpty()) {
            return null;
        }
        boolean bl = true;
        for (KitTable.TableEntry tableEntry : list) {
            String[] stringArray;
            if (!bl) {
                stringBuilder.append("|");
            }
            if ((stringArray = loadContext.unparseSubtoken((Object)tableEntry.gear, this.getParentToken())).length == 1) {
                stringBuilder.append(stringArray[0]);
            } else {
                for (String string : stringArray) {
                    stringBuilder.append('[');
                    stringBuilder.append(string);
                    stringBuilder.append(']');
                }
            }
            stringBuilder.append("|");
            stringBuilder.append(tableEntry.lowRange.toString());
            if (!tableEntry.lowRange.equals(tableEntry.highRange)) {
                stringBuilder.append(',');
                stringBuilder.append(tableEntry.highRange.toString());
            }
            bl = false;
        }
        return new String[]{stringBuilder.toString()};
    }
}

