/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Domain;
import pcgen.core.PCClass;
import pcgen.core.QualifiedObject;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainToken
extends AbstractToken
implements CDOMPrimaryToken<PCClass> {
    private static final Class<Domain> DOMAIN_CLASS = Domain.class;

    public String getTokenName() {
        return "DOMAIN";
    }

    public boolean parse(LoadContext loadContext, PCClass pCClass, String string) {
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2;
            String string3 = stringTokenizer.nextToken();
            if (".CLEAR".equals(string3)) {
                if (!bl) {
                    Logging.log((Level)Logging.LST_ERROR, (String)("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item"));
                    return false;
                }
                loadContext.getObjectContext().removeList((CDOMObject)pCClass, ListKey.DOMAIN);
                continue;
            }
            Prerequisite prerequisite = null;
            int n = string3.indexOf(91);
            if (n == -1) {
                if (string3.indexOf(93) != -1) {
                    Logging.errorPrint((String)("Invalid " + this.getTokenName() + " must have '[' if it contains a PREREQ tag"));
                    return false;
                }
                string2 = string3;
            } else {
                if (string3.indexOf(93) != string3.length() - 1) {
                    Logging.errorPrint((String)("Invalid " + this.getTokenName() + " must end with ']' if it contains a PREREQ tag"));
                    return false;
                }
                string2 = string3.substring(0, n);
                object = string3.substring(n + 1, string3.length() - 1);
                if (((String)object).length() == 0) {
                    Logging.errorPrint((String)(this.getTokenName() + " cannot have empty prerequisite : " + string));
                    return false;
                }
                prerequisite = this.getPrerequisite((String)object);
                if (prerequisite == null) {
                    Logging.errorPrint((String)(this.getTokenName() + " had invalid prerequisite : " + (String)object));
                    return false;
                }
            }
            object = loadContext.ref.getCDOMReference(DOMAIN_CLASS, string2);
            QualifiedObject qualifiedObject = new QualifiedObject(object);
            if (prerequisite != null) {
                qualifiedObject.addPrerequisite(prerequisite);
            }
            loadContext.getObjectContext().addToList((CDOMObject)pCClass, ListKey.DOMAIN, (Object)qualifiedObject);
            bl = false;
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, PCClass pCClass) {
        Collection collection;
        Changes changes = loadContext.getObjectContext().getListChanges((CDOMObject)pCClass, ListKey.DOMAIN);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (changes.includesGlobalClear()) {
            arrayList.add(".CLEAR");
        }
        if ((collection = changes.getRemoved()) != null && !collection.isEmpty()) {
            loadContext.addWriteMessage(this.getTokenName() + " does not support .CLEAR.");
            return null;
        }
        Collection collection2 = changes.getAdded();
        if (collection2 != null && !collection2.isEmpty()) {
            PrerequisiteWriter prerequisiteWriter = new PrerequisiteWriter();
            for (QualifiedObject qualifiedObject : collection2) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(((CDOMSingleRef)qualifiedObject.getObject(null)).getLSTformat());
                if (qualifiedObject.hasPrerequisites()) {
                    List list = qualifiedObject.getPrerequisiteList();
                    if (list.size() > 1) {
                        loadContext.addWriteMessage("Incoming Edge to " + pCClass.getKeyName() + " had more than one " + "Prerequisite: " + list.size());
                        return null;
                    }
                    stringBuilder.append('[');
                    StringWriter stringWriter = new StringWriter();
                    try {
                        prerequisiteWriter.write((Writer)stringWriter, (Prerequisite)list.get(0));
                    }
                    catch (PersistenceLayerException persistenceLayerException) {
                        loadContext.addWriteMessage("Error writing Prerequisite: " + (Object)((Object)persistenceLayerException));
                        return null;
                    }
                    stringBuilder.append(stringWriter.toString());
                    stringBuilder.append(']');
                }
                arrayList.add(stringBuilder.toString());
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return new String[]{StringUtil.join(arrayList, (String)"|")};
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

