/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import gmgen.GMGenSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pcgen.core.RollingMethods;
import plugin.initiative.DiceRollModel;

public class DiceRollDialog
extends JDialog {
    DiceRollModel m_model = null;
    protected JButton m_ok;
    protected JButton m_doRoll;
    protected JLabel m_result;
    protected JTextField m_roll;
    protected List<Component> m_fields = new ArrayList<Component>();
    protected List<Component> m_labels = new ArrayList<Component>();
    protected JPanel m_buttons;
    protected JPanel m_mainPanel;
    protected JPanel m_fieldPanel;
    protected JPanel m_labelPanel;

    public DiceRollDialog(DiceRollModel diceRollModel) throws HeadlessException {
        this.m_model = diceRollModel;
        this.initComponents();
    }

    protected void handleOk(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    protected void handleRoll(ActionEvent actionEvent) {
        this.setResult(RollingMethods.roll((String)this.m_roll.getText()));
    }

    protected void initComponents() {
        this.setTitle(this.m_model.toString());
        this.addRollField("Roll:");
        this.initResult("Result:");
        this.initPanels();
        this.initButtons();
        this.initListeners();
        this.sizeAndLocate();
    }

    protected void sizeAndLocate() {
        this.pack();
        this.setLocationRelativeTo((Component)GMGenSystem.inst);
    }

    protected void initResult(String string) {
        this.m_result = new JLabel("<html><body><b>-</b></body></html>");
        this.m_result.setMinimumSize(new Dimension(100, (int)this.m_result.getMinimumSize().getWidth()));
        this.m_result.setPreferredSize(new Dimension(100, (int)this.m_result.getPreferredSize().getWidth()));
        JLabel jLabel = null;
        jLabel = new JLabel(string);
        jLabel.setAlignmentX(1.0f);
        this.addComponent(this.m_result, jLabel);
    }

    protected void initPanels() {
        this.m_mainPanel = new JPanel(new BorderLayout(5, 5));
        this.m_labelPanel = new JPanel(new GridLayout(0, 1));
        this.m_fieldPanel = new JPanel(new GridLayout(0, 1));
        for (Component component : this.m_labels) {
            this.m_labelPanel.add(component);
        }
        for (Component component : this.m_fields) {
            this.m_fieldPanel.add(component);
        }
        this.m_mainPanel.add((Component)this.m_labelPanel, "Center");
        this.m_mainPanel.add((Component)this.m_fieldPanel, "East");
        this.getContentPane().add((Component)this.m_mainPanel, "Center");
    }

    protected void addRollField(String string) {
        this.m_roll = new JTextField(this.m_model.getExpression());
        JLabel jLabel = new JLabel(string);
        jLabel.setAlignmentX(1.0f);
        this.addComponent(this.m_roll, jLabel);
    }

    protected void initButtons() {
        this.m_buttons = new JPanel();
        this.m_buttons.setLayout(new BoxLayout(this.m_buttons, 0));
        this.m_buttons.add(Box.createHorizontalGlue());
        this.m_doRoll = new JButton("Roll");
        this.m_buttons.add(this.m_doRoll);
        this.m_buttons.add(this.m_doRoll);
        this.m_buttons.add(Box.createHorizontalStrut(10));
        this.m_ok = new JButton("Ok");
        this.m_buttons.add(this.m_ok);
        this.getContentPane().add((Component)this.m_buttons, "South");
    }

    protected void initListeners() {
        this.m_doRoll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiceRollDialog.this.handleRoll(actionEvent);
            }
        });
        this.m_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiceRollDialog.this.handleOk(actionEvent);
            }
        });
    }

    protected void addComponent(Component component, Component component2) {
        this.m_fields.add(component);
        this.m_labels.add(component2);
    }

    protected void setResult(int n) {
        this.m_result.setText("<html><body><b>" + n + "</b></body></html>");
    }
}

