/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative;

import gmgen.plugin.PcgCombatant;
import java.util.List;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.RollingMethods;
import pcgen.core.Skill;
import pcgen.core.analysis.SkillModifier;
import pcgen.core.analysis.SkillRankControl;
import plugin.initiative.OpposedSkillBasicModel;

public class OpposedSkillModel
extends OpposedSkillBasicModel {
    protected String skillName;

    public OpposedSkillModel() {
        this.columns.addColumn("BONUS", Integer.class, 0, false, "Bonus");
        this.columns.addColumn("FUDGE", Integer.class, null, true, "Fudge");
        this.columns.addColumn("RESULT", Integer.class, null, false, "Result");
    }

    public OpposedSkillModel(List list) {
        super(list);
        this.columns.addColumn("BONUS", Integer.class, 0, false, "Bonus");
        this.columns.addColumn("FUDGE", Integer.class, null, true, "Fudge");
        this.columns.addColumn("RESULT", Integer.class, null, false, "Result");
    }

    public Object getValueAt(int n, int n2) {
        Object object = null;
        if (n < this.combatants.size()) {
            SkillInitWrapper skillInitWrapper = (SkillInitWrapper)this.getRowEntry(n);
            switch (n2) {
                case 0: {
                    object = super.getValueAt(n, n2);
                    break;
                }
                case 1: {
                    object = skillInitWrapper.getSkillBonus(this.skillName);
                    break;
                }
                case 2: {
                    object = skillInitWrapper.getFudge();
                    break;
                }
                case 3: {
                    object = skillInitWrapper.getResult();
                }
            }
        }
        return object;
    }

    public void roll(int n) {
        if (n < this.combatants.size()) {
            ((SkillInitWrapper)this.getRowEntry(n)).roll();
            this.fireTableCellUpdated(n, 3);
        }
    }

    public void rollAll() {
        for (int i = 0; i < this.combatants.size(); ++i) {
            this.roll(i);
        }
    }

    public void setSkill(String string) {
        this.skillName = string;
        this.rollAll();
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n < this.combatants.size() && n2 == 2 && object instanceof Integer) {
            SkillInitWrapper skillInitWrapper = (SkillInitWrapper)this.getRowEntry(n);
            skillInitWrapper.setFudge((Integer)object);
        } else {
            super.setValueAt(object, n, n2);
        }
    }

    public void addCombatant(PcgCombatant pcgCombatant) {
        this.combatants.put(pcgCombatant.getName(), new SkillInitWrapper(pcgCombatant));
        int n = this.getIndexOf(pcgCombatant.getName());
        this.fireTableRowsInserted(n, n);
    }

    protected class SkillInitWrapper
    extends OpposedSkillBasicModel.InitWrapper {
        private Integer fudge;
        private Integer result;
        private Integer roll;

        public SkillInitWrapper(PcgCombatant pcgCombatant) {
            super(pcgCombatant);
            this.fudge = null;
            this.result = null;
            this.roll = null;
            if (OpposedSkillModel.this.skillName != null) {
                this.roll();
            }
        }

        public Integer getSkillBonus(String string) {
            Integer n = null;
            if (this.initiative != null && string != null) {
                PlayerCharacter playerCharacter = this.initiative.getPC();
                Globals.setCurrentPC((PlayerCharacter)playerCharacter);
                Skill skill = playerCharacter.getSkillKeyed(string);
                if (skill != null) {
                    n = SkillModifier.modifier((Skill)skill, (PlayerCharacter)playerCharacter) + SkillRankControl.getTotalRank((PlayerCharacter)playerCharacter, (Skill)skill).intValue();
                } else {
                    skill = (Skill)Globals.getContext().ref.silentlyGetConstructedCDOMObject(Skill.class, string);
                    if (skill != null && ((Boolean)skill.getSafe(ObjectKey.USE_UNTRAINED)).booleanValue() && skill.get(ObjectKey.KEY_STAT) != null) {
                        n = (int)SkillModifier.modifier((Skill)skill, (PlayerCharacter)playerCharacter);
                    }
                }
            }
            return n;
        }

        public void roll() {
            this.roll = RollingMethods.roll((String)"1d20");
            this.calc();
        }

        public void calc() {
            Integer n = this.getSkillBonus(OpposedSkillModel.this.skillName);
            if (n != null && this.roll != null) {
                int n2 = this.roll;
                n2 += n.intValue();
                n = this.fudge;
                if (n != null) {
                    n2 += n.intValue();
                }
                this.result = n2;
            } else {
                this.result = null;
            }
        }

        public Integer getFudge() {
            return this.fudge;
        }

        public void setFudge(Integer n) {
            this.fudge = n;
            this.calc();
        }

        public Integer getResult() {
            return this.result;
        }

        public void setResult(Integer n) {
            this.result = n;
        }
    }
}

