/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.add;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.choiceset.ReferenceChoiceSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PlayerCharacter;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageToken
extends AbstractToken
implements CDOMSecondaryToken<CDOMObject>,
PersistentChoiceActor<Language> {
    private static final Class<Language> LANGUAGE_CLASS = Language.class;

    public String getParentToken() {
        return "ADD";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    public String getTokenName() {
        return "LANGUAGE";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        CDOMGroupRef cDOMGroupRef;
        String string2;
        Object object;
        String string3;
        Formula formula;
        if (string.length() == 0) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getFullName() + " may not have empty argument"));
            return false;
        }
        int n = string.indexOf("|");
        if (n == -1) {
            formula = FormulaFactory.ONE;
            string3 = string;
        } else {
            object = string.substring(0, n);
            formula = FormulaFactory.getFormulaFor((String)object);
            if (formula.isStatic() && formula.resolve(null, "").doubleValue() <= 0.0) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Count in " + this.getFullName() + " must be > 0"));
                return false;
            }
            string3 = string.substring(n + 1);
        }
        if (this.isEmpty(string3) || this.hasIllegalSeparator(',', string3)) {
            return false;
        }
        object = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        boolean bl = false;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if ("ALL".equals(string2)) {
                bl = true;
                cDOMGroupRef = loadContext.ref.getCDOMAllReference(LANGUAGE_CLASS);
            } else {
                bl2 = true;
                cDOMGroupRef = TokenUtilities.getTypeOrPrimitive((LoadContext)loadContext, LANGUAGE_CLASS, (String)string2);
            }
            if (cDOMGroupRef == null) {
                Logging.log((Level)Logging.LST_ERROR, (String)("  Error was encountered while parsing " + this.getFullName() + ": " + string + " had an invalid reference: " + string2));
                return false;
            }
            object.add(cDOMGroupRef);
        }
        if (bl && bl2) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + string));
            return false;
        }
        string2 = new ReferenceChoiceSet((Collection)object);
        cDOMGroupRef = new ChoiceSet(this.getTokenName(), (PrimitiveChoiceSet)string2);
        PersistentTransitionChoice persistentTransitionChoice = new PersistentTransitionChoice((ChoiceSet)cDOMGroupRef, formula);
        loadContext.getObjectContext().addToList(cDOMObject, ListKey.ADD, (Object)persistentTransitionChoice);
        persistentTransitionChoice.setTitle("Language Choice");
        persistentTransitionChoice.setChoiceActor((ChoiceActor)this);
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Changes changes = loadContext.getObjectContext().getListChanges(cDOMObject, ListKey.ADD);
        Collection collection = changes.getAdded();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PersistentTransitionChoice persistentTransitionChoice : collection) {
            ChoiceSet choiceSet = persistentTransitionChoice.getChoices();
            if (!choiceSet.getName().equals(this.getTokenName()) || !LANGUAGE_CLASS.equals(choiceSet.getChoiceClass())) continue;
            Formula formula = persistentTransitionChoice.getCount();
            if (formula == null) {
                loadContext.addWriteMessage("Unable to find " + this.getFullName() + " Count");
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (!FormulaFactory.ONE.equals(formula)) {
                stringBuilder.append(formula).append("|");
            }
            stringBuilder.append(choiceSet.getLSTformat());
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void applyChoice(CDOMObject cDOMObject, Language language, PlayerCharacter playerCharacter) {
        playerCharacter.addLanguageKeyed(language.getKeyName());
    }

    public boolean allow(Language language, PlayerCharacter playerCharacter, boolean bl) {
        return !playerCharacter.getLanguagesList().contains(language);
    }

    public Language decodeChoice(String string) {
        return (Language)Globals.getContext().ref.silentlyGetConstructedCDOMObject(LANGUAGE_CLASS, string);
    }

    public String encodeChoice(Object object) {
        return ((Language)object).getKeyName();
    }

    public void restoreChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, Language language) {
    }

    public void removeChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, Language language) {
        playerCharacter.removeLanguage(language);
    }
}

