/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.ArrayList;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.SkillToken;
import pcgen.util.Logging;

public class SkillTypeToken
extends SkillToken {
    public static final String TOKEN_NAME = "SKILLTYPE";

    public String getTokenName() {
        return TOKEN_NAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        SkillToken.SkillDetails skillDetails = this.buildSkillDetails(string);
        if (skillDetails.getProperties().length < 2) {
            return "";
        }
        Skill skill = this.getSkill(string, playerCharacter, skillDetails, exportHandler);
        return this.getSkillProperty(skill, skillDetails.getProperties()[1], playerCharacter);
    }

    private Skill getSkill(String string, PlayerCharacter playerCharacter, SkillToken.SkillDetails skillDetails, ExportHandler exportHandler) {
        int n;
        try {
            n = Integer.parseInt(skillDetails.getSkillId());
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint((String)("Error replacing SKILLTYPE." + string), (Throwable)numberFormatException);
            return null;
        }
        ArrayList<Skill> arrayList = new ArrayList<Skill>();
        for (Skill skill : playerCharacter.getSkillListInOutputOrder()) {
            if (!skill.isType(skillDetails.getProperties()[0])) continue;
            arrayList.add(skill);
        }
        if (n >= arrayList.size() - 1 && exportHandler != null && exportHandler.getExistsOnly()) {
            exportHandler.setNoMoreItems(true);
        }
        Skill skill = null;
        if (n <= arrayList.size() - 1) {
            skill = (Skill)arrayList.get(n);
        }
        return skill;
    }
}

