/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.PCClass;
import pcgen.core.SpecialAbility;
import pcgen.core.prereq.Prerequisite;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SabLst
extends AbstractToken
implements CDOMPrimaryToken<CDOMObject> {
    public String getTokenName() {
        return "SAB";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        return this.parseSpecialAbility(loadContext, cDOMObject, string);
    }

    public boolean parseSpecialAbility(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        if (string2.startsWith("PRE") || string2.startsWith("!PRE")) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Cannot have only PRExxx subtoken in " + this.getTokenName()));
            return false;
        }
        boolean bl = false;
        if (".CLEAR".equals(string2)) {
            loadContext.getObjectContext().removeList(cDOMObject, ListKey.SAB);
            if (!stringTokenizer.hasMoreTokens()) {
                return true;
            }
            string2 = stringTokenizer.nextToken();
            bl = true;
        }
        if (string2.startsWith("PRE") || string2.startsWith("!PRE")) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Cannot use PREREQs when using .CLEAR in " + this.getTokenName()));
            return false;
        }
        if (".CLEAR".equals(string2)) {
            Logging.log((Level)Logging.LST_ERROR, (String)("SA tag confused by redundant '.CLEAR'" + string));
            return false;
        }
        SpecialAbility specialAbility = new SpecialAbility(string2);
        if (!stringTokenizer.hasMoreTokens()) {
            specialAbility.setName(string2);
            loadContext.getObjectContext().addToList(cDOMObject, ListKey.SAB, (Object)specialAbility);
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        String string3 = stringTokenizer.nextToken();
        while (true) {
            if (".CLEAR".equals(string3)) {
                Logging.log((Level)Logging.LST_ERROR, (String)("SA tag confused by '.CLEAR' as a middle token: " + string));
                return false;
            }
            if (string3.startsWith("PRE") || string3.startsWith("!PRE")) break;
            stringBuilder.append("|").append(string3);
            if (!stringTokenizer.hasMoreTokens()) {
                specialAbility.setName(stringBuilder.toString());
                loadContext.getObjectContext().addToList(cDOMObject, ListKey.SAB, (Object)specialAbility);
                return true;
            }
            string3 = stringTokenizer.nextToken();
        }
        specialAbility.setName(stringBuilder.toString());
        if (bl) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Cannot use PREREQs when using .CLEAR and a Special Ability in " + this.getTokenName()));
            return false;
        }
        while (true) {
            Prerequisite prerequisite;
            if ((prerequisite = this.getPrerequisite(string3)) == null) {
                Logging.log((Level)Logging.LST_ERROR, (String)("   (Did you put Abilities after the PRExxx tags in " + this.getTokenName() + ":?)"));
                return false;
            }
            if (cDOMObject instanceof PCClass && "var".equals(prerequisite.getKind())) {
                prerequisite.setSubKey("CLASS:" + cDOMObject.getKeyName());
            }
            specialAbility.addPrerequisite(prerequisite);
            if (!stringTokenizer.hasMoreTokens()) break;
            string3 = stringTokenizer.nextToken();
        }
        loadContext.getObjectContext().addToList(cDOMObject, ListKey.SAB, (Object)specialAbility);
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Changes changes = loadContext.getObjectContext().getListChanges(cDOMObject, ListKey.SAB);
        Collection collection = changes.getAdded();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (changes.includesGlobalClear()) {
            arrayList.add(".CLEAR");
        } else if (collection == null || collection.isEmpty()) {
            return null;
        }
        if (collection != null) {
            for (SpecialAbility specialAbility : collection) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(specialAbility.getLSTformat());
                if (specialAbility.hasPrerequisites()) {
                    stringBuilder.append("|");
                    stringBuilder.append(this.getPrerequisiteString(loadContext, specialAbility.getPrerequisiteList()));
                }
                arrayList.add(stringBuilder.toString());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

