/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.js;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.lobobrowser.js.JavaClassWrapper;
import org.lobobrowser.js.JavaClassWrapperFactory;
import org.lobobrowser.js.JavaObjectWrapper;
import org.lobobrowser.js.ScriptableDelegate;
import org.lobobrowser.util.Objects;
import org.mozilla.javascript.Scriptable;

public class JavaScript {
    private static JavaScript instance = new JavaScript();
    private final WeakHashMap javaObjectToWrapper = new WeakHashMap();

    public static JavaScript getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getJavascriptObject(Object raw, Scriptable scope) {
        if (raw instanceof String || raw instanceof Scriptable) {
            return raw;
        }
        if (raw == null) {
            return null;
        }
        if (raw.getClass().isPrimitive()) {
            return raw;
        }
        if (raw instanceof ScriptableDelegate) {
            JavaScript javaScript = this;
            synchronized (javaScript) {
                Object javascriptObject = ((ScriptableDelegate)raw).getScriptable();
                if (javascriptObject == null) {
                    JavaObjectWrapper jow = new JavaObjectWrapper(JavaClassWrapperFactory.getInstance().getClassWrapper(raw.getClass()), raw);
                    javascriptObject = jow;
                    jow.setParentScope(scope);
                    ((ScriptableDelegate)raw).setScriptable((Scriptable)jow);
                }
                return javascriptObject;
            }
        }
        if (Objects.isBoxClass(raw.getClass())) {
            return raw;
        }
        WeakHashMap weakHashMap = this.javaObjectToWrapper;
        synchronized (weakHashMap) {
            WeakReference valueRef = (WeakReference)this.javaObjectToWrapper.get(raw);
            JavaObjectWrapper jow = null;
            if (valueRef != null) {
                jow = (JavaObjectWrapper)((Object)valueRef.get());
            }
            if (jow == null) {
                Class<?> javaClass = raw.getClass();
                JavaClassWrapper wrapper = JavaClassWrapperFactory.getInstance().getClassWrapper(javaClass);
                jow = new JavaObjectWrapper(wrapper, raw);
                jow.setParentScope(scope);
                this.javaObjectToWrapper.put(raw, new WeakReference<JavaObjectWrapper>(jow));
            }
            return jow;
        }
    }

    public Object getJavaObject(Object javascriptObject, Class type) {
        if (javascriptObject instanceof JavaObjectWrapper) {
            return ((JavaObjectWrapper)((Object)javascriptObject)).getJavaObject();
        }
        if (javascriptObject == null) {
            return null;
        }
        if (type == String.class) {
            if (javascriptObject instanceof String) {
                return javascriptObject;
            }
            if (javascriptObject instanceof Double) {
                String text = String.valueOf(javascriptObject);
                if (text.endsWith(".0")) {
                    return text.substring(0, text.length() - 2);
                }
                return text;
            }
            return String.valueOf(javascriptObject);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            if (javascriptObject instanceof Double) {
                return new Integer(((Double)javascriptObject).intValue());
            }
            if (javascriptObject instanceof Integer) {
                return javascriptObject;
            }
            if (javascriptObject instanceof String) {
                return Integer.valueOf((String)javascriptObject);
            }
            if (javascriptObject instanceof Short) {
                return new Integer(((Short)javascriptObject).shortValue());
            }
            if (javascriptObject instanceof Long) {
                return new Integer(((Long)javascriptObject).intValue());
            }
            if (javascriptObject instanceof Float) {
                return new Integer(((Float)javascriptObject).intValue());
            }
            return javascriptObject;
        }
        return javascriptObject;
    }
}

