/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.style.CSSUtilities;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;

public class StyleSheetAggregator {
    private final HTMLDocumentImpl document;
    private final Map classMapsByElement = new HashMap();
    private final Map idMapsByElement = new HashMap();
    private final Map rulesByElement = new HashMap();

    public StyleSheetAggregator(HTMLDocumentImpl document) {
        this.document = document;
    }

    public final void addStyleSheets(Collection styleSheets) throws MalformedURLException {
        Iterator i = styleSheets.iterator();
        while (i.hasNext()) {
            CSSStyleSheet sheet = (CSSStyleSheet)i.next();
            this.addStyleSheet(sheet);
        }
    }

    private final void addStyleSheet(CSSStyleSheet styleSheet) throws MalformedURLException {
        CSSRuleList ruleList = styleSheet.getCssRules();
        int length = ruleList.getLength();
        HTMLDocumentImpl document = this.document;
        for (int i = 0; i < length; ++i) {
            String styleHref;
            String baseHref;
            String href;
            CSSStyleSheet sheet;
            CSSImportRule importRule;
            CSSRule rule = ruleList.item(i);
            if (rule instanceof CSSStyleRule) {
                CSSStyleRule sr = (CSSStyleRule)rule;
                String selectorText = sr.getSelectorText();
                StringTokenizer commaTok = new StringTokenizer(selectorText, ",");
                while (commaTok.hasMoreTokens()) {
                    String elemtl;
                    String selectorPart = commaTok.nextToken().toLowerCase();
                    ArrayList<String> ancestorSelectors = null;
                    String selector = null;
                    StringTokenizer tok = new StringTokenizer(selectorPart, " \t\r\n");
                    while (tok.hasMoreTokens()) {
                        String token = tok.nextToken();
                        if (tok.hasMoreTokens()) {
                            if (ancestorSelectors == null) {
                                ancestorSelectors = new ArrayList<String>();
                            }
                            ancestorSelectors.add(token);
                            continue;
                        }
                        selector = token;
                        break;
                    }
                    if (selector == null) continue;
                    int dotIdx = selector.indexOf(46);
                    if (dotIdx != -1) {
                        String elemtl2 = selector.substring(0, dotIdx);
                        String classtl = selector.substring(dotIdx + 1);
                        this.addClassRule(elemtl2, classtl, sr, ancestorSelectors);
                        continue;
                    }
                    int poundIdx = selector.indexOf(35);
                    if (poundIdx != -1) {
                        elemtl = selector.substring(0, poundIdx);
                        String idtl = selector.substring(poundIdx + 1);
                        this.addIdRule(elemtl, idtl, sr, ancestorSelectors);
                        continue;
                    }
                    elemtl = selector;
                    this.addElementRule(elemtl, sr, ancestorSelectors);
                }
                continue;
            }
            if (!(rule instanceof CSSImportRule) || !CSSUtilities.matchesMedia((importRule = (CSSImportRule)rule).getMedia(), document.getHtmlRendererContext()) || (sheet = CSSUtilities.parse(href = importRule.getHref(), this.document, baseHref = (styleHref = styleSheet.getHref()) == null ? this.document.getBaseURI() : styleHref, false)) == null) continue;
            this.addStyleSheet(sheet);
        }
    }

    private final void addClassRule(String elemtl, String classtl, CSSStyleRule styleRule, ArrayList ancestorSelectors) {
        LinkedList<StyleRuleInfo> rules;
        HashMap<String, LinkedList<StyleRuleInfo>> classMap = (HashMap<String, LinkedList<StyleRuleInfo>>)this.classMapsByElement.get(elemtl);
        if (classMap == null) {
            classMap = new HashMap<String, LinkedList<StyleRuleInfo>>();
            this.classMapsByElement.put(elemtl, classMap);
        }
        if ((rules = (LinkedList<StyleRuleInfo>)classMap.get(classtl)) == null) {
            rules = new LinkedList<StyleRuleInfo>();
            classMap.put(classtl, rules);
        }
        rules.add(new StyleRuleInfo(ancestorSelectors, styleRule));
    }

    private final void addIdRule(String elemtl, String idtl, CSSStyleRule styleRule, ArrayList ancestorSelectors) {
        LinkedList<StyleRuleInfo> rules;
        HashMap<String, LinkedList<StyleRuleInfo>> idsMap = (HashMap<String, LinkedList<StyleRuleInfo>>)this.idMapsByElement.get(elemtl);
        if (idsMap == null) {
            idsMap = new HashMap<String, LinkedList<StyleRuleInfo>>();
            this.idMapsByElement.put(elemtl, idsMap);
        }
        if ((rules = (LinkedList<StyleRuleInfo>)idsMap.get(idtl)) == null) {
            rules = new LinkedList<StyleRuleInfo>();
            idsMap.put(idtl, rules);
        }
        rules.add(new StyleRuleInfo(ancestorSelectors, styleRule));
    }

    private final void addElementRule(String elemtl, CSSStyleRule styleRule, ArrayList ancestorSelectors) {
        LinkedList<StyleRuleInfo> rules = (LinkedList<StyleRuleInfo>)this.rulesByElement.get(elemtl);
        if (rules == null) {
            rules = new LinkedList<StyleRuleInfo>();
            this.rulesByElement.put(elemtl, rules);
        }
        rules.add(new StyleRuleInfo(ancestorSelectors, styleRule));
    }

    public final Collection getStyleDeclarations(HTMLElementImpl element, String elementName, String elementId, String className) {
        CSSStyleRule styleRule;
        StyleRuleInfo styleRuleInfo;
        Iterator i;
        CSSStyleRule styleRule2;
        StyleRuleInfo styleRuleInfo2;
        Iterator i2;
        LinkedList<CSSStyleDeclaration> styleDeclarations = null;
        String elementTL = elementName.toLowerCase();
        Collection elementRules = (Collection)this.rulesByElement.get(elementTL);
        if (elementRules != null) {
            i2 = elementRules.iterator();
            while (i2.hasNext()) {
                styleRuleInfo2 = (StyleRuleInfo)i2.next();
                if (!styleRuleInfo2.matches(element)) continue;
                styleRule2 = styleRuleInfo2.styleRule;
                if (styleDeclarations == null) {
                    styleDeclarations = new LinkedList<CSSStyleDeclaration>();
                }
                styleDeclarations.add(styleRule2.getStyle());
            }
        }
        if ((elementRules = (Collection)this.rulesByElement.get("*")) != null) {
            i2 = elementRules.iterator();
            while (i2.hasNext()) {
                styleRuleInfo2 = (StyleRuleInfo)i2.next();
                if (!styleRuleInfo2.matches(element)) continue;
                styleRule2 = styleRuleInfo2.styleRule;
                if (styleDeclarations == null) {
                    styleDeclarations = new LinkedList();
                }
                styleDeclarations.add(styleRule2.getStyle());
            }
        }
        if (className != null) {
            Collection classRules;
            String classNameTL = className.toLowerCase();
            Map classMaps = (Map)this.classMapsByElement.get(elementTL);
            if (classMaps != null && (classRules = (Collection)classMaps.get(classNameTL)) != null) {
                i = classRules.iterator();
                while (i.hasNext()) {
                    styleRuleInfo = (StyleRuleInfo)i.next();
                    if (!styleRuleInfo.matches(element)) continue;
                    styleRule = styleRuleInfo.styleRule;
                    if (styleDeclarations == null) {
                        styleDeclarations = new LinkedList();
                    }
                    styleDeclarations.add(styleRule.getStyle());
                }
            }
            if ((classMaps = (Map)this.classMapsByElement.get("*")) != null && (classRules = (Collection)classMaps.get(classNameTL)) != null) {
                i = classRules.iterator();
                while (i.hasNext()) {
                    styleRuleInfo = (StyleRuleInfo)i.next();
                    if (!styleRuleInfo.matches(element)) continue;
                    styleRule = styleRuleInfo.styleRule;
                    if (styleDeclarations == null) {
                        styleDeclarations = new LinkedList();
                    }
                    styleDeclarations.add(styleRule.getStyle());
                }
            }
        }
        if (elementId != null) {
            String elementIdTL;
            Collection idRules;
            Map idMaps = (Map)this.idMapsByElement.get(elementTL);
            if (idMaps != null && (idRules = (Collection)idMaps.get(elementIdTL = elementId.toLowerCase())) != null) {
                i = idRules.iterator();
                while (i.hasNext()) {
                    styleRuleInfo = (StyleRuleInfo)i.next();
                    if (!styleRuleInfo.matches(element)) continue;
                    styleRule = styleRuleInfo.styleRule;
                    if (styleDeclarations == null) {
                        styleDeclarations = new LinkedList();
                    }
                    styleDeclarations.add(styleRule.getStyle());
                }
            }
            if ((idMaps = (Map)this.idMapsByElement.get("*")) != null && (idRules = (Collection)idMaps.get(elementIdTL = elementId.toLowerCase())) != null) {
                i = idRules.iterator();
                while (i.hasNext()) {
                    styleRuleInfo = (StyleRuleInfo)i.next();
                    if (!styleRuleInfo.matches(element)) continue;
                    styleRule = styleRuleInfo.styleRule;
                    if (styleDeclarations == null) {
                        styleDeclarations = new LinkedList();
                    }
                    styleDeclarations.add(styleRule.getStyle());
                }
            }
        }
        return styleDeclarations;
    }

    private static class StyleRuleInfo {
        private final CSSStyleRule styleRule;
        private final ArrayList ancestorSelectors;

        public StyleRuleInfo(ArrayList selectors, CSSStyleRule rule) {
            this.ancestorSelectors = selectors;
            this.styleRule = rule;
        }

        public boolean matches(HTMLElementImpl element) {
            int size;
            ArrayList as = this.ancestorSelectors;
            if (as == null) {
                return true;
            }
            HTMLElementImpl currentElement = element;
            int i = size = as.size();
            while (--i >= 0) {
                String elemtl;
                HTMLElementImpl ancestor;
                String selector = (String)as.get(i);
                int dotIdx = selector.indexOf(46);
                if (dotIdx != -1) {
                    String classtl;
                    String elemtl2 = selector.substring(0, dotIdx);
                    ancestor = currentElement.getAncestorWithClass(elemtl2, classtl = selector.substring(dotIdx + 1));
                    if (ancestor == null) {
                        return false;
                    }
                    currentElement = ancestor;
                    continue;
                }
                int poundIdx = selector.indexOf(35);
                if (poundIdx != -1) {
                    String idtl;
                    elemtl = selector.substring(0, poundIdx);
                    HTMLElementImpl ancestor2 = currentElement.getAncestorWithId(elemtl, idtl = selector.substring(poundIdx + 1));
                    if (ancestor2 == null) {
                        return false;
                    }
                    currentElement = ancestor2;
                    continue;
                }
                elemtl = selector;
                ancestor = currentElement.getAncestor(elemtl);
                if (ancestor == null) {
                    return false;
                }
                currentElement = ancestor;
            }
            return true;
        }
    }
}

