/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLTableCellElementImpl;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.TableMatrix;
import org.lobobrowser.html.renderer.VirtualCell;

class RTableCell
extends RBlock {
    private final HTMLTableCellElementImpl cellElement;
    private VirtualCell topLeftVirtualCell;
    private int cellPadding;
    private int colSpan = -1;
    private int rowSpan = -1;

    public RTableCell(HTMLTableCellElementImpl element, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer tableAsContainer) {
        super(element, 0, pcontext, rcontext, frameContext, tableAsContainer);
        this.cellElement = element;
    }

    public void setCellPadding(int value) {
        this.cellPadding = value;
    }

    protected int getDeclaredHeight(int availHeight) {
        return -1;
    }

    protected int getDeclaredWidth(int availWidth) {
        return -1;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public void setTopLeftVirtualCell(VirtualCell vc) {
        this.topLeftVirtualCell = vc;
    }

    public VirtualCell getTopLeftVirtualCell() {
        return this.topLeftVirtualCell;
    }

    public int getVirtualColumn() {
        VirtualCell vc = this.topLeftVirtualCell;
        return vc == null ? 0 : vc.getColumn();
    }

    public int getVirtualRow() {
        VirtualCell vc = this.topLeftVirtualCell;
        return vc == null ? 0 : vc.getRow();
    }

    public int getColSpan() {
        int cs = this.colSpan;
        if (cs == -1) {
            cs = this.cellElement.getColSpan();
            if (cs < 1) {
                cs = 1;
            }
            this.colSpan = cs;
        }
        return cs;
    }

    public int getRowSpan() {
        int rs = this.rowSpan;
        if (rs == -1) {
            rs = this.cellElement.getRowSpan();
            if (rs < 1) {
                rs = 1;
            }
            this.rowSpan = rs;
        }
        return rs;
    }

    public String getHeightText() {
        return this.cellElement.getHeight();
    }

    public String getWidthText() {
        return this.cellElement.getWidth();
    }

    public void setCellBounds(TableMatrix.SizeInfo[] colSizes, TableMatrix.SizeInfo[] rowSizes, int hasBorder, int cellSpacingX, int cellSpacingY) {
        int height;
        int rowSpan;
        int width;
        int vcol = this.getVirtualColumn();
        int vrow = this.getVirtualRow();
        TableMatrix.SizeInfo colSize = colSizes[vcol];
        TableMatrix.SizeInfo rowSize = rowSizes[vrow];
        int x = colSize.offset;
        int y = rowSize.offset;
        int colSpan = this.getColSpan();
        if (colSpan > 1) {
            width = 0;
            for (int i = 0; i < colSpan; ++i) {
                int vc = vcol + i;
                width += colSizes[vc].actualSize;
                if (i + 1 >= colSpan) continue;
                width += cellSpacingX + hasBorder * 2;
            }
        } else {
            width = colSizes[vcol].actualSize;
        }
        if ((rowSpan = this.getRowSpan()) > 1) {
            height = 0;
            for (int i = 0; i < rowSpan; ++i) {
                int vr = vrow + i;
                height += rowSizes[vr].actualSize;
                if (i + 1 >= rowSpan) continue;
                height += cellSpacingY + hasBorder * 2;
            }
        } else {
            height = rowSizes[vrow].actualSize;
        }
        this.setBounds(x, y, width, height);
    }
}

