/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Insets;
import org.lobobrowser.html.renderer.FloatingBounds;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.util.Objects;

class OffsetFloatingBounds
implements FloatingBounds {
    private final FloatingBounds ancestorFloatingBounds;
    private final RBlockViewport ancestor;
    private final RBlockViewport target;
    private final Insets ancestorPadding;
    private final Insets targetPadding;

    public OffsetFloatingBounds(FloatingBounds ancestorFloatingBounds, RBlockViewport ancestor, Insets ancestorPadding, RBlockViewport target, Insets targetPadding) {
        this.ancestorFloatingBounds = ancestorFloatingBounds;
        this.ancestor = ancestor;
        this.target = target;
        this.ancestorPadding = ancestorPadding;
        this.targetPadding = targetPadding;
    }

    public int getClearY(int y) {
        int ancestorY = this.translateToAncestorY(y);
        int ancestorClearY = this.ancestorFloatingBounds.getClearY(ancestorY);
        return this.translateAncestorY(ancestorClearY);
    }

    public int getLeft(int y) {
        int ancestorY = this.translateToAncestorY(y);
        Insets ap = this.ancestorPadding;
        int aleft = ap == null ? 0 : ap.left;
        int ancestorX = this.ancestorFloatingBounds.getLeft(ancestorY) + aleft;
        Insets tp = this.targetPadding;
        int tleft = tp == null ? 0 : tp.left;
        int localX = this.translateAncestorX(ancestorX) - tleft;
        return localX > 0 ? localX : 0;
    }

    public int getRight(int y) {
        int ancestorY = this.translateToAncestorY(y);
        Insets ancestorPadding = this.ancestorPadding;
        Insets targetPadding = this.targetPadding;
        int aleft = ancestorPadding == null ? 0 : ancestorPadding.left;
        int tleft = targetPadding == null ? 0 : targetPadding.left;
        int ancestorX = aleft + this.ancestor.getAvailContentWidth() - this.ancestorFloatingBounds.getRight(ancestorY);
        int right = tleft + this.target.getAvailContentWidth() - this.translateAncestorX(ancestorX);
        return right > 0 ? right : 0;
    }

    private final int translateToAncestorY(int y) {
        RBlockViewport ancestor = this.ancestor;
        for (RCollection current = this.target; current != null && current != ancestor; current = current.getParent()) {
            y += current.getY();
        }
        return y;
    }

    private final int translateAncestorY(int y) {
        RBlockViewport ancestor = this.ancestor;
        for (RCollection current = this.target; current != null && current != ancestor; current = current.getParent()) {
            y -= current.getY();
        }
        return y;
    }

    private final int translateAncestorX(int x) {
        RBlockViewport ancestor = this.ancestor;
        for (RCollection current = this.target; current != null && current != ancestor; current = current.getParent()) {
            x -= current.getX();
        }
        return x;
    }

    public boolean equals(Object other) {
        if (!(other instanceof OffsetFloatingBounds)) {
            return false;
        }
        OffsetFloatingBounds ofb = (OffsetFloatingBounds)other;
        return ofb.ancestor == this.ancestor && ofb.target == this.target && Objects.equals(ofb.ancestorFloatingBounds, this.ancestorFloatingBounds);
    }
}

