/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLInputElementImpl;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.util.gui.WrapperLayout;

class InputButtonControl
extends BaseInputControl {
    private final JButton widget;

    public InputButtonControl(HTMLBaseInputElement modelNode) {
        super(modelNode);
        JButton widget;
        this.setLayout(WrapperLayout.getInstance());
        this.widget = widget = new JButton();
        this.add(widget);
        widget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                HtmlController.getInstance().onPressed(InputButtonControl.this.controlElement, null, 0, 0);
            }
        });
    }

    public void reset(int availWidth, int availHeight) {
        super.reset(availWidth, availHeight);
        HTMLInputElementImpl element = (HTMLInputElementImpl)this.controlElement;
        String text = element.getAttribute("value");
        if (text == null || text == "") {
            String type = element.getType();
            text = "submit".equalsIgnoreCase(type) ? "Submit Query" : ("reset".equalsIgnoreCase(type) ? "Reset" : "");
        }
        this.widget.setText(text);
    }

    public void click() {
        this.widget.doClick();
    }

    public String getValue() {
        return this.widget.getText();
    }

    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        this.widget.setEnabled(!disabled);
    }

    public void setValue(String value) {
        this.widget.setText(value);
    }

    public void resetInput() {
    }
}

