/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.renderer.RUIControl;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.UIControl;
import org.lobobrowser.html.style.HtmlValues;
import org.w3c.dom.html2.HTMLElement;

class BrowserFrameUIControl
implements UIControl {
    private final Component component;
    private final HTMLElement element;
    private int availWidth;
    private int availHeight;

    public BrowserFrameUIControl(HTMLElement element, BrowserFrame browserFrame) {
        this.component = browserFrame.getComponent();
        this.element = element;
    }

    public int getVAlign() {
        return 5;
    }

    public float getAlignmentY() {
        return 0.0f;
    }

    public Color getBackgroundColor() {
        return this.component.getBackground();
    }

    public Component getComponent() {
        return this.component;
    }

    public void reset(int availWidth, int availHeight) {
        this.availWidth = availWidth;
        this.availHeight = availHeight;
    }

    public Dimension getPreferredSize() {
        int width = HtmlValues.getOldSyntaxPixelSize(this.element.getAttribute("width"), this.availWidth, 100);
        int height = HtmlValues.getOldSyntaxPixelSize(this.element.getAttribute("height"), this.availHeight, 100);
        return new Dimension(width, height);
    }

    public void invalidate() {
        this.component.invalidate();
    }

    public void paint(Graphics g) {
        this.component.paint(g);
    }

    public boolean paintSelection(Graphics g, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        return false;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.component.setBounds(x, y, width, height);
    }

    public void setRUIControl(RUIControl ruicontrol) {
    }
}

