/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.js.Executor;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Document;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.html2.HTMLScriptElement;

public class HTMLScriptElementImpl
extends HTMLElementImpl
implements HTMLScriptElement {
    private static final Logger logger = Logger.getLogger(HTMLScriptElementImpl.class.getName());
    private static final boolean loggableInfo = logger.isLoggable(Level.INFO);
    private String text;
    private boolean defer;

    public HTMLScriptElementImpl() {
        super("SCRIPT", true);
    }

    public HTMLScriptElementImpl(String name) {
        super(name, true);
    }

    public String getText() {
        String t = this.text;
        if (t == null) {
            return this.getRawInnerText(true);
        }
        return t;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getHtmlFor() {
        return this.getAttribute("htmlFor");
    }

    public void setHtmlFor(String htmlFor) {
        this.setAttribute("htmlFor", htmlFor);
    }

    public String getEvent() {
        return this.getAttribute("event");
    }

    public void setEvent(String event) {
        this.setAttribute("event", event);
    }

    public boolean getDefer() {
        return this.defer;
    }

    public void setDefer(boolean defer) {
        this.defer = defer;
    }

    public String getSrc() {
        return this.getAttribute("src");
    }

    public void setSrc(String src) {
        this.setAttribute("src", src);
    }

    public String getType() {
        return this.getAttribute("type");
    }

    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if ("cobra.suspend".equals(key) && data != Boolean.TRUE) {
            this.processScript();
        }
        return super.setUserData(key, data, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processScript() {
        UserAgentContext bcontext = this.getUserAgentContext();
        if (bcontext == null) {
            throw new IllegalStateException("No user agent context.");
        }
        if (bcontext.isScriptingEnabled()) {
            int baseLineNumber;
            String scriptURI;
            String text;
            String src = this.getSrc();
            Document doc = this.document;
            if (!(doc instanceof HTMLDocumentImpl)) {
                throw new IllegalStateException("no valid document");
            }
            boolean liflag = loggableInfo;
            if (src == null) {
                text = this.getText();
                scriptURI = doc.getBaseURI();
                baseLineNumber = 1;
            } else {
                this.informExternalScriptLoading();
                URL scriptURL = ((HTMLDocumentImpl)doc).getFullURL(src);
                scriptURI = scriptURL == null ? src : scriptURL.toExternalForm();
                long time1 = liflag ? System.currentTimeMillis() : 0L;
                try {
                    final HttpRequest request = bcontext.createHttpRequest();
                    SecurityManager sm = System.getSecurityManager();
                    if (sm == null) {
                        request.open("GET", scriptURI, false);
                    } else {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                request.open("GET", scriptURI, false);
                                return null;
                            }
                        });
                    }
                    int status = request.getStatus();
                    if (status != 200 && status != 0) {
                        this.warn("Script at [" + scriptURI + "] failed to load; HTTP status: " + status + ".");
                        return;
                    }
                    text = request.getResponseText();
                }
                finally {
                    if (liflag) {
                        long time2 = System.currentTimeMillis();
                        logger.info("processScript(): Loaded external Javascript from URI=[" + scriptURI + "] in " + (time2 - time1) + " ms.");
                    }
                }
                baseLineNumber = 1;
            }
            Context ctx = Executor.createContext(this.getDocumentURL(), bcontext);
            try {
                Scriptable scope = (Scriptable)doc.getUserData("cobra.js.scope");
                if (scope == null) {
                    throw new IllegalStateException("Scriptable (scope) instance was expected to be keyed as UserData to document using cobra.js.scope");
                }
                try {
                    long time1 = liflag ? System.currentTimeMillis() : 0L;
                    ctx.evaluateString(scope, text, scriptURI, baseLineNumber, null);
                    if (liflag) {
                        long time2 = System.currentTimeMillis();
                        logger.info("addNotify(): Evaluated (or attempted to evaluate) Javascript in " + (time2 - time1) + " ms.");
                    }
                }
                catch (EcmaError ecmaError) {
                    this.warn("Javascript error at " + ecmaError.getSourceName() + ":" + ecmaError.getLineNumber() + ": " + ecmaError.getMessage());
                }
                catch (Throwable err) {
                    this.warn("Unable to evaluate Javascript code", err);
                }
            }
            finally {
                Context.exit();
            }
        }
    }
}

