/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.parser;

import com.steadystate.css.dom.CSSFontFaceRuleImpl;
import com.steadystate.css.dom.CSSImportRuleImpl;
import com.steadystate.css.dom.CSSMediaRuleImpl;
import com.steadystate.css.dom.CSSPageRuleImpl;
import com.steadystate.css.dom.CSSRuleListImpl;
import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import com.steadystate.css.dom.CSSStyleRuleImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.CSSUnknownRuleImpl;
import com.steadystate.css.dom.CSSValueImpl;
import com.steadystate.css.dom.MediaListImpl;
import com.steadystate.css.dom.Property;
import com.steadystate.css.parser.HandlerBase;
import com.steadystate.css.parser.SACParser;
import java.io.IOException;
import java.util.Properties;
import java.util.Stack;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;

public class CSSOMParser {
    private static final String PARSER = "com.steadystate.css.parser.SACParser";
    private Parser _parser = null;
    private CSSStyleSheetImpl _parentStyleSheet = null;

    public CSSOMParser() {
        try {
            this._parser = new SACParser();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public CSSStyleSheet parseStyleSheet(InputSource source) throws IOException {
        CSSOMHandler handler = new CSSOMHandler();
        this._parser.setDocumentHandler(handler);
        this._parser.parseStyleSheet(source);
        return (CSSStyleSheet)handler.getRoot();
    }

    public CSSStyleDeclaration parseStyleDeclaration(InputSource source) throws IOException {
        CSSStyleDeclarationImpl sd = new CSSStyleDeclarationImpl(null);
        this.parseStyleDeclaration(sd, source);
        return sd;
    }

    public void parseStyleDeclaration(CSSStyleDeclaration sd, InputSource source) throws IOException {
        Stack<CSSStyleDeclaration> nodeStack = new Stack<CSSStyleDeclaration>();
        nodeStack.push(sd);
        CSSOMHandler handler = new CSSOMHandler(nodeStack);
        this._parser.setDocumentHandler(handler);
        this._parser.parseStyleDeclaration(source);
    }

    public CSSValue parsePropertyValue(InputSource source) throws IOException {
        CSSOMHandler handler = new CSSOMHandler();
        this._parser.setDocumentHandler(handler);
        return new CSSValueImpl(this._parser.parsePropertyValue(source));
    }

    public CSSRule parseRule(InputSource source) throws IOException {
        CSSOMHandler handler = new CSSOMHandler();
        this._parser.setDocumentHandler(handler);
        this._parser.parseRule(source);
        return (CSSRule)handler.getRoot();
    }

    public SelectorList parseSelectors(InputSource source) throws IOException {
        HandlerBase handler = new HandlerBase();
        this._parser.setDocumentHandler(handler);
        return this._parser.parseSelectors(source);
    }

    public void setParentStyleSheet(CSSStyleSheetImpl parentStyleSheet) {
        this._parentStyleSheet = parentStyleSheet;
    }

    public static void setProperty(String key, String val) {
        Properties props = System.getProperties();
        props.put(key, val);
        System.setProperties(props);
    }

    class CSSOMHandler
    implements DocumentHandler {
        private Stack _nodeStack;
        private Object _root = null;

        public CSSOMHandler(Stack nodeStack) {
            this._nodeStack = nodeStack;
        }

        public CSSOMHandler() {
            this._nodeStack = new Stack();
        }

        public Object getRoot() {
            return this._root;
        }

        public void startDocument(InputSource source) throws CSSException {
            if (this._nodeStack.empty()) {
                CSSStyleSheetImpl ss = new CSSStyleSheetImpl();
                CSSOMParser.this._parentStyleSheet = ss;
                CSSRuleListImpl rules = new CSSRuleListImpl();
                ss.setRuleList(rules);
                this._nodeStack.push(ss);
                this._nodeStack.push(rules);
            }
        }

        public void endDocument(InputSource source) throws CSSException {
            this._nodeStack.pop();
            this._root = this._nodeStack.pop();
        }

        public void comment(String text) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
            CSSUnknownRuleImpl ir = new CSSUnknownRuleImpl(CSSOMParser.this._parentStyleSheet, null, atRule);
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(ir);
            } else {
                this._root = ir;
            }
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
            CSSImportRuleImpl ir = new CSSImportRuleImpl(CSSOMParser.this._parentStyleSheet, null, uri, new MediaListImpl(media));
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(ir);
            } else {
                this._root = ir;
            }
        }

        public void startMedia(SACMediaList media) throws CSSException {
            CSSMediaRuleImpl mr = new CSSMediaRuleImpl(CSSOMParser.this._parentStyleSheet, null, new MediaListImpl(media));
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(mr);
            }
            CSSRuleListImpl rules = new CSSRuleListImpl();
            mr.setRuleList(rules);
            this._nodeStack.push(mr);
            this._nodeStack.push(rules);
        }

        public void endMedia(SACMediaList media) throws CSSException {
            this._nodeStack.pop();
            this._root = this._nodeStack.pop();
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
            CSSPageRuleImpl pr = new CSSPageRuleImpl(CSSOMParser.this._parentStyleSheet, null, name, pseudo_page);
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(pr);
            }
            CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(pr);
            pr.setStyle(decl);
            this._nodeStack.push(pr);
            this._nodeStack.push(decl);
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
            this._nodeStack.pop();
            this._root = this._nodeStack.pop();
        }

        public void startFontFace() throws CSSException {
            CSSFontFaceRuleImpl ffr = new CSSFontFaceRuleImpl(CSSOMParser.this._parentStyleSheet, null);
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(ffr);
            }
            CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(ffr);
            ffr.setStyle(decl);
            this._nodeStack.push(ffr);
            this._nodeStack.push(decl);
        }

        public void endFontFace() throws CSSException {
            this._nodeStack.pop();
            this._root = this._nodeStack.pop();
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            CSSStyleRuleImpl sr = new CSSStyleRuleImpl(CSSOMParser.this._parentStyleSheet, null, selectors);
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(sr);
            }
            CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(sr);
            sr.setStyle(decl);
            this._nodeStack.push(sr);
            this._nodeStack.push(decl);
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            this._nodeStack.pop();
            this._root = this._nodeStack.pop();
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            CSSStyleDeclarationImpl decl = (CSSStyleDeclarationImpl)this._nodeStack.peek();
            CSSValueImpl cssValue = new CSSValueImpl(value);
            decl.addProperty(new Property(name, new CSSValueImpl(value), important));
        }
    }
}

