/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpecialAbility;
import pcgen.core.analysis.SpecialAbilityResolution;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassToken
extends Token {
    public static final String TOKENNAME = "CLASS";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        stringTokenizer.nextToken();
        int n = 0;
        if (stringTokenizer.hasMoreTokens()) {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("LEVEL".equals(string2)) {
                int n2 = ClassToken.getLevelToken(playerCharacter, n);
                if (n2 > 0) {
                    return Integer.toString(n2);
                }
                return "";
            }
            if ("SALIST".equals(string2)) {
                return ClassToken.getSAListToken(playerCharacter, n);
            }
            if ("TYPE".equals(string2)) {
                return ClassToken.getClassType(playerCharacter, n);
            }
        }
        return ClassToken.getClassToken(playerCharacter, n);
    }

    public static String getClassToken(PlayerCharacter playerCharacter, int n) {
        String string = "";
        if (playerCharacter.getClassList().size() > n) {
            PCClass pCClass = (PCClass)playerCharacter.getClassList().get(n);
            string = "None".equals(pCClass.getSubClassKey()) || "".equals(pCClass.getSubClassKey()) ? pCClass.getOutputName() : pCClass.getSubClassKeyed(pCClass.getSubClassKey()).getDisplayName();
        }
        return string;
    }

    public static int getLevelToken(PlayerCharacter playerCharacter, int n) {
        if (playerCharacter.getClassList().size() > n) {
            PCClass pCClass = (PCClass)playerCharacter.getClassList().get(n);
            return pCClass.getLevel();
        }
        return 0;
    }

    public static String getSAListToken(PlayerCharacter playerCharacter, int n) {
        if (playerCharacter.getClassList().size() > n) {
            PCClass pCClass = (PCClass)playerCharacter.getClassList().get(n);
            List<String> list = ClassToken.getClassSpecialAbilityList(pCClass, playerCharacter);
            return StringUtil.join(list, (String)", ");
        }
        return "";
    }

    public static List<String> getClassSpecialAbilityList(PCClass pCClass, PlayerCharacter playerCharacter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        pCClass.addSpecialAbilitiesToList(arrayList2, playerCharacter);
        SpecialAbilityResolution.addSABToList(arrayList2, (PlayerCharacter)playerCharacter, (CDOMObject)pCClass);
        if (arrayList2.isEmpty()) {
            return arrayList;
        }
        Collections.sort(arrayList2);
        for (SpecialAbility specialAbility : arrayList2) {
            String string = specialAbility.getDisplayName();
            if (string == null || string.length() == 0) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            String string2 = stringTokenizer.nextToken();
            int[] nArray = null;
            int n = stringTokenizer.countTokens();
            if (n != 0) {
                nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    String string3 = stringTokenizer.nextToken();
                    nArray[i] = playerCharacter.getVariable(string3).intValue();
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringTokenizer = new StringTokenizer(string2, "%", true);
            n = 0;
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if ("%".equals(string4)) {
                    if (n == 0) {
                        bl = true;
                    }
                    if (nArray != null && n < nArray.length) {
                        int n2;
                        bl &= (n2 = nArray[n++]) == 0;
                        stringBuffer.append(n2);
                        continue;
                    }
                    stringBuffer.append('%');
                    continue;
                }
                stringBuffer.append(string4);
            }
            if (bl) continue;
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    public static String getClassType(PlayerCharacter playerCharacter, int n) {
        if (playerCharacter.getClassList().size() > n) {
            return ((PCClass)playerCharacter.getClassList().get(n)).getType();
        }
        return "";
    }
}

