/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.gear;

import pcgen.core.SizeAdjustment;
import pcgen.core.kit.KitGear;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeToken
extends AbstractToken
implements CDOMSecondaryToken<KitGear> {
    public String getTokenName() {
        return "SIZE";
    }

    public Class<KitGear> getTokenClass() {
        return KitGear.class;
    }

    public String getParentToken() {
        return "*KITTOKEN";
    }

    public boolean parse(LoadContext loadContext, KitGear kitGear, String string) {
        if (this.isEmpty(string)) {
            return false;
        }
        if ("PC".equals(string)) {
            kitGear.setSizeToPC(Boolean.valueOf(true));
        } else {
            SizeAdjustment sizeAdjustment = (SizeAdjustment)loadContext.ref.getAbbreviatedObject(SizeAdjustment.class, string);
            if (sizeAdjustment == null) {
                Logging.errorPrint((String)(this.getTokenName() + " found invalid Size abbreviation: " + string));
                return false;
            }
            kitGear.setSize(sizeAdjustment);
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, KitGear kitGear) {
        SizeAdjustment sizeAdjustment = kitGear.getSize();
        if (sizeAdjustment == null) {
            Boolean bl = kitGear.getSizeToPC();
            if (bl == null) {
                return null;
            }
            return new String[]{"PC"};
        }
        return new String[]{sizeAdjustment.getAbbreviation()};
    }
}

