/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Constants;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.CharacterDomain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.SpellPoint;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellInfo;
import pcgen.core.spell.Spell;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;

public class SpellMemToken
extends Token {
    public static final String TOKENNAME = "SPELLMEM";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        PObject pObject;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        boolean bl = false;
        String string2 = "NAME";
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        String string3 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if ((pObject = playerCharacter.getSpellClassAtIndex(n)) == null && exportHandler != null && exportHandler.getExistsOnly() && n != -1) {
            exportHandler.setNoMoreItems(true);
        }
        String string4 = Globals.getDefaultSpellBook();
        if (n2 > 0) {
            string4 = (String)playerCharacter.getSpellBooks().get(n2);
        }
        if (pObject != null || n == -1) {
            if (n == -1) {
                string4 = Globals.getDefaultSpellBook();
            }
            CharacterSpell characterSpell = null;
            if (!"".equals(string4)) {
                Object object;
                List<CharacterSpell> list;
                Spell spell = null;
                if (n == -1) {
                    list = new ArrayList();
                    for (PCClass pCClass : playerCharacter.getClassList()) {
                        object = playerCharacter.getCharacterSpells((PObject)pCClass, null, string4, n3);
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            CharacterSpell characterSpell2 = (CharacterSpell)iterator.next();
                            if (list.contains(characterSpell2)) continue;
                            list.add(characterSpell2);
                        }
                    }
                    Collections.sort(list);
                    if (n4 < list.size()) {
                        characterSpell = (CharacterSpell)list.get(n4);
                        spell = characterSpell.getSpell();
                        bl = true;
                    }
                } else if (pObject != null) {
                    list = playerCharacter.getCharacterSpells(pObject, null, string4, n3);
                    if (n4 < list.size()) {
                        characterSpell = (CharacterSpell)list.get(n4);
                        spell = characterSpell.getSpell();
                        bl = true;
                    }
                } else if (exportHandler != null && exportHandler.getInLabel() && exportHandler.getCheckBefore()) {
                    exportHandler.setCanWrite(false);
                }
                if (characterSpell == null) {
                    if (exportHandler != null && exportHandler.getExistsOnly()) {
                        exportHandler.setNoMoreItems(true);
                    }
                    return stringBuffer.toString();
                }
                list = characterSpell.getSpellInfoFor(string4, n3, -1);
                if (bl && spell != null && list != null) {
                    Object object2;
                    if ("NAME".equals(string2)) {
                        stringBuffer.append(spell.getOutputName() + list.toString());
                    } else if ("OUTPUTNAME".equals(string2)) {
                        stringBuffer.append(spell.getOutputName() + list.toString());
                    } else if ("PPCOST".equals(string2)) {
                        if (list.getActualPPCost() != -1) {
                            stringBuffer.append(list.getActualPPCost());
                        }
                    } else if ("TIMES".equals(string2)) {
                        if (list.getTimes() == SpellInfo.TIMES_AT_WILL) {
                            stringBuffer.append("At Will");
                        } else {
                            stringBuffer.append(String.valueOf(list.getTimes()));
                        }
                    } else if ("TIMEUNIT".equals(string2)) {
                        stringBuffer.append(String.valueOf(list.getTimeUnit()));
                    } else if ("RANGE".equals(string2)) {
                        stringBuffer.append(playerCharacter.getSpellRange(characterSpell, characterSpell.getOwner(), list));
                    } else if ("BASEPPCOST".equals(string2)) {
                        stringBuffer.append(spell.getSafe(IntegerKey.PP_COST));
                    } else if ("CASTERLEVEL".equals(string2)) {
                        stringBuffer.append(playerCharacter.getCasterLevelForSpell(characterSpell, characterSpell.getOwner().getKeyName()));
                    } else if ("CASTINGTIME".equals(string2)) {
                        stringBuffer.append(spell.getCastingTime());
                    } else if ("COMPONENTS".equals(string2)) {
                        stringBuffer.append(spell.getComponentList());
                    } else if ("COST".equals(string2)) {
                        stringBuffer.append(((BigDecimal)spell.getSafe(ObjectKey.COST)).toString());
                    } else if ("DC".equals(string2)) {
                        object2 = spell.getSaveInfo();
                        if (!("".equals(object2) || "None".equals(object2) || "No".equals(object2))) {
                            int n5 = playerCharacter.getDC(spell, list);
                            stringBuffer.append(String.valueOf(n5));
                        }
                    } else if ("DURATION".equals(string2)) {
                        object2 = playerCharacter.parseSpellString(characterSpell, spell.getDuration(), characterSpell.getOwner());
                        stringBuffer.append((String)object2);
                    } else if ("DESC".equals(string2) || "EFFECT".equals(string2)) {
                        object2 = playerCharacter.parseSpellString(characterSpell, playerCharacter.getDescription((PObject)spell), characterSpell.getOwner());
                        stringBuffer.append((String)object2);
                    } else if ("TARGET".equals(string2) || "EFFECTYPE".equals(string2)) {
                        object2 = playerCharacter.parseSpellString(characterSpell, spell.getSafe(StringKey.TARGET_AREA), characterSpell.getOwner());
                        stringBuffer.append((String)object2);
                    } else if ("SAVEINFO".equals(string2)) {
                        stringBuffer.append(spell.getSaveInfo());
                    } else if ("SCHOOL".equals(string2)) {
                        stringBuffer.append(spell.getSchool());
                    } else if ("SOURCELEVEL".equals(string2)) {
                        stringBuffer.append(SpellMemToken.replaceTokenSpellMemSourceLevel(spell, playerCharacter));
                    } else if ("SOURCE".equals(string2)) {
                        stringBuffer.append(spell.getDefaultSourceString());
                    } else if ("SOURCESHORT".equals(string2)) {
                        stringBuffer.append(SourceFormat.formatShort((CDOMObject)spell, (int)8));
                    } else if ("SOURCEPAGE".equals(string2)) {
                        stringBuffer.append(spell.get(StringKey.SOURCE_PAGE));
                    } else if ("SUBSCHOOL".equals(string2)) {
                        stringBuffer.append(spell.getSubschool());
                    } else if ("DESCRIPTOR".equals(string2)) {
                        stringBuffer.append(spell.descriptor());
                    } else if ("FULLSCHOOL".equals(string2)) {
                        object2 = spell.getSchool();
                        if (spell.getSubschool().length() > 0 && !"NONE".equalsIgnoreCase(spell.getSubschool().trim())) {
                            object2 = (String)object2 + " (" + spell.getSubschool() + ')';
                        }
                        if (spell.descriptor().length() > 0) {
                            object2 = (String)object2 + " [" + spell.descriptor() + ']';
                        }
                        stringBuffer.append((String)object2);
                    } else if ("SR".equals(string2)) {
                        stringBuffer.append(spell.getSpellResistance());
                    } else if ("SRSHORT".equals(string2)) {
                        if ("No".equals(spell.getSpellResistance())) {
                            stringBuffer.append("N");
                        } else {
                            stringBuffer.append("Y");
                        }
                    } else if ("CLASS".equals(string2)) {
                        stringBuffer.append(pObject.getOutputName());
                    } else if ("DCSTAT".equals(string2)) {
                        if (pObject instanceof PCClass) {
                            object2 = (PCClass)pObject;
                            stringBuffer.append(object2.getSpellBaseStat());
                        }
                    } else if ("TYPE".equals(string2)) {
                        object2 = null;
                        if (pObject instanceof PCClass) {
                            object2 = (PCClass)pObject;
                        }
                        if (object2 != null) {
                            stringBuffer.append(object2.getSpellType());
                        }
                    } else if (string2.startsWith("DESCRIPTION")) {
                        object2 = SpellMemToken.getItemDescription("SPELL", spell.getKeyName(), playerCharacter.getDescription((PObject)spell), playerCharacter);
                        if (string3.length() > 0) {
                            stringBuffer.append(((String)object2).replaceAll("\r?\n", string3));
                        } else {
                            stringBuffer.append((String)object2);
                        }
                    } else if (string2.startsWith("BONUSSPELL")) {
                        object2 = "*";
                        if (string2.length() > 10) {
                            object2 = string2.substring(10);
                        }
                        stringBuffer.append(this.getBonusSpellValue(playerCharacter, n3, (String)object2, string3, pObject, string4, characterSpell, spell));
                    } else if ("XPCOST".equals(string2)) {
                        stringBuffer.append(spell.getSafe(IntegerKey.XP_COST));
                    } else if ("CT".equals(string2)) {
                        stringBuffer.append(spell.getSafe(IntegerKey.CASTING_THRESHOLD));
                    } else if ("SPELLPOINTCOST".equals(string2)) {
                        if ("NUMELEMENTS".equals(string3)) {
                            stringBuffer.append(SpellPoint.getSpellPointCostActualParts((Spell)spell).size());
                        } else if ("TOTAL".equals(string3)) {
                            stringBuffer.append(SpellPoint.getSpellPointCostActual((Spell)spell));
                        } else if ("".equals(string3)) {
                            stringBuffer.append(SpellPoint.getSPCostStrings((PlayerCharacter)playerCharacter, (Spell)spell));
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            object2 = stringTokenizer.nextToken();
                            try {
                                int n6 = Integer.parseInt((String)object2);
                                if (stringTokenizer.hasMoreTokens()) {
                                    object = stringTokenizer.nextToken();
                                    if ("NAME".equals(object)) {
                                        stringBuffer.append(SpellPoint.getSpellPointCostPartName((Spell)spell, (int)n6));
                                    } else if ("VALUE".equals(object)) {
                                        stringBuffer.append(SpellPoint.getSpellPointCostPartValue((Spell)spell, (int)n6));
                                    }
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    }
                } else if (exportHandler != null && exportHandler.getExistsOnly()) {
                    exportHandler.setNoMoreItems(true);
                }
            } else if (exportHandler != null && exportHandler.getExistsOnly()) {
                exportHandler.setNoMoreItems(true);
            }
        }
        return stringBuffer.toString();
    }

    private String getBonusSpellValue(PlayerCharacter playerCharacter, int n, String string, String string2, PObject pObject, String string3, CharacterSpell characterSpell, Spell spell) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        if (pObject != null && characterSpell != null && characterSpell.isSpecialtySpell() && pObject instanceof PCClass) {
            for (CharacterDomain characterDomain : playerCharacter.getCharacterDomainList()) {
                if (characterDomain == null || characterDomain.getDomain() == null || !characterDomain.isFromPCClass(pObject.getKeyName())) continue;
                arrayList.add(characterDomain.getDomain().getKeyName());
            }
            List list = playerCharacter.getCharacterSpells(pObject, spell, string3, n);
            boolean bl = true;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CharacterSpell characterSpell2 = (CharacterSpell)iterator.next();
                if (characterSpell2.isSpecialtySpell()) continue;
                bl = false;
                break;
            }
            if (bl) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(string + string);
            }
        } else {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static String replaceTokenSpellMemSourceLevel(Spell spell, PlayerCharacter playerCharacter) {
        HashMapToList hashMapToList = playerCharacter.getLevelInfo(spell);
        StringBuffer stringBuffer = new StringBuffer();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (CDOMList object : hashMapToList.getKeySet()) {
            String string = object.getKeyName();
            for (Integer n : hashMapToList.getListFor((Object)object)) {
                PCClass pCClass = (PCClass)Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCClass.class, string);
                if (pCClass != null) {
                    string = pCClass.getAbbrev();
                }
                treeSet.add(string + n.toString());
            }
        }
        for (String string : treeSet) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String getItemDescription(String string, String string2, String string3, PlayerCharacter playerCharacter) {
        if (SettingsHandler.isROG()) {
            if ("EMPTY".equals(playerCharacter.getDescriptionLst())) {
                playerCharacter.loadDescriptionFilesInDirectory("descriptions");
            }
            String string4 = string3;
            String string5 = string.toUpperCase() + ":" + string2 + Constants.s_LINE_SEP;
            int n = playerCharacter.getDescriptionLst().indexOf(string5);
            if (n >= 0) {
                string4 = playerCharacter.getDescriptionLst().substring(n + string5.length());
                string4 = string4.substring(0, string4.indexOf("####") - 1).trim();
            }
            return string4;
        }
        return string3;
    }
}

