/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.spell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.helper.PointCost;
import pcgen.core.spell.Spell;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellPointCostToken
extends AbstractToken
implements CDOMPrimaryToken<Spell> {
    public String getTokenName() {
        return "SPELLPOINTCOST";
    }

    public boolean parse(LoadContext loadContext, Spell spell, String string) {
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (".CLEAR".equals(string2)) {
                if (!bl) {
                    Logging.errorPrint((String)("Non-sensical use of .CLEAR in " + this.getTokenName() + ": " + string));
                    return false;
                }
                loadContext.getObjectContext().removeList((CDOMObject)spell, ListKey.SPELL_POINT_COST);
            } else {
                int n;
                String string3;
                String string4;
                int n2 = string2.indexOf("=");
                if (n2 == -1) {
                    bl2 = true;
                    string4 = "TOTAL";
                    string3 = string2;
                } else {
                    bl3 = true;
                    if (string2.lastIndexOf("=") != n2) {
                        Logging.errorPrint((String)("Invalid number of Arguments in " + this.getTokenName() + "(" + spell.getDisplayName() + "): " + string));
                        return false;
                    }
                    string4 = string2.substring(0, n2);
                    string3 = string2.substring(n2 + 1);
                }
                try {
                    n = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.errorPrint((String)("Invalid Value in " + this.getTokenName() + "(" + spell.getDisplayName() + "): " + string + ".  Value must be an integer."));
                    return false;
                }
                loadContext.getObjectContext().addToList((CDOMObject)spell, ListKey.SPELL_POINT_COST, (Object)new PointCost(string4, n));
            }
            bl = false;
        }
        if (!bl2 || bl3) {
            // empty if block
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, Spell spell) {
        Changes changes = loadContext.getObjectContext().getListChanges((CDOMObject)spell, ListKey.SPELL_POINT_COST);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        Collection collection = changes.getAdded();
        if (collection != null) {
            for (PointCost pointCost : collection) {
                StringBuilder stringBuilder = new StringBuilder();
                String string = pointCost.getType();
                if (!"TOTAL".equals(string)) {
                    stringBuilder.append(string).append("=");
                }
                stringBuilder.append(pointCost.getCost());
                treeSet.add(stringBuilder.toString());
            }
        }
        ArrayList arrayList = new ArrayList();
        if (changes.includesGlobalClear()) {
            arrayList.add(".CLEAR");
        }
        arrayList.addAll(treeSet);
        return new String[]{StringUtil.join((Collection)arrayList, (String)"|")};
    }

    public Class<Spell> getTokenClass() {
        return Spell.class;
    }
}

