/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.add;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.choiceset.QualifiedDecorator;
import pcgen.cdom.choiceset.ReferenceChoiceSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquipToken
extends AbstractToken
implements CDOMSecondaryToken<CDOMObject>,
PersistentChoiceActor<Equipment> {
    private static final Class<Equipment> EQUIPMENT_CLASS = Equipment.class;

    public String getParentToken() {
        return "ADD";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    public String getTokenName() {
        return "EQUIP";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        CDOMReference cDOMReference;
        String string2;
        Object object;
        String string3;
        Formula formula;
        if (string.length() == 0) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getFullName() + " may not have empty argument"));
            return false;
        }
        int n = string.indexOf("|");
        if (n == -1) {
            formula = FormulaFactory.ONE;
            string3 = string;
        } else {
            object = string.substring(0, n);
            formula = FormulaFactory.getFormulaFor((String)object);
            if (formula.isStatic() && formula.resolve(null, "").doubleValue() <= 0.0) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Count in " + this.getFullName() + " must be > 0"));
                return false;
            }
            string3 = string.substring(n + 1);
        }
        if (this.isEmpty(string3) || this.hasIllegalSeparator(',', string3)) {
            return false;
        }
        object = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            cDOMReference = TokenUtilities.getTypeOrPrimitive((LoadContext)loadContext, EQUIPMENT_CLASS, (String)string2);
            if (cDOMReference == null) {
                Logging.log((Level)Logging.LST_ERROR, (String)("  Error was encountered while parsing " + this.getFullName() + ": " + string + " had an invalid reference: " + string2));
                return false;
            }
            object.add(cDOMReference);
        }
        string2 = new ReferenceChoiceSet((Collection)object);
        cDOMReference = new ChoiceSet(this.getTokenName(), (PrimitiveChoiceSet)new QualifiedDecorator((PrimitiveChoiceSet)string2));
        PersistentTransitionChoice persistentTransitionChoice = new PersistentTransitionChoice((ChoiceSet)cDOMReference, formula);
        loadContext.getObjectContext().addToList(cDOMObject, ListKey.ADD, (Object)persistentTransitionChoice);
        persistentTransitionChoice.setTitle("Equipment Choice");
        persistentTransitionChoice.setChoiceActor((ChoiceActor)this);
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Changes changes = loadContext.getObjectContext().getListChanges(cDOMObject, ListKey.ADD);
        Collection collection = changes.getAdded();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PersistentTransitionChoice persistentTransitionChoice : collection) {
            ChoiceSet choiceSet = persistentTransitionChoice.getChoices();
            if (!EQUIPMENT_CLASS.equals(choiceSet.getChoiceClass())) continue;
            Formula formula = persistentTransitionChoice.getCount();
            if (formula == null) {
                loadContext.addWriteMessage("Unable to find " + this.getFullName() + " Count");
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (!FormulaFactory.ONE.equals(formula)) {
                stringBuilder.append(formula).append("|");
            }
            stringBuilder.append(choiceSet.getLSTformat());
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void applyChoice(CDOMObject cDOMObject, Equipment equipment, PlayerCharacter playerCharacter) {
        Equipment equipment2 = equipment.clone();
        equipment2.setQty(1.0);
        playerCharacter.addEquipment(equipment2);
    }

    public boolean allow(Equipment equipment, PlayerCharacter playerCharacter, boolean bl) {
        return true;
    }

    public Equipment decodeChoice(String string) {
        return (Equipment)Globals.getContext().ref.silentlyGetConstructedCDOMObject(EQUIPMENT_CLASS, string);
    }

    public String encodeChoice(Object object) {
        return ((Equipment)object).getKeyName();
    }

    public void restoreChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, Equipment equipment) {
    }

    public void removeChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, Equipment equipment) {
        playerCharacter.removeEquipment(equipment);
    }
}

