/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.add;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.choiceset.AbilityRefChoiceSet;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.AbilityRef;
import pcgen.cdom.helper.AbilitySelection;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.PlayerCharacter;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFeatToken
extends AbstractToken
implements CDOMSecondaryToken<CDOMObject>,
PersistentChoiceActor<AbilitySelection> {
    private static final Class<AbilitySelection> ABILITY_SELECTION_CLASS = AbilitySelection.class;
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    public String getParentToken() {
        return "ADD";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    public String getTokenName() {
        return "VFEAT";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) throws PersistenceLayerException {
        PersistentTransitionChoice persistentTransitionChoice;
        AbilityRefChoiceSet abilityRefChoiceSet;
        String string2;
        Object object;
        String string3;
        Formula formula;
        if (string.length() == 0) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getFullName() + " may not have empty argument"));
            return false;
        }
        AbilityCategory abilityCategory = AbilityCategory.FEAT;
        Ability.Nature nature = Ability.Nature.VIRTUAL;
        int n = string.indexOf("|");
        if (n == -1) {
            formula = FormulaFactory.ONE;
            string3 = string;
        } else {
            object = string.substring(0, n);
            formula = FormulaFactory.getFormulaFor((String)object);
            if (formula.isStatic() && formula.resolve(null, "").doubleValue() <= 0.0) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Count in " + this.getFullName() + " must be > 0"));
                return false;
            }
            string3 = string.substring(n + 1);
        }
        if (this.isEmpty(string3) || this.hasIllegalSeparator(',', string3)) {
            return false;
        }
        object = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if ("STACKS".equals(string2)) {
                if (bl) {
                    Logging.log((Level)Logging.LST_ERROR, (String)(this.getFullName() + " found second stacking specification in value: " + string));
                    return false;
                }
                bl = true;
                continue;
            }
            if (string2.startsWith("STACKS=")) {
                if (bl) {
                    Logging.log((Level)Logging.LST_ERROR, (String)(this.getFullName() + " found second stacking specification in value: " + string));
                    return false;
                }
                bl = true;
                try {
                    n2 = Integer.parseInt(string2.substring(7));
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.log((Level)Logging.LST_ERROR, (String)("Invalid Stack number in " + this.getFullName() + ": " + string));
                    return false;
                }
                if (n2 > 0) continue;
                Logging.log((Level)Logging.LST_ERROR, (String)("Invalid (less than 1) Stack number in " + this.getFullName() + ": " + string));
                return false;
            }
            if ("ALL".equals(string2)) {
                bl2 = true;
                abilityRefChoiceSet = loadContext.ref.getCDOMAllReference(ABILITY_CLASS, (Category)abilityCategory);
            } else {
                bl3 = true;
                abilityRefChoiceSet = TokenUtilities.getTypeOrPrimitive((LoadContext)loadContext, ABILITY_CLASS, (Category)abilityCategory, (String)string2);
            }
            if (abilityRefChoiceSet == null) {
                Logging.log((Level)Logging.LST_ERROR, (String)("  Error was encountered while parsing " + this.getTokenName() + ": " + string + " had an invalid reference: " + string2));
                return false;
            }
            persistentTransitionChoice = new AbilityRef((CDOMReference)abilityRefChoiceSet);
            object.add(persistentTransitionChoice);
            if (string2.indexOf(40) == -1) continue;
            ArrayList arrayList = new ArrayList();
            AbilityUtilities.getUndecoratedName((String)string2, arrayList);
            if (arrayList.size() != 1) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Invalid use of multiple items in parenthesis (comma prohibited) in " + this.getFullName() + ": " + string2));
                return false;
            }
            persistentTransitionChoice.setChoice((String)arrayList.get(0));
        }
        if (bl2 && bl3) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + string));
            return false;
        }
        if (object.isEmpty()) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Non-sensical " + this.getFullName() + ": Contains no ability reference: " + string));
            return false;
        }
        abilityRefChoiceSet = new AbilityRefChoiceSet((Category)abilityCategory, (Collection)object, nature);
        string2 = new ChoiceSet(this.getTokenName(), (PrimitiveChoiceSet)abilityRefChoiceSet);
        persistentTransitionChoice = new PersistentTransitionChoice((ChoiceSet)string2, formula);
        loadContext.getObjectContext().addToList(cDOMObject, ListKey.ADD, (Object)persistentTransitionChoice);
        persistentTransitionChoice.setTitle("Virtual Feat Selection");
        persistentTransitionChoice.allowStack(bl);
        if (n2 != 0) {
            persistentTransitionChoice.setStackLimit(n2);
        }
        persistentTransitionChoice.setChoiceActor((ChoiceActor)this);
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Changes changes = loadContext.getObjectContext().getListChanges(cDOMObject, ListKey.ADD);
        Collection collection = changes.getAdded();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PersistentTransitionChoice persistentTransitionChoice : collection) {
            ChoiceSet choiceSet = persistentTransitionChoice.getChoices();
            if (!this.getTokenName().equals(choiceSet.getName()) || !ABILITY_SELECTION_CLASS.equals(choiceSet.getChoiceClass())) continue;
            Formula formula = persistentTransitionChoice.getCount();
            if (formula == null) {
                loadContext.addWriteMessage("Unable to find " + this.getFullName() + " Count");
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (!FormulaFactory.ONE.equals(formula)) {
                stringBuilder.append(formula).append("|");
            }
            if (persistentTransitionChoice.allowsStacking()) {
                stringBuilder.append("STACKS");
                int n = persistentTransitionChoice.getStackLimit();
                if (n != 0) {
                    stringBuilder.append("=");
                    stringBuilder.append(persistentTransitionChoice.getStackLimit());
                }
                stringBuilder.append(",");
            }
            stringBuilder.append(choiceSet.getLSTformat());
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void applyChoice(CDOMObject cDOMObject, AbilitySelection abilitySelection, PlayerCharacter playerCharacter) {
        String string = abilitySelection.getFullAbilityKey();
        Ability ability = AbilityUtilities.addVirtualAbility((String)"FEAT", (String)string, (List)playerCharacter.getDirectVirtualAbilities(AbilityCategory.FEAT), (PlayerCharacter)playerCharacter, null);
        playerCharacter.addAssoc((Object)cDOMObject, AssociationListKey.ADDED_FEAT, (Object)ability);
        playerCharacter.setDirty(true);
        if (ability != null) {
            ability.setNeedsSaving(true);
        } else {
            Logging.errorPrint((String)("Error:" + string + " not added, aPC.getFeatNamedInList() == NULL"));
        }
    }

    public boolean allow(AbilitySelection abilitySelection, PlayerCharacter playerCharacter, boolean bl) {
        for (Ability ability : playerCharacter.getAllAbilities()) {
            Boolean bl2;
            if (!AbilityCategory.FEAT.equals((Object)ability.getCDOMCategory().getParentCategory()) || !ability.getKeyName().equals(abilitySelection.getAbilityKey()) || (bl2 = (Boolean)ability.getSafe(ObjectKey.MULTIPLE_ALLOWED)).booleanValue() && (this.allowStack(ability, bl) || !this.hasAssoc(playerCharacter.getAssociationList((CDOMObject)ability), abilitySelection))) continue;
            return false;
        }
        return true;
    }

    private boolean hasAssoc(List<String> list, AbilitySelection abilitySelection) {
        if (list == null) {
            return false;
        }
        for (String string : list) {
            if (!abilitySelection.containsAssociation(string)) continue;
            return true;
        }
        return false;
    }

    private boolean allowStack(Ability ability, boolean bl) {
        return (Boolean)ability.getSafe(ObjectKey.STACKS) != false && bl;
    }

    public AbilitySelection decodeChoice(String string) {
        return AbilitySelection.getAbilitySelectionFromPersistentFormat((String)string);
    }

    public String encodeChoice(Object object) {
        return ((AbilitySelection)object).getPersistentFormat();
    }

    public void restoreChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, AbilitySelection abilitySelection) {
    }

    public void removeChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, AbilitySelection abilitySelection) {
    }
}

