/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipmentmodifier;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.EquipmentModifier;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChargesToken
extends AbstractToken
implements CDOMPrimaryToken<EquipmentModifier> {
    public String getTokenName() {
        return "CHARGES";
    }

    public boolean parse(LoadContext loadContext, EquipmentModifier equipmentModifier, String string) {
        int n;
        int n2;
        if (this.isEmpty(string)) {
            return false;
        }
        int n3 = string.indexOf("|");
        if (n3 == -1) {
            Logging.errorPrint((String)(this.getTokenName() + " has no | : must be of format <min charges>|<max charges>: " + string));
            return false;
        }
        if (string.lastIndexOf("|") != n3) {
            Logging.errorPrint((String)(this.getTokenName() + " has two | : must be of format <min charges>|<max charges>: " + string));
            return false;
        }
        String string2 = string.substring(0, n3);
        try {
            n2 = Integer.parseInt(string2);
            if (n2 < 0) {
                Logging.errorPrint((String)(this.getTokenName() + " min charges must be >= zero: " + string));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint((String)(this.getTokenName() + " min charges is not an integer: " + string));
            return false;
        }
        String string3 = string.substring(n3 + 1);
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint((String)(this.getTokenName() + " max charges is not an integer: " + string));
            return false;
        }
        if (n2 > n) {
            Logging.errorPrint((String)(this.getTokenName() + " max charges must be >= min charges: " + string));
            return false;
        }
        loadContext.getObjectContext().put((CDOMObject)equipmentModifier, IntegerKey.MIN_CHARGES, Integer.valueOf(n2));
        loadContext.getObjectContext().put((CDOMObject)equipmentModifier, IntegerKey.MAX_CHARGES, Integer.valueOf(n));
        return true;
    }

    public String[] unparse(LoadContext loadContext, EquipmentModifier equipmentModifier) {
        Integer n = loadContext.getObjectContext().getInteger((CDOMObject)equipmentModifier, IntegerKey.MAX_CHARGES);
        Integer n2 = loadContext.getObjectContext().getInteger((CDOMObject)equipmentModifier, IntegerKey.MIN_CHARGES);
        if (n == null && n2 == null) {
            return null;
        }
        if (n == null || n2 == null) {
            loadContext.addWriteMessage("EquipmentModifier requires both MAX_CHARGES and MIN_CHARGES for " + this.getTokenName() + " if one of the two is present");
            return null;
        }
        int n3 = n2;
        if (n3 < 0) {
            loadContext.addWriteMessage("EquipmentModifier requires MIN_CHARGES be > 0");
            return null;
        }
        if (n < n3) {
            loadContext.addWriteMessage("EquipmentModifier requires MAX_CHARGES be greater than MIN_CHARGES for " + this.getTokenName());
            return null;
        }
        return new String[]{n2 + "|" + n};
    }

    public Class<EquipmentModifier> getTokenClass() {
        return EquipmentModifier.class;
    }
}

