/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Campaign;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.InstallLstToken;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourcedateLst
extends AbstractToken
implements CDOMPrimaryToken<CDOMObject>,
InstallLstToken {
    public String getTokenName() {
        return "SOURCEDATE";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) throws PersistenceLayerException {
        if (this.isEmpty(string)) {
            return false;
        }
        Date date = this.getDate(string);
        if (date == null) {
            return false;
        }
        loadContext.getObjectContext().put(cDOMObject, ObjectKey.SOURCE_DATE, (Object)date);
        return true;
    }

    private Date getDate(String string) {
        Date date;
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        try {
            date = dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            dateFormat = DateFormat.getDateInstance();
            try {
                date = dateFormat.parse(string);
            }
            catch (ParseException parseException2) {
                Logging.log((Level)Logging.LST_ERROR, (String)"Error parsing date", (Throwable)parseException2);
                return null;
            }
        }
        return date;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Date date = (Date)loadContext.getObjectContext().getObject(cDOMObject, ObjectKey.SOURCE_DATE);
        if (date == null) {
            return null;
        }
        return new String[]{date.toString()};
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public boolean parse(Campaign campaign, String string, URI uRI) {
        Date date = this.getDate(string);
        if (date == null) {
            return false;
        }
        campaign.put(ObjectKey.SOURCE_DATE, (Object)date);
        return true;
    }
}

