/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.race;

import java.math.BigDecimal;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Race;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.BigDecimalHelper;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaceToken
extends AbstractToken
implements CDOMPrimaryToken<Race> {
    public String getTokenName() {
        return "FACE";
    }

    public boolean parse(LoadContext loadContext, Race race, String string) {
        if (this.isEmpty(string)) {
            return false;
        }
        return this.parseFace(loadContext, race, string);
    }

    protected boolean parseFace(LoadContext loadContext, Race race, String string) {
        int n = string.indexOf(",");
        if (n != string.lastIndexOf(",")) {
            Logging.errorPrint((String)(this.getTokenName() + " must be of the form: " + this.getTokenName() + ":<num>[,<num>]"));
            return false;
        }
        if (n > -1) {
            BigDecimal bigDecimal;
            String string2;
            if (n == 0) {
                Logging.errorPrint((String)(this.getTokenName() + " should not start with a comma.  Must be of the form: " + this.getTokenName() + ":<num>[,<num>]"));
                return false;
            }
            if (n == string.length() - 1) {
                Logging.errorPrint((String)(this.getTokenName() + " should not end with a comma.  Must be of the form: " + this.getTokenName() + ":<num>[,<num>]"));
                return false;
            }
            try {
                string2 = string.substring(0, n).trim();
                bigDecimal = new BigDecimal(string2);
                if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                    Logging.errorPrint((String)("Cannot have negative width in " + this.getTokenName() + ": " + string));
                    return false;
                }
                loadContext.getObjectContext().put((CDOMObject)race, ObjectKey.FACE_WIDTH, (Object)bigDecimal);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint((String)("Misunderstood Double Width in Tag: " + string));
                return false;
            }
            try {
                string2 = string.substring(n + 1).trim();
                bigDecimal = new BigDecimal(string2);
                if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                    Logging.errorPrint((String)("Cannot have negative height in " + this.getTokenName() + ": " + string));
                    return false;
                }
                loadContext.getObjectContext().put((CDOMObject)race, ObjectKey.FACE_HEIGHT, (Object)bigDecimal);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint((String)("Misunderstood Double Height in Tag: " + string));
                return false;
            }
        }
        try {
            String string3 = string;
            BigDecimal bigDecimal = new BigDecimal(string3);
            if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                Logging.errorPrint((String)("Cannot have negative width in " + this.getTokenName() + ": " + string));
                return false;
            }
            loadContext.getObjectContext().put((CDOMObject)race, ObjectKey.FACE_WIDTH, (Object)bigDecimal);
            loadContext.getObjectContext().put((CDOMObject)race, ObjectKey.FACE_HEIGHT, (Object)BigDecimal.ZERO);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint((String)("Misunderstood Double in Tag: " + string));
            return false;
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, Race race) {
        BigDecimal bigDecimal = (BigDecimal)loadContext.getObjectContext().getObject((CDOMObject)race, ObjectKey.FACE_WIDTH);
        BigDecimal bigDecimal2 = (BigDecimal)loadContext.getObjectContext().getObject((CDOMObject)race, ObjectKey.FACE_HEIGHT);
        if (bigDecimal == null && bigDecimal2 == null) {
            return null;
        }
        if (bigDecimal == null || bigDecimal2 == null) {
            loadContext.addWriteMessage("Must have both width and height in " + this.getTokenName() + ": " + bigDecimal + " " + bigDecimal2);
            return null;
        }
        if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
            loadContext.addWriteMessage("Cannot have negative width in " + this.getTokenName() + ": " + bigDecimal);
            return null;
        }
        if (bigDecimal2.compareTo(BigDecimal.ZERO) < 0) {
            loadContext.addWriteMessage("Cannot have negative height in " + this.getTokenName() + ": " + bigDecimal2);
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        BigDecimal bigDecimal3 = BigDecimalHelper.trimBigDecimal((BigDecimal)bigDecimal);
        stringBuilder.append(bigDecimal3);
        if (bigDecimal2.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal bigDecimal4 = BigDecimalHelper.trimBigDecimal((BigDecimal)bigDecimal2);
            stringBuilder.append(',').append(bigDecimal4);
        }
        return new String[]{stringBuilder.toString()};
    }

    public Class<Race> getTokenClass() {
        return Race.class;
    }
}

