/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import pcgen.core.NoteItem;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotesPanel
extends FlippingSplitPane {
    private PlayerCharacter pc;
    private boolean textIsDirty = false;
    private NoteItem bioNote = null;
    private NoteItem companionNote = null;
    private NoteItem currentItem = null;
    private NoteItem descriptionNote = null;
    private NoteItem lastItem = null;
    private NoteItem magicItemsNote = null;
    private NoteItem otherAssetsNote = null;
    private NoteTreeNode rootTreeNode;
    private DefaultTreeModel notesModel;
    private int serial = 0;
    private static final int BIO_NOTEID = -2;
    private static final int DESCRIPTION_NOTEID = -3;
    private static final int COMPANION_NOTEID = -4;
    private static final int OTHERASSETS_NOTEID = -5;
    private static final int MAGICITEMS_NOTEID = -6;
    private JButton addButton;
    private JButton deleteButton;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JToolBar jToolBar1;
    private JButton moveButton;
    private JTextArea notesArea;
    private JTree notesTree;
    private JButton renameButton;

    public NotesPanel() {
        this.initComponents();
        this.addListeners();
        this.initPrefs();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.notesArea = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.notesTree = new JTree();
        this.jToolBar1 = new JToolBar();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.renameButton = new JButton();
        this.moveButton = new JButton();
        this.setDividerSize(1);
        this.setOrientation(0);
        this.setPreferredSize(new Dimension(360, 78));
        this.notesArea.setLineWrap(true);
        this.notesArea.setWrapStyleWord(true);
        this.notesArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                NotesPanel.this.notesAreaFocusLost();
            }
        });
        this.jScrollPane1.setViewportView(this.notesArea);
        this.setBottomComponent(this.jScrollPane1);
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane2.setViewportView(this.notesTree);
        this.jPanel1.add((Component)this.jScrollPane2, "Center");
        this.addButton.setText(PropertyFactory.getString((String)"in_add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesPanel.this.addButtonActionPerformed();
            }
        });
        this.jToolBar1.add(this.addButton);
        this.deleteButton.setText(PropertyFactory.getString((String)"in_delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesPanel.this.deleteButtonActionPerformed();
            }
        });
        this.jToolBar1.add(this.deleteButton);
        this.renameButton.setText(PropertyFactory.getString((String)"in_rename"));
        this.renameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesPanel.this.renameButtonActionPerformed();
            }
        });
        this.jToolBar1.add(this.renameButton);
        this.moveButton.setText(PropertyFactory.getString((String)"in_move"));
        this.moveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesPanel.this.moveButtonActionPerformed();
            }
        });
        this.jToolBar1.add(this.moveButton);
        this.jPanel1.add((Component)this.jToolBar1, "South");
        this.setTopComponent(this.jPanel1);
    }

    private void addButtonActionPerformed() {
        this.addNode();
    }

    private void deleteButtonActionPerformed() {
        this.deleteNode();
    }

    private void renameButtonActionPerformed() {
        this.renameNode();
    }

    private void moveButtonActionPerformed() {
        this.moveNode();
    }

    private void notesAreaFocusLost() {
        this.updateNoteItem();
    }

    private void initPrefs() {
        int n = SettingsHandler.getGMGenOption((String)"CharacterSheet.notes.DividerLocation", (int)100);
        this.setDividerLocation(n);
    }

    public void flushPrefs() {
        SettingsHandler.setGMGenOption((String)"CharacterSheet.notes.DividerLocation", (int)this.getDividerLocation());
    }

    private void addNode() {
        TreePath treePath = this.notesTree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        NoteTreeNode noteTreeNode = (NoteTreeNode)treePath.getLastPathComponent();
        noteTreeNode.addNote();
        this.notesTree.updateUI();
        this.notesTree.expandPath(treePath);
    }

    private void deleteNode() {
        TreePath treePath = this.notesTree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        if (object == null || ((NoteTreeNode)object).getItem() == null) {
            return;
        }
        NoteTreeNode noteTreeNode = (NoteTreeNode)object;
        noteTreeNode.deleteNote();
        this.notesTree.updateUI();
    }

    private void renameNode() {
        TreePath treePath = this.notesTree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        this.notesTree.startEditingAtPath(treePath);
    }

    private void moveNode() {
        this.lastItem = this.currentItem;
    }

    private void addListeners() {
        this.notesArea.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                NotesPanel.this.docChange(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                NotesPanel.this.docChange(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NotesPanel.this.docChange(documentEvent);
            }
        });
        this.notesTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = NotesPanel.this.notesTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = NotesPanel.this.notesTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 1 && treePath != null) {
                    NotesPanel.this.selectNotesNode(n);
                }
                NotesPanel.this.lastItem = null;
            }
        });
        this.notesTree.getModel();
        this.notesTree.setEditable(true);
        this.notesTree.addMouseListener(new NotePopupListener(this.notesTree, new NotePopupMenu()));
    }

    public void docChange(DocumentEvent documentEvent) {
        this.textIsDirty = true;
    }

    public void setPc(PlayerCharacter playerCharacter, Properties properties) {
        if (this.pc != playerCharacter) {
            this.pc = playerCharacter;
            this.serial = 0;
            this.populateNotes();
        }
    }

    public void refresh() {
        if (this.serial < this.pc.getSerial()) {
            if (this.currentItem != null) {
                this.updateNoteItem();
            }
            this.establishTreeNodes();
            this.notesTree.expandRow(0);
            this.selectNotesNode(this.getCSNode());
            this.serial = this.pc.getSerial();
        }
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    public void clear() {
        this.rootTreeNode.removeAllChildren();
        this.bioNote = null;
        this.companionNote = null;
        this.currentItem = null;
        this.descriptionNote = null;
        this.lastItem = null;
        this.magicItemsNote = null;
        this.otherAssetsNote = null;
    }

    private void populateNotes() {
        ArrayList arrayList = this.pc.getNotesList();
        NoteItem noteItem = null;
        int n = 0;
        for (NoteItem noteItem2 : arrayList) {
            if (noteItem2.getId() > n) {
                n = noteItem2.getId();
            }
            if (!noteItem2.getName().equals("Character Sheet Notes")) continue;
            noteItem = noteItem2;
        }
        if (noteItem == null) {
            noteItem = new NoteItem(++n, -1, "Character Sheet Notes", "");
            this.pc.addNotesItem(noteItem);
        }
        this.establishTreeNodes();
    }

    private NoteTreeNode getCSNode() {
        Enumeration<TreeNode> enumeration = this.rootTreeNode.children();
        while (enumeration.hasMoreElements()) {
            NoteTreeNode noteTreeNode = (NoteTreeNode)enumeration.nextElement();
            if (!noteTreeNode.toString().equals("Character Sheet Notes")) continue;
            return noteTreeNode;
        }
        return this.rootTreeNode;
    }

    public void updateProperties() {
    }

    private void establishTreeNodes() {
        ArrayList<NoteItem> arrayList = new ArrayList<NoteItem>();
        int n = 0;
        this.rootTreeNode = new NoteTreeNode(null, this.pc);
        this.notesModel = new DefaultTreeModel(this.rootTreeNode);
        this.notesTree.setModel(this.notesModel);
        ArrayList arrayList2 = this.pc.getNotesList();
        for (NoteItem noteItem : arrayList2) {
            arrayList.add(noteItem);
        }
        this.bioNote = new NoteItem(-2, -1, "Bio", this.pc.getBio());
        arrayList.add(n++, this.bioNote);
        this.descriptionNote = new NoteItem(-3, -1, PropertyFactory.getString((String)"in_descrip"), this.pc.getDescription());
        arrayList.add(n++, this.descriptionNote);
        this.companionNote = new NoteItem(-4, -1, PropertyFactory.getString((String)"in_companions"), (String)this.pc.getMiscList().get(1));
        arrayList.add(n++, this.companionNote);
        this.otherAssetsNote = new NoteItem(-5, -1, PropertyFactory.getString((String)"in_otherAssets"), (String)this.pc.getMiscList().get(0));
        arrayList.add(n++, this.otherAssetsNote);
        this.magicItemsNote = new NoteItem(-6, -1, PropertyFactory.getString((String)"in_magicItems"), (String)this.pc.getMiscList().get(2));
        arrayList.add(n++, this.magicItemsNote);
        this.addNodes(this.rootTreeNode, arrayList);
    }

    private void addNodes(NoteTreeNode noteTreeNode, List<NoteItem> list) {
        int n = -1;
        if (noteTreeNode.getItem() != null) {
            n = noteTreeNode.getItem().getId();
        }
        Iterator<NoteItem> iterator = list.iterator();
        while (iterator.hasNext()) {
            NoteItem noteItem = iterator.next();
            if (noteItem.getParentId() != n) continue;
            NoteTreeNode noteTreeNode2 = new NoteTreeNode(noteItem, this.pc);
            noteTreeNode.add(noteTreeNode2);
            iterator.remove();
        }
        for (int i = 0; i < noteTreeNode.getChildCount(); ++i) {
            this.addNodes((NoteTreeNode)noteTreeNode.getChildAt(i), list);
        }
    }

    private void selectNotesNode(int n) {
        this.notesTree.requestFocus();
        this.notesTree.setSelectionRow(n);
        TreePath treePath = this.notesTree.getSelectionPath();
        Object object = treePath.getLastPathComponent();
        if (object != null && object instanceof NoteTreeNode) {
            this.selectNotesNode((NoteTreeNode)object);
        }
    }

    private void selectNotesNode(NoteTreeNode noteTreeNode) {
        NoteItem noteItem;
        if (this.currentItem != null) {
            this.updateNoteItem();
        }
        this.notesTree.expandPath(new TreePath(this.notesModel.getPathToRoot(noteTreeNode)));
        this.currentItem = noteItem = noteTreeNode.getItem();
        if (noteItem != null) {
            this.notesArea.setText(this.currentItem.getValue());
            if (this.lastItem != null) {
                int n = this.currentItem.getParentId();
                this.currentItem.setParentId(this.lastItem.getParentId());
                this.lastItem.setParentId(n);
                this.establishTreeNodes();
                this.notesModel.setRoot(this.rootTreeNode);
                this.notesTree.updateUI();
            }
            this.notesArea.setEnabled(true);
            this.notesArea.setEditable(true);
        } else {
            this.notesArea.setText(PropertyFactory.getString((String)"in_idNoteEdit"));
            this.notesArea.setEnabled(false);
            this.notesArea.setEditable(false);
        }
        this.notesArea.setCaretPosition(0);
    }

    private void updateNoteItem() {
        if (this.currentItem != null && this.textIsDirty) {
            int n = this.pc.getNotesList().indexOf(this.currentItem);
            this.currentItem.setValue(this.notesArea.getText());
            if (n > -1) {
                ((NoteItem)this.pc.getNotesList().get(n)).setValue(this.notesArea.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.bioNote) {
                this.pc.setBio(this.notesArea.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.descriptionNote) {
                this.pc.setDescription(this.notesArea.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.otherAssetsNote) {
                this.pc.getMiscList().set(0, this.notesArea.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.companionNote) {
                this.pc.getMiscList().set(1, this.notesArea.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.magicItemsNote) {
                this.pc.getMiscList().set(2, this.notesArea.getText());
                this.pc.setDirty(true);
            }
            this.textIsDirty = false;
        }
    }

    private class NotePopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = -8015559748421397718L;

        NotePopupMenu() {
            this.add(this.createAddMenuItem(PropertyFactory.getString((String)"in_add"), "shortcut EQUALS"));
            this.add(this.createRemoveMenuItem(PropertyFactory.getString((String)"in_remove"), "shortcut MINUS"));
            this.add(this.createRenameMenuItem(PropertyFactory.getString((String)"in_rename"), "alt M"));
        }

        private JMenuItem createAddMenuItem(String string, String string2) {
            return Utility.createMenuItem((String)string, (ActionListener)new AddNoteActionListener(), (String)PropertyFactory.getString((String)"in_add"), (char)'\u0000', (String)string2, (String)PropertyFactory.getString((String)"in_add"), (String)"Add16.gif", (boolean)true);
        }

        private JMenuItem createRemoveMenuItem(String string, String string2) {
            return Utility.createMenuItem((String)string, (ActionListener)new RemoveNoteActionListener(), (String)PropertyFactory.getString((String)"in_delete"), (char)'\u0000', (String)string2, (String)PropertyFactory.getString((String)"in_delete"), (String)"Remove16.gif", (boolean)true);
        }

        private JMenuItem createRenameMenuItem(String string, String string2) {
            return Utility.createMenuItem((String)string, (ActionListener)new RenameNoteActionListener(), (String)PropertyFactory.getString((String)"in_rename"), (char)'\u0000', (String)string2, (String)PropertyFactory.getString((String)"in_rename"), (String)"Add16.gif", (boolean)true);
        }

        private class RenameNoteActionListener
        extends NoteActionListener {
            RenameNoteActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                NotesPanel.this.renameButton.doClick();
            }
        }

        private class RemoveNoteActionListener
        extends NoteActionListener {
            RemoveNoteActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                NotesPanel.this.deleteButton.doClick();
            }
        }

        private class NoteActionListener
        implements ActionListener {
            NoteActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        }

        private class AddNoteActionListener
        extends NoteActionListener {
            AddNoteActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                NotesPanel.this.addButton.doClick();
            }
        }
    }

    private class NotePopupListener
    extends MouseAdapter {
        private JTree aNotesTree;
        private NotePopupMenu notesMenu;

        NotePopupListener(JTree jTree, NotePopupMenu notePopupMenu) {
            this.aNotesTree = jTree;
            this.notesMenu = notePopupMenu;
            KeyListener keyListener = new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    NotesPanel.this.dispatchEvent(keyEvent);
                }

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                        for (int i = 0; i < NotePopupListener.this.notesMenu.getComponentCount(); ++i) {
                            JMenuItem jMenuItem = (JMenuItem)NotePopupListener.this.notesMenu.getComponent(i);
                            KeyStroke keyStroke2 = jMenuItem.getAccelerator();
                            if (keyStroke2 == null || !keyStroke.equals(keyStroke2)) continue;
                            jMenuItem.doClick(2);
                            return;
                        }
                    }
                    NotesPanel.this.dispatchEvent(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    NotesPanel.this.dispatchEvent(keyEvent);
                }
            };
            jTree.addKeyListener(keyListener);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                TreePath treePath = this.aNotesTree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                this.aNotesTree.setSelectionPath(treePath);
                this.notesMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private static class NoteTreeNode
    extends DefaultMutableTreeNode {
        static final long serialVersionUID = -8015559748421397718L;
        private NoteItem item;
        private PlayerCharacter pc;

        NoteTreeNode(NoteItem noteItem, PlayerCharacter playerCharacter) {
            this.item = noteItem;
            this.pc = playerCharacter;
        }

        public String toString() {
            if (this.item != null) {
                return this.item.toString();
            }
            return this.pc.getDisplayName();
        }

        public void setUserObject(Object object) {
            super.setUserObject(object);
            this.renameNote((String)object);
        }

        private final NoteItem getItem() {
            return this.item;
        }

        public void renameNote(String string) {
            this.getItem().setName(string);
            this.pc.setDirty(true);
        }

        public void deleteNote() {
            NoteTreeNode noteTreeNode;
            Object object;
            int n = 0;
            Enumeration<TreeNode> enumeration = this.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                object = (NoteTreeNode)enumeration.nextElement();
                if (object == this) continue;
                ++n;
            }
            object = n > 0 ? PropertyFactory.getFormattedString((String)"in_delNote1", (Object[])new Object[]{this.toString(), String.valueOf(n)}) : PropertyFactory.getFormattedString((String)"in_delNote2", (Object[])new Object[]{this.toString()});
            int n2 = JOptionPane.showConfirmDialog(null, object, PropertyFactory.getString((String)"in_delNote4"), 2);
            if (n2 == 0 && (noteTreeNode = (NoteTreeNode)this.getParent()) != null) {
                enumeration = this.breadthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    NoteTreeNode noteTreeNode2 = (NoteTreeNode)enumeration.nextElement();
                    this.pc.getNotesList().remove(noteTreeNode2.getItem());
                }
                noteTreeNode.remove(this);
                this.pc.setDirty(true);
            }
        }

        public void addNote() {
            Object object2;
            int n = -1;
            int n2 = 0;
            n = this.getItem().getId();
            for (Object object2 : this.pc.getNotesList()) {
                if (object2.getId() <= n2) continue;
                n2 = object2.getId();
            }
            NoteItem noteItem = new NoteItem(++n2, n, PropertyFactory.getString((String)"in_newItem"), PropertyFactory.getString((String)"in_newValue"));
            object2 = new NoteTreeNode(noteItem, this.pc);
            this.add((MutableTreeNode)object2);
            this.pc.addNotesItem(noteItem);
            this.pc.setDirty(true);
        }
    }
}

