/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import gmgen.plugin.PlayerCharacterOutput;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import plugin.charactersheet.gui.CharacterPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArmorPane
extends JPanel {
    private PlayerCharacter pc;
    private List<Component> fields = new ArrayList<Component>();
    private JLabel typeName;
    private JPanel typeNamePanel;
    private JPanel typePanel;
    private JPanel acPanel;
    private JPanel maxDexPanel;
    private JPanel checkPanel;
    private JPanel failurePanel;
    private static final Font FONT_TEN = new Font("Dialog", 0, 10);
    private static final String ARMOR_TEXT = " ARMOR ";
    private static final String TYPE_TEXT = " Type ";
    private static final String AC_TEXT = " AC ";
    private static final String MAX_DEX_TEXT = " Max Dex ";
    private static final String CHECK_TEXT = " Check ";
    private static final String FAIL_TEXT = " Spell Failure ";
    private static final String BLANK = "";
    private static final String SPACE = " ";
    private static final String ARMOR = "ARMOR";
    private static final String SHIELD = "SHIELD";
    private static final String ITEM = "ITEM";
    private static final String AC = "AC";
    private static final String NAME = "NAME";
    private static final String TYPE = "TYPE";
    private static final String ACBONUS = "ACBONUS";
    private static final String MAXDEX = "MAXDEX";
    private static final String ACCHECK = "ACCHECK";
    private static final String SPELLFAIL = "SPELLFAIL";
    private static final String SPROPS = "SPROPS";

    public ArmorPane() {
        this.initComponents();
        this.setColor();
    }

    private void initComponents() {
        this.typeNamePanel = new JPanel();
        this.typeName = new JLabel();
        this.typePanel = new JPanel();
        this.acPanel = new JPanel();
        this.maxDexPanel = new JPanel();
        this.checkPanel = new JPanel();
        this.failurePanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.typeNamePanel.setLayout(new FlowLayout(1, 1, 0));
        this.typeName.setFont(FONT_TEN);
        this.typeName.setText(ARMOR_TEXT);
        this.typeNamePanel.add(this.typeName);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.typeNamePanel, gridBagConstraints);
        this.typePanel.setLayout(new FlowLayout(1, 1, 0));
        JLabel jLabel = new JLabel();
        jLabel.setFont(FONT_TEN);
        jLabel.setText(TYPE_TEXT);
        this.typePanel.add(jLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.typePanel, gridBagConstraints);
        this.acPanel.setLayout(new FlowLayout(1, 1, 0));
        JLabel jLabel2 = new JLabel();
        jLabel2.setFont(FONT_TEN);
        jLabel2.setText(AC_TEXT);
        this.acPanel.add(jLabel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.acPanel, gridBagConstraints);
        this.maxDexPanel.setLayout(new FlowLayout(1, 1, 0));
        JLabel jLabel3 = new JLabel();
        jLabel3.setFont(FONT_TEN);
        jLabel3.setText(MAX_DEX_TEXT);
        this.maxDexPanel.add(jLabel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.maxDexPanel, gridBagConstraints);
        this.checkPanel.setLayout(new FlowLayout(1, 1, 0));
        JLabel jLabel4 = new JLabel();
        jLabel4.setFont(FONT_TEN);
        jLabel4.setText(CHECK_TEXT);
        this.checkPanel.add(jLabel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.checkPanel, gridBagConstraints);
        this.failurePanel.setLayout(new FlowLayout(1, 1, 0));
        JLabel jLabel5 = new JLabel();
        jLabel5.setFont(FONT_TEN);
        jLabel5.setText(FAIL_TEXT);
        this.failurePanel.add(jLabel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.failurePanel, gridBagConstraints);
    }

    public void setColor() {
        this.refresh();
        this.setBackground(CharacterPanel.border);
        this.typeNamePanel.setBackground(CharacterPanel.header);
        this.typePanel.setBackground(CharacterPanel.header);
        this.acPanel.setBackground(CharacterPanel.header);
        this.maxDexPanel.setBackground(CharacterPanel.header);
        this.checkPanel.setBackground(CharacterPanel.header);
        this.failurePanel.setBackground(CharacterPanel.header);
        this.setBorder(new LineBorder(CharacterPanel.border));
        this.typeNamePanel.setBorder(new LineBorder(CharacterPanel.border));
        this.typePanel.setBorder(new LineBorder(CharacterPanel.border));
        this.acPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.maxDexPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.checkPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.failurePanel.setBorder(new LineBorder(CharacterPanel.border));
    }

    public void setPc(PlayerCharacter playerCharacter, String string) {
        this.pc = playerCharacter;
        this.typeName.setText(string);
    }

    public void refresh() {
        PlayerCharacterOutput playerCharacterOutput = new PlayerCharacterOutput(this.pc);
        String string = this.typeName.getText();
        for (int i = 0; i < this.fields.size(); ++i) {
            this.remove(this.fields.get(i));
        }
        this.fields.clear();
        List<Equipment> list = this.getArmorList(string);
        if (list.size() == 0) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
            int n = 1;
            for (int i = 0; i < list.size(); ++i) {
                Color color = i % 2 == 0 ? CharacterPanel.bodyLight : CharacterPanel.bodyMedLight;
                list.get(i);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(ARMOR).append('.').append(string).append('.').append(i).append('.');
                this.addField(0, n, playerCharacterOutput.getExportToken(stringBuffer.toString() + NAME), color);
                this.addField(1, n, playerCharacterOutput.getExportToken(stringBuffer.toString() + TYPE), color);
                this.addField(2, n, playerCharacterOutput.getExportToken(stringBuffer.toString() + ACBONUS), color);
                this.addField(3, n, playerCharacterOutput.getExportToken(stringBuffer.toString() + MAXDEX), color);
                this.addField(4, n, playerCharacterOutput.getExportToken(stringBuffer.toString() + ACCHECK), color);
                this.addField(5, n, playerCharacterOutput.getExportToken(stringBuffer.toString() + SPELLFAIL), color);
                String string2 = playerCharacterOutput.getExportToken(stringBuffer.toString() + SPROPS);
                if (!string2.equals(BLANK)) {
                    this.addSprops(++n, string2, color);
                }
                ++n;
            }
        }
        this.revalidate();
        this.repaint();
    }

    private List<Equipment> getArmorList(String string) {
        List<Equipment> list = new ArrayList();
        if (string.equals(ARMOR)) {
            list = this.pc.getEquipmentOfTypeInOutputOrder(ARMOR, 3);
        } else if (string.equals(SHIELD)) {
            list = this.pc.getEquipmentOfTypeInOutputOrder(SHIELD, 3);
        } else if (string.equals(ITEM)) {
            for (Equipment equipment : this.pc.getEquipmentListInOutputOrder()) {
                if (!equipment.getBonusListString(AC) || equipment.isArmor() || equipment.isShield()) continue;
                list.add(equipment);
            }
        }
        return list;
    }

    private void addField(int n, int n2, String string, Color color) {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        jPanel.setBackground(color);
        jPanel.setLayout(new FlowLayout(1, 1, 0));
        jLabel.setFont(FONT_TEN);
        String string2 = string;
        if (string.equals(BLANK)) {
            string2 = SPACE;
        }
        jLabel.setText(string2);
        jPanel.add(jLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel, gridBagConstraints);
        this.fields.add(jPanel);
    }

    private void addSprops(int n, String string, Color color) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(FONT_TEN);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setText(string);
        jTextArea.setBackground(color);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.add((Component)jTextArea, gridBagConstraints);
        this.fields.add(jTextArea);
    }

    public void destruct() {
    }
}

