/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;

public class MoveToken
extends Token {
    public static final String TOKENNAME = "MOVE";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            String string3;
            int n = Integer.parseInt(stringTokenizer.nextToken());
            string2 = stringTokenizer.hasMoreTokens() ? ("NAME".equals(string3 = stringTokenizer.nextToken()) ? MoveToken.getNameToken(playerCharacter, n) : ("RATE".equals(string3) ? MoveToken.getRateToken(playerCharacter, n) : ("SQUARES".equals(string3) ? MoveToken.getSquaresToken(playerCharacter, n) : MoveToken.getMoveToken(playerCharacter)))) : MoveToken.getMoveXToken(playerCharacter, n);
        }
        return string2;
    }

    public static String getMoveToken(PlayerCharacter playerCharacter) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < playerCharacter.getNumberOfMovements(); ++i) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(MoveToken.getMoveXToken(playerCharacter, i));
        }
        return stringBuffer.toString();
    }

    public static String getMoveXToken(PlayerCharacter playerCharacter, int n) {
        return MoveToken.getNameToken(playerCharacter, n) + " " + MoveToken.getRateToken(playerCharacter, n);
    }

    public static String getNameToken(PlayerCharacter playerCharacter, int n) {
        return playerCharacter.getMovementType(n);
    }

    public static String getRateToken(PlayerCharacter playerCharacter, int n) {
        return Globals.getGameModeUnitSet().displayDistanceInUnitSet(playerCharacter.movement(n)) + Globals.getGameModeUnitSet().getDistanceUnit();
    }

    public static String getSquaresToken(PlayerCharacter playerCharacter, int n) {
        return Integer.toString((int)(playerCharacter.movement(n) / Globals.getGameModeSquareSize()));
    }
}

