/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.awt.Toolkit;
import java.text.NumberFormat;
import pcgen.util.PropertyFactory;

public class Logging {
    private static boolean debugMode = false;
    private static final Toolkit s_TOOLKIT = Toolkit.getDefaultToolkit();

    public static void setDebugMode(boolean bl) {
        debugMode = bl;
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static void debugPrint(String string) {
        if (Logging.isDebugMode()) {
            System.out.println(string);
        }
    }

    public static void debugPrint(String string, Object object) {
        if (Logging.isDebugMode()) {
            System.out.println(string + object);
        }
    }

    public static void debugPrintLocalised(String string, Object object) {
        if (Logging.isDebugMode()) {
            String string2 = PropertyFactory.getFormattedString(string, object);
            System.out.println(string2);
        }
    }

    public static void debugPrintLocalised(String string, Object object, Object object2) {
        if (Logging.isDebugMode()) {
            String string2 = PropertyFactory.getFormattedString(string, object, object2);
            System.out.println(string2);
        }
    }

    public static void debugPrint(String string, Throwable throwable) {
        Logging.debugPrint(string);
    }

    public static void errorPrintLocalised(String string) {
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        String string2 = PropertyFactory.getString(string);
        System.err.println(string2);
    }

    public static void errorPrintLocalised(String string, Object ... objectArray) {
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        String string2 = PropertyFactory.getFormattedString(string, objectArray);
        System.err.println(string2);
    }

    public static void errorPrint(String string) {
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        System.err.println(string);
    }

    public static void errorPrint(String string, Throwable throwable) {
        Logging.errorPrint(string);
        throwable.printStackTrace(System.err);
    }

    public static void errorPrintLocalised(String string, Throwable throwable) {
        Logging.errorPrint(PropertyFactory.getString(string));
        throwable.printStackTrace(System.err);
    }

    public static void memoryReport() {
        System.out.println(Logging.memoryReportStr());
    }

    public static String memoryReportStr() {
        Runtime runtime = Runtime.getRuntime();
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        StringBuffer stringBuffer = new StringBuffer("Memory: ");
        stringBuffer.append(numberFormat.format((double)runtime.totalMemory() / 1024.0));
        stringBuffer.append("Kb total, ");
        stringBuffer.append(numberFormat.format((double)runtime.freeMemory() / 1024.0));
        stringBuffer.append("Kb free, ");
        stringBuffer.append(numberFormat.format((double)runtime.maxMemory() / 1024.0));
        stringBuffer.append("Kb max.");
        return stringBuffer.toString();
    }

    public static void PrintStackTrace() {
        String string = null;
        try {
            string.length();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }
}

