/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreMultParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreParserFactory {
    private static PreParserFactory instance = null;
    private static Map<String, PrerequisiteParserInterface> parserLookup = new HashMap<String, PrerequisiteParserInterface>();

    private PreParserFactory() throws PersistenceLayerException {
        PreParserFactory.register(new PreMultParser());
    }

    public static PreParserFactory getInstance() throws PersistenceLayerException {
        if (instance == null) {
            instance = new PreParserFactory();
        }
        return instance;
    }

    public PrerequisiteParserInterface getParser(String string) {
        return parserLookup.get(string.toLowerCase());
    }

    public static void register(PrerequisiteParserInterface prerequisiteParserInterface) throws PersistenceLayerException {
        String[] stringArray = prerequisiteParserInterface.kindsHandled();
        for (int i = 0; i < stringArray.length; ++i) {
            PrerequisiteParserInterface prerequisiteParserInterface2 = parserLookup.get(stringArray[i].toLowerCase());
            if (prerequisiteParserInterface2 != null) {
                throw new PersistenceLayerException("Error registering '" + prerequisiteParserInterface.getClass().getName() + "' as test '" + stringArray[i] + "'. The test is already registered to '" + prerequisiteParserInterface2.getClass().getName() + "'");
            }
            parserLookup.put(stringArray[i].toLowerCase(), prerequisiteParserInterface);
        }
    }

    public List<Prerequisite> parse(List<String> list) {
        ArrayList<Prerequisite> arrayList = new ArrayList<Prerequisite>(list.size());
        for (String string : list) {
            try {
                PreParserFactory preParserFactory = PreParserFactory.getInstance();
                Prerequisite prerequisite = preParserFactory.parse(string);
                arrayList.add(prerequisite);
            }
            catch (PersistenceLayerException persistenceLayerException) {
                Logging.errorPrint(persistenceLayerException.getMessage(), persistenceLayerException);
            }
        }
        return arrayList;
    }

    public Prerequisite parse(String string) throws PersistenceLayerException {
        PrerequisiteParserInterface prerequisiteParserInterface;
        if (string == null || string.length() <= 0) {
            throw new PersistenceLayerException("Null or empty PRE string");
        }
        int n = string.indexOf(58);
        if (n < 0) {
            throw new PersistenceLayerException("'" + string + "'" + " is a badly formatted prereq.");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if ("pre".equals(string2.toLowerCase()) && ".clear".equals(string3.toLowerCase())) {
            Prerequisite prerequisite = new Prerequisite();
            prerequisite.setKind("clear");
            return prerequisite;
        }
        boolean bl = false;
        if (string3.startsWith("Q:")) {
            string3 = string3.substring(2);
            bl = true;
        }
        boolean bl2 = false;
        if (string2.startsWith("!")) {
            bl2 = true;
            string2 = string2.substring(1);
        }
        if ((prerequisiteParserInterface = this.getParser(string2 = string2.substring(3))) == null) {
            throw new PersistenceLayerException("Can not determine which parser to use for '" + string + "'");
        }
        try {
            Prerequisite prerequisite = prerequisiteParserInterface.parse(string2, string3, bl2, bl);
            while (prerequisite.getKind() == null && prerequisite.getPrerequisites().size() == 1 && prerequisite.getOperator().equals(PrerequisiteOperator.GTEQ) && prerequisite.getOperand().equals("1")) {
                prerequisite = prerequisite.getPrerequisites().get(0);
            }
            return prerequisite;
        }
        catch (Throwable throwable) {
            throw new PersistenceLayerException("Can not parse '" + string + "': " + throwable.getMessage());
        }
    }

    public static boolean isPreReqString(String string) {
        return (string.startsWith("PRE") || string.startsWith("!PRE")) && string.indexOf(":") > 0;
    }

    public static Prerequisite createLevelPrereq(PObject pObject, int n) throws PersistenceLayerException {
        PreParserFactory preParserFactory = PreParserFactory.getInstance();
        String string = "PRELEVEL:" + n;
        if (pObject instanceof PCClass) {
            string = "PRECLASS:1," + pObject.getKeyName() + "=" + n;
        }
        return preParserFactory.parse(string);
    }
}

