/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.WeaponProf;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.TokenStore;
import pcgen.persistence.lst.WeaponProfLstToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WeaponProfLoader
extends LstObjectFileLoader<WeaponProf> {
    @Override
    public WeaponProf parseLine(WeaponProf weaponProf, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        WeaponProf weaponProf2 = weaponProf;
        if (weaponProf2 == null) {
            weaponProf2 = new WeaponProf();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        int n = 0;
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(WeaponProfLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n2 = string2.indexOf(58);
            String string3 = "";
            try {
                string3 = string2.substring(0, n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            WeaponProfLstToken weaponProfLstToken = (WeaponProfLstToken)map.get(string3);
            if (n == 0) {
                weaponProf2.setName(string2);
                weaponProf2.setKeyName(string2);
                weaponProf2.setSourceCampaign(campaignSourceEntry.getCampaign());
                weaponProf2.setSourceURI(campaignSourceEntry.getURI());
            } else if (weaponProfLstToken != null) {
                String string4 = string2.substring(n2 + 1).trim();
                LstUtils.deprecationCheck(weaponProfLstToken, weaponProf2, string4);
                if (!weaponProfLstToken.parse(weaponProf2, string4)) {
                    Logging.errorPrint("Error parsing skill " + weaponProf2.getDisplayName() + ':' + campaignSourceEntry.getURI() + ':' + string2 + "\"");
                }
            } else {
                if (PObjectLoader.parseTag(weaponProf2, string2)) continue;
                Logging.errorPrint("Illegal weapon proficiency info '" + string + "' in " + campaignSourceEntry.toString());
            }
            ++n;
        }
        this.completeObject(campaignSourceEntry, weaponProf2);
        return null;
    }

    @Override
    protected WeaponProf getObjectKeyed(String string) {
        return Globals.getWeaponProfKeyed(string);
    }

    @Override
    protected void performForget(WeaponProf weaponProf) {
        Globals.removeWeaponProfKeyed(weaponProf.getKeyName());
    }

    @Override
    protected void addGlobalObject(PObject pObject) {
        Globals.addWeaponProf((WeaponProf)pObject);
        pObject.setNewItem(false);
    }
}

